/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.world.generation.feature.features;

import com.matez.wildnature.util.config.CommonConfig;
import com.matez.wildnature.util.lists.WNBlocks;
import com.matez.wildnature.util.other.Utilities;
import com.matez.wildnature.util.other.WeightedList;
import com.matez.wildnature.world.generation.feature.WNFeatures;
import com.matez.wildnature.world.generation.feature.configs.BlockFeatureConfig;
import com.matez.wildnature.world.generation.transformer.BiomeTransformer;
import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraftforge.common.BiomeDictionary;

public class WNVegeFeature
extends Feature<NoFeatureConfig> {
    public static WeightedList<BushEntry> entries = new WeightedList();

    public WNVegeFeature(Function<Dynamic<?>, ? extends NoFeatureConfig> p_i49915_1_) {
        super(p_i49915_1_);
        this.setRegistryName("wildnature", "vege_feature");
    }

    public boolean place(IWorld worldIn, ChunkGenerator<? extends GenerationSettings> generator, Random rand, BlockPos pos, NoFeatureConfig config) {
        if (!worldIn.func_201675_m().func_76569_d()) {
            return false;
        }
        if (Utilities.rint(0, (Integer)CommonConfig.vegeCropChance.get()) != 0) {
            return false;
        }
        WeightedList available = new WeightedList();
        entries.forEach(e -> {
            if (e.canSpawnHere(pos, worldIn)) {
                available.add(e, entries.getRarityFor((BushEntry)e));
            }
        });
        if (!available.isEmpty()) {
            BushEntry b = (BushEntry)Utilities.getWeightedEntry(available, rand);
            assert (b != null);
            try {
                if (!((Boolean)CommonConfig.vegeGrassSpawn.get()).booleanValue()) {
                    if (b.needsFarmland()) {
                        WNFeatures.WILD_FARM_FEATURE.func_212245_a(worldIn, generator, rand, pos, (IFeatureConfig)new BlockFeatureConfig(b.getBush()));
                    } else {
                        WNFeatures.BUSH_FEATURE.func_212245_a(worldIn, generator, rand, pos, (IFeatureConfig)new BlockFeatureConfig(b.getBush()));
                    }
                } else {
                    WNFeatures.BUSH_FEATURE.func_212245_a(worldIn, generator, rand, pos, (IFeatureConfig)new BlockFeatureConfig(b.getBush()));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    public static void init() {
        new BushEntry(WNBlocks.BROCCOLI_PLANT.func_176223_P(), BiomeTransformer.TempCategory.WARM, 3, BiomeDictionary.Type.PLAINS);
        new BushEntry(WNBlocks.CABBAGE_PLANT.func_176223_P(), BiomeTransformer.TempCategory.TEMPERATE, 5, BiomeDictionary.Type.PLAINS);
        new BushEntry(WNBlocks.CAULIFLOWER_PLANT.func_176223_P(), BiomeTransformer.TempCategory.TEMPERATE, 5, BiomeDictionary.Type.PLAINS);
        new BushEntry(WNBlocks.CELERY_PLANT.func_176223_P(), BiomeTransformer.TempCategory.TEMPERATE, 5, BiomeDictionary.Type.PLAINS);
        new BushEntry(WNBlocks.CHIVES_PLANT.func_176223_P(), BiomeTransformer.TempCategory.COLD, 5, BiomeDictionary.Type.PLAINS);
        new BushEntry(WNBlocks.CUCUMBER_PLANT.func_176223_P(), BiomeTransformer.TempCategory.WARM, 5, BiomeDictionary.Type.PLAINS);
        new BushEntry(WNBlocks.GARLIC_PLANT.func_176223_P(), BiomeTransformer.TempCategory.COLD, 5, BiomeDictionary.Type.PLAINS);
        new BushEntry(WNBlocks.GINGER_PLANT.func_176223_P(), BiomeTransformer.TempCategory.COLD, 5, BiomeDictionary.Type.PLAINS);
        new BushEntry(WNBlocks.GREEN_PEPPER_PLANT.func_176223_P(), BiomeTransformer.TempCategory.WARM, 5, BiomeDictionary.Type.PLAINS);
        new BushEntry(WNBlocks.HORSE_RADISH_PLANT.func_176223_P(), BiomeTransformer.TempCategory.COLD, 5, false, BiomeDictionary.Type.PLAINS);
        new BushEntry(WNBlocks.LEEK_PLANT.func_176223_P(), BiomeTransformer.TempCategory.TEMPERATE, 5, BiomeDictionary.Type.PLAINS);
        new BushEntry(WNBlocks.LETTUCE_PLANT.func_176223_P(), BiomeTransformer.TempCategory.TEMPERATE, 5, BiomeDictionary.Type.PLAINS);
        new BushEntry(WNBlocks.ONION_PLANT.func_176223_P(), BiomeTransformer.TempCategory.TEMPERATE, 5, BiomeDictionary.Type.PLAINS);
        new BushEntry(WNBlocks.PEANUT_PLANT.func_176223_P(), BiomeTransformer.TempCategory.HOT, 3, BiomeDictionary.Type.PLAINS);
        new BushEntry(WNBlocks.PEA_PLANT.func_176223_P(), BiomeTransformer.TempCategory.TEMPERATE, 5, BiomeDictionary.Type.PLAINS);
        new BushEntry(WNBlocks.RED_ONION_PLANT.func_176223_P(), BiomeTransformer.TempCategory.WARM, 5, BiomeDictionary.Type.PLAINS);
        new BushEntry(WNBlocks.RED_PEPPER_PLANT.func_176223_P(), BiomeTransformer.TempCategory.WARM, 3, BiomeDictionary.Type.PLAINS);
        new BushEntry(WNBlocks.RHUBARB_PLANT.func_176223_P(), BiomeTransformer.TempCategory.TEMPERATE, 5, BiomeDictionary.Type.PLAINS);
        new BushEntry(WNBlocks.RICE_PLANT.func_176223_P(), BiomeTransformer.TempCategory.WARM, 5, false, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.WET);
        new BushEntry(WNBlocks.TOMATO_PLANT.func_176223_P(), BiomeTransformer.TempCategory.WARM, 5, BiomeDictionary.Type.PLAINS);
        new BushEntry(WNBlocks.TURNIP_PLANT.func_176223_P(), BiomeTransformer.TempCategory.TEMPERATE, 4, BiomeDictionary.Type.PLAINS);
        new BushEntry(WNBlocks.GREEN_BEANS_BUSH.func_176223_P(), BiomeTransformer.TempCategory.TEMPERATE, 4, false, BiomeDictionary.Type.PLAINS);
        new BushEntry(WNBlocks.GREEN_BEANS_BUSH.func_176223_P(), BiomeTransformer.TempCategory.WARM, 2, false, BiomeDictionary.Type.PLAINS);
        new BushEntry(WNBlocks.EGGPLANT_PLANT.func_176223_P(), BiomeTransformer.TempCategory.TEMPERATE, 3, BiomeDictionary.Type.PLAINS);
        new BushEntry(WNBlocks.EGGPLANT_PLANT.func_176223_P(), BiomeTransformer.TempCategory.WARM, 3, BiomeDictionary.Type.PLAINS);
        new BushEntry(WNBlocks.CORN_BUSH.func_176223_P(), BiomeTransformer.TempCategory.TEMPERATE, 4, false, BiomeDictionary.Type.PLAINS);
        new BushEntry(WNBlocks.CORN_BUSH.func_176223_P(), BiomeTransformer.TempCategory.WARM, 2, false, BiomeDictionary.Type.PLAINS);
        new BushEntry(WNBlocks.PINEAPPLE_PLANT.func_176223_P(), BiomeTransformer.TempCategory.WARM, 4, false, BiomeDictionary.Type.JUNGLE);
        new BushEntry(WNBlocks.PINEAPPLE_PLANT.func_176223_P(), BiomeTransformer.TempCategory.HOT, 4, false, BiomeDictionary.Type.JUNGLE);
        new BushEntry(WNBlocks.BASIL_PLANT.func_176223_P(), BiomeTransformer.TempCategory.WARM, 1, BiomeDictionary.Type.JUNGLE);
        new BushEntry(WNBlocks.MARJORAM_PLANT.func_176223_P(), BiomeTransformer.TempCategory.HOT, 1, BiomeDictionary.Type.JUNGLE);
        new BushEntry(WNBlocks.PARSLEY_PLANT.func_176223_P(), BiomeTransformer.TempCategory.WARM, 1, BiomeDictionary.Type.JUNGLE);
        new BushEntry(WNBlocks.SAGE_PLANT.func_176223_P(), BiomeTransformer.TempCategory.HOT, 1, BiomeDictionary.Type.JUNGLE);
        new BushEntry(WNBlocks.TURMERIC_PLANT.func_176223_P(), BiomeTransformer.TempCategory.HOT, 1, BiomeDictionary.Type.JUNGLE);
        new BushEntry(WNBlocks.CURRY_PLANT.func_176223_P(), BiomeTransformer.TempCategory.HOT, 1, BiomeDictionary.Type.JUNGLE);
        new BushEntry(WNBlocks.ROSEMARY_PLANT.func_176223_P(), BiomeTransformer.TempCategory.TEMPERATE, 1, BiomeDictionary.Type.JUNGLE);
        new BushEntry(WNBlocks.BLACK_TEA_PLANT.func_176223_P(), BiomeTransformer.TempCategory.HOT, 3, false, BiomeDictionary.Type.PLAINS);
        new BushEntry(WNBlocks.GREEN_TEA_PLANT.func_176223_P(), BiomeTransformer.TempCategory.HOT, 2, false, BiomeDictionary.Type.PLAINS);
        new BushEntry(WNBlocks.MELISSA_PLANT.func_176223_P(), BiomeTransformer.TempCategory.TEMPERATE, 3, false, BiomeDictionary.Type.PLAINS);
        new BushEntry(WNBlocks.MELISSA_PLANT.func_176223_P(), BiomeTransformer.TempCategory.WARM, 3, false, BiomeDictionary.Type.PLAINS);
        new BushEntry(WNBlocks.MINT_PLANT.func_176223_P(), BiomeTransformer.TempCategory.COLD, 4, false, BiomeDictionary.Type.PLAINS);
        new BushEntry(WNBlocks.MINT_PLANT.func_176223_P(), BiomeTransformer.TempCategory.WARM, 4, false, BiomeDictionary.Type.PLAINS);
        new BushEntry(WNBlocks.MINT_PLANT.func_176223_P(), BiomeTransformer.TempCategory.TEMPERATE, 4, false, BiomeDictionary.Type.PLAINS);
        new BushEntry(WNBlocks.WHITE_TEA.func_176223_P(), BiomeTransformer.TempCategory.HOT, 1, false, BiomeDictionary.Type.PLAINS);
        new BushEntry(WNBlocks.BLACK_PEPPER_PLANT.func_176223_P(), BiomeTransformer.TempCategory.HOT, 2, BiomeDictionary.Type.JUNGLE);
        new BushEntry(WNBlocks.COTTON_PLANT.func_176223_P(), BiomeTransformer.TempCategory.COLD, 3, false, BiomeDictionary.Type.PLAINS);
        new BushEntry(WNBlocks.COTTON_PLANT.func_176223_P(), BiomeTransformer.TempCategory.TEMPERATE, 2, false, BiomeDictionary.Type.PLAINS);
        new BushEntry(WNBlocks.COTTON_PLANT.func_176223_P(), BiomeTransformer.TempCategory.WARM, 2, false, BiomeDictionary.Type.PLAINS);
    }

    public static class BushEntry {
        private BlockState bush;
        private BiomeTransformer.TempCategory category;
        private BiomeDictionary.Type[] types;
        private int rarity;
        private boolean needsFarmland = true;

        public BushEntry(BlockState bush, BiomeTransformer.TempCategory tempCategory, int rarity, BiomeDictionary.Type ... types) {
            this.bush = bush;
            this.category = tempCategory;
            this.types = types;
            this.rarity = rarity;
            entries.add(this, rarity);
        }

        public BushEntry(BlockState bush, BiomeTransformer.TempCategory tempCategory, int rarity, boolean needsFarmland, BiomeDictionary.Type ... types) {
            this.bush = bush;
            this.category = tempCategory;
            this.types = types;
            this.rarity = rarity;
            this.needsFarmland = needsFarmland;
            entries.add(this, rarity);
        }

        public int getRarity() {
            return this.rarity;
        }

        public BlockState getBush() {
            return this.bush;
        }

        public boolean needsFarmland() {
            return this.needsFarmland;
        }

        public BiomeTransformer.TempCategory getCategory() {
            return this.category;
        }

        public BiomeDictionary.Type[] getTypes() {
            return this.types;
        }

        public boolean canSpawnHere(BlockPos pos, IWorld world) {
            Biome b = world.func_226691_t_(pos);
            if (BiomeTransformer.TempCategory.getFromTemperature(-0.1f, 1.0f, b.func_185353_n()) == this.category) {
                for (BiomeDictionary.Type t : this.types) {
                    if (!BiomeDictionary.getTypes((Biome)b).contains(t)) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

