/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.world.generation.feature.features;

import com.matez.wildnature.common.blocks.CropBase;
import com.matez.wildnature.common.blocks.EggPlant;
import com.matez.wildnature.common.blocks.GreenBeansBush;
import com.matez.wildnature.util.config.CommonConfig;
import com.matez.wildnature.util.lists.WNBlocks;
import com.matez.wildnature.util.other.Utilities;
import com.matez.wildnature.world.generation.biome.features.LogTypeUtils;
import com.matez.wildnature.world.generation.feature.WNFeatures;
import com.matez.wildnature.world.generation.feature.configs.BlockFeatureConfig;
import com.matez.wildnature.world.generation.feature.configs.WNBlobConfig;
import com.matez.wildnature.world.generation.feature.features.WNBlobFeature;
import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CropsBlock;
import net.minecraft.block.FarmlandBlock;
import net.minecraft.block.GrassBlock;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraftforge.common.IPlantable;

public class WNWildFarmFeature
extends Feature<BlockFeatureConfig> {
    public WNWildFarmFeature(Function<Dynamic<?>, ? extends BlockFeatureConfig> p_i51438_1_) {
        super(p_i51438_1_);
        this.setRegistryName("wildnature", "wild_farm_feature");
    }

    public boolean place(IWorld worldIn, ChunkGenerator<? extends GenerationSettings> generator, Random rand, BlockPos pos, BlockFeatureConfig config) {
        BlockState cropState = config.state;
        if (!worldIn.func_201675_m().func_76569_d()) {
            return false;
        }
        if (worldIn.func_180495_p(pos).canSustainPlant((IBlockReader)worldIn, pos.func_177977_b(), Direction.UP, (IPlantable)Blocks.field_196674_t)) {
            WNBlobFeature feature = (WNBlobFeature)WNFeatures.BLOB_FEATURE;
            Biome biome = worldIn.func_226691_t_(pos);
            Block theme = biome.func_203944_q().func_204108_a().func_177230_c();
            Block toPlace = null;
            toPlace = theme == WNBlocks.MOLD_GRASS_BLOCK ? WNBlocks.MOLD_FARMLAND : (theme == WNBlocks.BROWN_GRASS_BLOCK ? WNBlocks.BROWN_FARMLAND : (theme == WNBlocks.DRIED_GRASS_BLOCK ? WNBlocks.DRIED_FARMLAND : (theme == WNBlocks.DESERT_GRASS_BLOCK ? WNBlocks.DESERT_FARMLAND : (theme == WNBlocks.TROPICAL_GRASS_BLOCK ? WNBlocks.TROPICAL_FARMLAND : (theme == WNBlocks.BROWN_PODZOL ? WNBlocks.BROWN_FARMLAND : Blocks.field_150458_ak)))));
            Block fenceBlock = LogTypeUtils.getFenceFromBiome(biome, rand);
            feature.place(worldIn, generator, rand, pos, new WNBlobConfig((BlockState)toPlace.func_176223_P().func_206870_a((IProperty)FarmlandBlock.field_176531_a, (Comparable)Integer.valueOf(7)), Utilities.rint(1, 2), true, false));
            feature.getFilledBlocks().forEach(blockPos -> {
                if (!worldIn.func_180495_p(blockPos.func_177984_a()).func_200132_m()) {
                    worldIn.func_180501_a(blockPos.func_177984_a(), Blocks.field_150350_a.func_176223_P(), 2);
                }
            });
            BlockState crop = null;
            crop = cropState.func_177230_c() instanceof CropBase ? (BlockState)cropState.func_206870_a((IProperty)((CropBase)cropState.func_177230_c()).func_185524_e(), (Comparable)Integer.valueOf(Utilities.rint(((CropBase)cropState.func_177230_c()).func_185526_g() - 1, ((CropBase)cropState.func_177230_c()).func_185526_g()))) : cropState;
            int water = 0;
            int fence = 2;
            for (int j = 0; j < 256; ++j) {
                BlockPos blockpos = pos.func_177982_a(rand.nextInt(8) - rand.nextInt(8), rand.nextInt(4) - rand.nextInt(4), rand.nextInt(8) - rand.nextInt(8));
                if (!worldIn.func_175623_d(blockpos) || worldIn.func_201675_m().func_177495_o() && blockpos.func_177956_o() >= worldIn.func_201672_e().func_201675_m().getHeight()) continue;
                if (crop.func_196955_c((IWorldReader)worldIn, blockpos) && worldIn.func_180495_p(blockpos.func_177977_b()).func_177230_c() == Blocks.field_150458_ak) {
                    if (!worldIn.func_180495_p(blockpos).func_200132_m() && !(worldIn.func_180495_p(blockpos).func_177230_c() instanceof CropsBlock)) {
                        worldIn.func_180501_a(blockpos, Blocks.field_150350_a.func_176223_P(), 2);
                    }
                    if (Utilities.rint(0, water) == 0 && !Utilities.isBlockNear(worldIn, blockpos.func_177977_b(), Blocks.field_150350_a)) {
                        ++water;
                        worldIn.func_180501_a(blockpos.func_177977_b(), Blocks.field_150355_j.func_176223_P(), 2);
                        continue;
                    }
                    crop = cropState.func_177230_c() instanceof CropBase ? (BlockState)cropState.func_206870_a((IProperty)((CropBase)cropState.func_177230_c()).func_185524_e(), (Comparable)Integer.valueOf(Utilities.rint(((CropBase)cropState.func_177230_c()).func_185526_g() - 1, ((CropBase)cropState.func_177230_c()).func_185526_g()))) : cropState;
                    if (crop.func_177230_c() instanceof EggPlant) {
                        worldIn.func_180501_a(blockpos, (BlockState)crop.func_206870_a(EggPlant.HALF, (Comparable)DoubleBlockHalf.LOWER), 2);
                        if ((Integer)crop.func_177229_b((IProperty)EggPlant.AGE) == 0 || (Integer)crop.func_177229_b((IProperty)EggPlant.AGE) == 1) continue;
                        worldIn.func_180501_a(blockpos.func_177984_a(), (BlockState)crop.func_206870_a(EggPlant.HALF, (Comparable)DoubleBlockHalf.UPPER), 2);
                        continue;
                    }
                    if (crop.func_177230_c() instanceof GreenBeansBush) {
                        WNFeatures.GREEN_BEAN_FEATURE.func_212245_a(worldIn, generator, rand, blockpos, (IFeatureConfig)new NoFeatureConfig());
                        continue;
                    }
                    worldIn.func_180501_a(blockpos, crop, 2);
                    continue;
                }
                if (!(worldIn.func_180495_p(blockpos.func_177977_b()).func_177230_c() instanceof GrassBlock) || !Utilities.isBlockNear(worldIn, blockpos.func_177977_b(), Blocks.field_150458_ak) || Utilities.rint(0, fence / 2) != 0 || !((Boolean)CommonConfig.vegeFarmFence.get()).booleanValue()) continue;
                ++fence;
                worldIn.func_180501_a(blockpos, fenceBlock.func_176223_P(), 2);
                if (Utilities.rint(0, 1) != 0) continue;
                worldIn.func_180501_a(blockpos.func_177984_a(), Blocks.field_150478_aa.func_176223_P(), 2);
            }
            return true;
        }
        return false;
    }

    private BlockPos water(BlockPos pos, IWorld world, Random rand) {
        BlockPos waterPos = pos;
        switch (Utilities.rint(1, 4, rand)) {
            case 1: {
                waterPos = pos.func_177974_f();
                break;
            }
            case 2: {
                waterPos = pos.func_177976_e();
                break;
            }
            case 3: {
                waterPos = pos.func_177968_d();
                break;
            }
            case 4: {
                waterPos = pos.func_177978_c();
            }
        }
        if (world.func_180495_p(waterPos.func_177977_b()).func_200132_m() && world.func_180495_p(waterPos.func_177978_c()).func_200132_m() && world.func_180495_p(waterPos.func_177968_d()).func_200132_m() && world.func_180495_p(waterPos.func_177974_f()).func_200132_m() && world.func_180495_p(waterPos.func_177976_e()).func_200132_m()) {
            return waterPos;
        }
        return null;
    }
}

