/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.world.generation.generators.carves;

import com.matez.wildnature.util.config.CommonConfig;
import com.matez.wildnature.world.generation.grid.Cell;
import com.matez.wildnature.world.generation.noise.sponge.module.source.Perlin;
import com.matez.wildnature.world.generation.noise.sponge.module.source.RidgedMulti;
import com.matez.wildnature.world.generation.undergroundBiomes.setup.URBiome;
import com.matez.wildnature.world.generation.undergroundBiomes.setup.URBiomeManager;
import java.util.Random;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunk;

public class UndergroundRiverGenerator {
    private final RidgedMulti ridgedMultiNoise = new RidgedMulti();
    private static RidgedMulti ridgedMultiNoiseCopy;
    private final Perlin perlinNoise;
    private final Perlin biomeNoise;
    private IWorld world;
    private Random random;

    public UndergroundRiverGenerator(IWorld worldIn) {
        this.ridgedMultiNoise.setSeed((int)worldIn.func_72905_C());
        this.ridgedMultiNoise.setFrequency(0.005);
        this.ridgedMultiNoise.setOctaveCount(1);
        this.ridgedMultiNoise.setLacunarity(0.0);
        ridgedMultiNoiseCopy = this.ridgedMultiNoise;
        this.perlinNoise = new Perlin();
        this.perlinNoise.setSeed((int)worldIn.func_72905_C());
        this.perlinNoise.setFrequency(0.1);
        this.perlinNoise.setOctaveCount(2);
        this.perlinNoise.setLacunarity(0.0);
        this.perlinNoise.setPersistence(-0.4);
        this.biomeNoise = new Perlin();
        this.biomeNoise.setSeed((int)worldIn.func_72905_C());
        this.biomeNoise.setFrequency(0.002);
        this.biomeNoise.setOctaveCount(2);
        this.biomeNoise.setLacunarity(0.0);
        this.biomeNoise.setPersistence(0.0);
        this.world = worldIn;
        this.random = new Random(worldIn.func_72905_C());
    }

    public static RidgedMulti getRidgedMultiNoiseCopy() {
        return ridgedMultiNoiseCopy;
    }

    public void generate(int x, int y, int z, Cell cell, Biome biome, IChunk chunkIn) {
        if (((Boolean)CommonConfig.generateUndergroundRivers.get()).booleanValue()) {
            int a;
            int startPointY;
            int height;
            BlockPos pos;
            URBiome riverBiome = URBiomeManager.getBiomeAt(chunkIn, new BlockPos(x, 1, z), this.world.func_72905_C(), cell.undergroundBiomeCellIdentity);
            double vnoise = this.ridgedMultiNoise.getValue(x, 1.0, z);
            if (vnoise >= 0.6 && vnoise <= 2.0) {
                pos = new BlockPos(x, 13, z);
                height = riverBiome.getNoiseHeight(vnoise, 0.6, 0.625, 1, 10, 17, 0.63, this.random, this.world.func_72905_C(), pos);
                if (height == 10 || height == 9) {
                    double pnoise = this.perlinNoise.getValue(x, 1.0, z);
                    if (pnoise >= 0.3) {
                        ++height;
                        if (pnoise >= 0.38) {
                            ++height;
                        }
                    } else if (pnoise < 0.16) {
                        --height;
                    }
                }
                startPointY = -height / 2;
                for (a = pos.func_177956_o() - startPointY; a > pos.func_177956_o() - height; --a) {
                    BlockPos placePos = new BlockPos(pos.func_177958_n(), a, pos.func_177952_p());
                    if (a > 10) {
                        chunkIn.func_177436_a(placePos, Blocks.field_201941_jj.func_176223_P(), false);
                        continue;
                    }
                    chunkIn.func_177436_a(placePos, Blocks.field_150355_j.func_176223_P(), false);
                }
            }
            if (vnoise >= 0.58 && vnoise <= 2.0) {
                pos = new BlockPos(x, 13, z);
                if (riverBiome.getElevationBlock(this.world.func_72905_C(), this.random, pos).func_177230_c() != Blocks.field_150348_b || riverBiome.getUnderwaterBlock(this.world.func_72905_C(), this.random, pos).func_177230_c() != Blocks.field_150348_b) {
                    height = riverBiome.getNoiseHeight(vnoise, 0.59, 0.635, 1, 13, 17, 0.64, this.random, this.world.func_72905_C(), pos);
                    startPointY = -height / 2;
                    for (a = pos.func_177956_o() - startPointY; a > pos.func_177956_o() - height; --a) {
                        riverBiome.elevate(pos, a, chunkIn, this.random, this.world.func_72905_C());
                    }
                }
            }
        }
    }
}

