/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.world.generation.generators.functions.interpolation;

import com.matez.wildnature.util.other.Utilities;
import com.matez.wildnature.world.generation.biome.setup.BiomeVariants;
import com.matez.wildnature.world.generation.chunk.generation.landscape.ChunkLandscape;
import com.matez.wildnature.world.generation.chunk.generation.noise.NoiseProcessor;
import com.matez.wildnature.world.generation.generators.functions.interpolation.LerpConfiguration;
import com.matez.wildnature.world.generation.noise.fastNoise.FastNoise;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import java.util.LinkedHashMap;
import java.util.function.Function;
import net.minecraft.world.biome.Biome;

public class BiomeBlender {
    public static FastNoise fastNoise = new FastNoise();

    public static double[] smoothLerp(int x, int z, ChunkLandscape landscape, Object2DoubleMap<LerpConfiguration> weightMap1, Function<LerpConfiguration, BiomeVariants> variantAccessor) {
        double totalHeight = 0.0;
        double shoreHeight = 0.0;
        double shoreWeight = 0.0;
        double totalScale = 0.0;
        double maxNormalWeight = 0.0;
        double maxShoreWeight = 0.0;
        Object normalBiomeAt = null;
        Object shoreBiomeAt = null;
        for (Object2DoubleMap.Entry entry : weightMap1.object2DoubleEntrySet()) {
            BiomeVariants variants = variantAccessor.apply((LerpConfiguration)entry.getKey());
            LerpConfiguration configuration = (LerpConfiguration)entry.getKey();
            Biome biome = configuration.getBiome();
            double weight = entry.getDoubleValue();
            double height = weight * BiomeBlender.getDepth(configuration.getDepth());
            double scale = weight * BiomeBlender.getScale(configuration.getScale());
            totalHeight += height;
            totalScale += scale;
        }
        return new double[]{totalHeight, totalScale};
    }

    private static double lerp(double a, double b, double alpha) {
        return a + alpha * (b - a);
    }

    public static double modifyDepth(double weight, double depth, int x, int z) {
        double factor = depth / 256.0 * (weight * 3.0);
        double fractal = fastNoise.GetSimplexFractal(x, z);
        double scaledFractal = fractal * 20.0;
        return depth + scaledFractal * factor;
    }

    public static double getDepth(float depth) {
        int seaLevel = 63;
        int maxHeight = 230;
        int minHeight = 10;
        if (depth > 0.0f) {
            return Utilities.scaleBetween(depth, (float)seaLevel, (float)maxHeight, 0.0f, 2.0f);
        }
        return Utilities.scaleBetween(depth, (float)minHeight, (float)seaLevel, -2.0f, 0.0f);
    }

    public static double getScale(float scale) {
        return scale * 7.0f;
    }

    static {
        fastNoise.SetFractalOctaves(5);
        fastNoise.SetFractalType(FastNoise.FractalType.FBM);
        fastNoise.SetFractalGain(2.0f);
        fastNoise.SetFractalLacunarity(2.0f);
    }

    public static class BlendOutput {
        private final double height;
        private final double scale;
        private final LinkedHashMap<NoiseProcessor, Double> configs;

        public BlendOutput(double height, double scale, LinkedHashMap<NoiseProcessor, Double> configs) {
            this.height = height;
            this.scale = scale;
            this.configs = configs;
        }

        public double getHeight() {
            return this.height;
        }

        public double getScale() {
            return this.scale;
        }

        public double getFactorFor(NoiseProcessor processor) {
            if (this.configs.containsKey(processor)) {
                return this.configs.get(processor);
            }
            return 0.0;
        }
    }
}

