/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.world.generation.generators.functions.interpolation;

import com.matez.wildnature.world.generation.biome.setup.BiomeVariants;
import java.util.LinkedHashMap;
import net.minecraft.world.biome.Biome;

public class LerpConfiguration {
    private static LinkedHashMap<Biome, LerpConfiguration> cache = new LinkedHashMap();
    private Biome biome;
    private float customDepth;
    private float customScale;
    private BiomeVariants customVariants;
    private boolean customDepthApplied = false;
    private boolean customScaleApplied = false;
    private boolean customVariantsApplied = false;

    public static LerpConfiguration get(Biome biome) {
        if (cache.containsKey(biome)) {
            return cache.get(biome);
        }
        return new LerpConfiguration(biome);
    }

    public LerpConfiguration(Biome biome) {
        this.biome = biome;
        cache.put(biome, this);
    }

    public Biome getBiome() {
        return this.biome;
    }

    public void setCustomDepth(float customDepth) {
        this.customDepthApplied = true;
        this.customDepth = customDepth;
    }

    public void setCustomScale(float customScale) {
        this.customScaleApplied = true;
        this.customScale = customScale;
    }

    public void setCustomVariants(BiomeVariants customVariants) {
        this.customVariantsApplied = true;
        this.customVariants = customVariants;
    }

    public float getDepth() {
        return this.customDepthApplied ? this.customDepth : this.biome.func_185355_j();
    }

    public float getScale() {
        return this.customScaleApplied ? this.customScale : this.biome.func_185360_m();
    }

    public BiomeVariants getBiomeVariants() {
        return this.customVariantsApplied ? this.customVariants : BiomeVariants.getVariantsFor(this.biome);
    }
}

