/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.world.generation.grid.maps;

import com.matez.wildnature.init.WN;
import com.matez.wildnature.util.noise.NoiseUtil;
import com.matez.wildnature.util.noise.Vec2f;
import com.matez.wildnature.util.noise.domain.Warp;
import com.matez.wildnature.util.noise.func.DistanceFunc;
import com.matez.wildnature.util.noise.func.EdgeFunc;
import com.matez.wildnature.util.other.Utilities;
import com.matez.wildnature.world.generation.grid.Cell;
import com.matez.wildnature.world.generation.noise.fastNoise.FastNoise;
import java.util.Random;

public abstract class GridMap {
    protected final float frequency;
    protected final int gridScale;
    private final float edgeMin;
    private final float edgeMax;
    private final float edgeRange;
    private final int seed;
    private final FastNoise warpX;
    private final FastNoise warpY;
    private final Warp warp;
    private int xMove;
    private int zMove;

    public GridMap(long seed, int gridScale, float frequency) {
        this.gridScale = gridScale;
        this.frequency = frequency;
        this.edgeMin = 0.0f;
        this.edgeMax = 1.0f;
        this.edgeRange = this.edgeMax - this.edgeMin;
        this.seed = (int)seed;
        this.warpX = this.getWarpX();
        this.warpY = this.getWarpY();
        this.warp = new Warp(this.warpX, this.warpY, 64.0f);
        Random random = new Random(seed);
        this.xMove = Utilities.rint(-100000, 100000, random);
        this.zMove = Utilities.rint(-100000, 100000, random);
        WN.LOGGER.debug("Continent move: " + this.xMove + " " + this.zMove);
        WN.LOGGER.debug("Loaded GridMap " + this.getClass().getSimpleName() + " with seed " + this.seed + " and move " + this.xMove + " " + this.zMove);
    }

    public GridMap(long seed, int gridScale) {
        this(seed, gridScale, 1.0f / (float)gridScale * 4.0f);
    }

    public abstract FastNoise getWarpX();

    public abstract FastNoise getWarpY();

    public abstract CellValues applyOutput();

    public void apply(Cell cell, float x, float z) {
        float ox = this.warp.getOffsetX((float)this.xMove + x, (float)this.zMove + z);
        float oz = this.warp.getOffsetZ((float)this.xMove + x, (float)this.zMove + z);
        float px = (float)this.xMove + x + ox;
        float py = (float)this.zMove + z + oz;
        int cellX = 0;
        int cellY = 0;
        int xr = NoiseUtil.round(px *= this.frequency);
        int yr = NoiseUtil.round(py *= this.frequency);
        float edgeDistance = 999999.0f;
        float edgeDistance2 = 999999.0f;
        float valueDistance = 999999.0f;
        DistanceFunc dist = DistanceFunc.NATURAL;
        Vec2f center = NoiseUtil.CELL_2D[NoiseUtil.hash2D(this.seed, xr, yr) & 0xFF];
        for (int dy = -1; dy <= 1; ++dy) {
            for (int dx = -1; dx <= 1; ++dx) {
                int xi = xr + dx;
                int yi = yr + dy;
                Vec2f vec = NoiseUtil.CELL_2D[NoiseUtil.hash2D(this.seed, xi, yi) & 0xFF];
                float vecX = (float)xi - px + vec.x;
                float vecY = (float)yi - py + vec.y;
                float distance = dist.apply(vecX, vecY);
                if (distance < valueDistance) {
                    valueDistance = distance;
                    cellX = xi;
                    cellY = yi;
                    center = vec;
                }
                edgeDistance2 = distance < edgeDistance2 ? Math.max(edgeDistance, distance) : Math.max(edgeDistance, edgeDistance2);
                edgeDistance = Math.min(edgeDistance, distance);
            }
        }
        this.applyOutput().apply(cell, this.cellValue(this.seed, cellX, cellY), this.edgeValue(edgeDistance, edgeDistance2), (int)(((float)cellX + center.x) / this.frequency), (int)(((float)cellY + center.y) / this.frequency));
    }

    private float cellValue(int seed, int cellX, int cellY) {
        float value = NoiseUtil.valCoord2D(seed, cellX, cellY);
        return NoiseUtil.map(value, -1.0f, 1.0f, 2.0f);
    }

    private float edgeValue(float distance, float distance2) {
        EdgeFunc edge = EdgeFunc.DISTANCE_2_DIV;
        float value = edge.apply(distance, distance2);
        float edgeValue = 1.0f - NoiseUtil.map(value, edge.min(), edge.max(), edge.range());
        if ((edgeValue = NoiseUtil.pow(edgeValue, 1.5f)) < this.edgeMin) {
            return 0.0f;
        }
        if (edgeValue > this.edgeMax) {
            return 1.0f;
        }
        return (edgeValue - this.edgeMin) / this.edgeRange;
    }

    public static interface CellValues {
        public void apply(Cell var1, float var2, float var3, int var4, int var5);
    }
}

