/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.world.generation.heightmap;

import com.matez.wildnature.init.WN;
import com.matez.wildnature.world.generation.chunk.WNWorldContext;
import com.matez.wildnature.world.generation.grid.Cell;
import com.matez.wildnature.world.generation.grid.maps.BigIslandMap;
import com.matez.wildnature.world.generation.grid.maps.BiomeMap;
import com.matez.wildnature.world.generation.grid.maps.GridMap;
import com.matez.wildnature.world.generation.grid.maps.SmallIslandMap;
import com.matez.wildnature.world.generation.grid.maps.SubBiomeMap;
import com.matez.wildnature.world.generation.grid.maps.UndergroundBiomeMap;
import com.matez.wildnature.world.generation.heightmap.modules.ContinentGenerator;
import com.matez.wildnature.world.generation.heightmap.modules.RiverGenerator;
import com.matez.wildnature.world.generation.maps.ClimateMap;

public class WNHeightMap {
    private final WNWorldContext context;
    private final long seed;
    private final ContinentGenerator continentGenerator;
    private final RiverGenerator riverGenerator;
    private final Cell cell;
    public final GridMap biomeMap;
    public final GridMap undergroundBiomeMap;
    public final GridMap subBiomeMap;
    public final GridMap smallIslandMap;
    public final GridMap bigIslandMap;
    private final ClimateMap climateMap;

    public WNHeightMap(WNWorldContext context) {
        this.context = context;
        this.seed = context.getSeed();
        this.cell = context.getCell();
        WN.LOGGER.debug("Created WNHeightMap with seed " + this.seed);
        this.continentGenerator = new ContinentGenerator(this.seed);
        this.riverGenerator = new RiverGenerator(this.seed);
        this.biomeMap = new BiomeMap(this.seed);
        this.undergroundBiomeMap = new UndergroundBiomeMap(this.seed);
        this.subBiomeMap = new SubBiomeMap(this.seed);
        this.smallIslandMap = new SmallIslandMap(this.seed);
        this.bigIslandMap = new BigIslandMap(this.seed);
        this.climateMap = new ClimateMap(this.seed);
        WN.LOGGER.debug("Created heightMap with seed " + (int)this.seed);
    }

    public void applyContinent(Cell cell, int dx, int dz) {
        cell.continentValue = this.continentGenerator.generateContinent(dx, dz);
        cell.cellContinent = this.continentGenerator.generateContinent(cell.biomeCellX, cell.biomeCellZ);
    }

    public void applyClimate(Cell cell, float x, float z) {
        this.climateMap.apply(cell, x, z);
    }

    public void applyRiver(Cell cell, int x, int z) {
        this.riverGenerator.generate(cell, x, z);
    }

    public Cell apply(Cell cell, int dx, int dz) {
        this.biomeMap.apply(cell, dx, dz);
        this.undergroundBiomeMap.apply(cell, dx, dz);
        this.subBiomeMap.apply(cell, dx, dz);
        this.smallIslandMap.apply(cell, dx, dz);
        this.bigIslandMap.apply(cell, dx, dz);
        this.applyContinent(cell, dx, dz);
        this.applyClimate(cell, dx, dz);
        this.applyRiver(cell, dx, dz);
        return cell;
    }

    public ClimateMap getClimateMap() {
        return this.climateMap;
    }

    public ContinentGenerator getContinent() {
        return this.continentGenerator;
    }
}

