/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.world.generation.heightmap.modules;

import com.matez.wildnature.init.WN;
import com.matez.wildnature.util.other.Utilities;
import com.matez.wildnature.world.generation.noise.fastNoise.FastNoise;
import java.util.Random;

public class ContinentGenerator {
    private final FastNoise noise;
    public static final float continentMinValue = 0.0f;
    public static final float continentMaxValue = 1.0f;
    private int xMove;
    private int zMove;

    public ContinentGenerator(long seed) {
        WN.LOGGER.debug("Created ContinentGenerator with seed " + seed + "/" + (int)seed);
        this.noise = new FastNoise((int)seed);
        this.noise.SetNoiseType(FastNoise.NoiseType.Simplex);
        this.noise.SetFrequency(3.0E-4f);
        Random random = new Random(seed);
        this.xMove = Utilities.rint(-100000, 100000, random);
        this.zMove = Utilities.rint(-100000, 100000, random);
        WN.LOGGER.debug("Continent move: " + this.xMove + " " + this.zMove);
    }

    public float generateContinent(int dx, int dz) {
        return (float)ContinentGenerator.scaleBetween(this.noise.GetNoise(this.xMove + dx, this.zMove + dz), 0.0, 1.0, -0.8, 0.8);
    }

    private static double scaleBetween(double unscaledNum, double minAllowed, double maxAllowed, double min, double max) {
        return (maxAllowed - minAllowed) * (unscaledNum - min) / (max - min) + minAllowed;
    }
}

