/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.world.generation.heightmap.modules;

import com.matez.wildnature.init.WN;
import com.matez.wildnature.util.noise.domain.Warp;
import com.matez.wildnature.util.other.Utilities;
import com.matez.wildnature.world.generation.grid.Cell;
import com.matez.wildnature.world.generation.noise.fastNoise.FastNoise;

public class RiverGenerator {
    public FastNoise mainRiverNoise;
    public FastNoise streamRiverNoise;
    public FastNoise meanderNoise;
    public static float meanderThreshold = 0.2f;
    public static float streamMeanderThreshold = 0.1f;
    public Warp meanderWarp;
    private int xMove;
    private int zMove;

    public RiverGenerator(long seed) {
        WN.LOGGER.info("Created RiverGenerator with seed " + seed + "/" + (int)seed);
        this.mainRiverNoise = new FastNoise((int)seed);
        this.mainRiverNoise.SetFractalType(FastNoise.FractalType.RigidMulti);
        this.mainRiverNoise.SetFrequency(5.0E-5f);
        this.mainRiverNoise.SetFractalOctaves(1);
        this.mainRiverNoise.SetFractalLacunarity(0.0f);
        this.mainRiverNoise.SetFractalGain(0.0f);
        this.streamRiverNoise = new FastNoise((int)seed + 1);
        this.streamRiverNoise.SetFractalType(FastNoise.FractalType.RigidMulti);
        this.streamRiverNoise.SetFrequency(5.0E-4f);
        this.streamRiverNoise.SetFractalOctaves(1);
        this.streamRiverNoise.SetFractalLacunarity(0.0f);
        this.streamRiverNoise.SetFractalGain(0.0f);
        this.meanderNoise = new FastNoise((int)seed);
        this.meanderNoise.SetFrequency(5.0E-4f);
        FastNoise warpX = new FastNoise((int)seed);
        warpX.SetNoiseType(FastNoise.NoiseType.Simplex);
        warpX.SetFrequency(0.01f);
        FastNoise warpZ = new FastNoise((int)seed);
        warpZ.SetNoiseType(FastNoise.NoiseType.Simplex);
        warpZ.SetFrequency(0.01f);
        this.meanderWarp = new Warp(warpX, warpZ, 64.0f);
        this.xMove = 0;
        this.zMove = 0;
    }

    public void generate(Cell cell, int x, int z) {
        int dx = this.xMove + x;
        int dz = this.zMove + z;
        float meanders = this.meanderNoise.GetValue(dx, dz);
        float scaledMeanders = 0.05f;
        if (meanders > meanderThreshold) {
            scaledMeanders = Utilities.scaleBetween(meanders, 0.05f, 0.5f, meanderThreshold, 1.0f);
        }
        float wx = (float)dx + this.meanderWarp.getOffsetX(dx, dz) * scaledMeanders;
        float wz = (float)dz + this.meanderWarp.getOffsetZ(dx, dz) * scaledMeanders;
        cell.mainRiverValue = this.mainRiverNoise.GetSimplexFractal(wx, wz);
        float scaledLandscapeMeanders = 0.03f;
        if (meanders > meanderThreshold) {
            scaledLandscapeMeanders = Utilities.scaleBetween(meanders, 0.03f, 0.25f, meanderThreshold, 1.0f);
        }
        float wlx = (float)dx + this.meanderWarp.getOffsetX(dx, dz) * scaledLandscapeMeanders;
        float wlz = (float)dz + this.meanderWarp.getOffsetZ(dx, dz) * scaledLandscapeMeanders;
        cell.mainRiverLandscapeValue = this.mainRiverNoise.GetSimplexFractal(wlx, wlz);
        scaledMeanders = 0.15f;
        if (meanders > streamMeanderThreshold) {
            scaledMeanders = Utilities.scaleBetween(meanders, 0.15f, 0.3f, streamMeanderThreshold, 1.0f);
        }
        float swx = (float)dx + this.meanderWarp.getOffsetX(dx, dz) * scaledMeanders;
        float swz = (float)dz + this.meanderWarp.getOffsetZ(dx, dz) * scaledMeanders;
        cell.streamRiverValue = this.streamRiverNoise.GetSimplexFractal(swx, swz);
        scaledLandscapeMeanders = 0.15f;
        if (meanders > streamMeanderThreshold) {
            scaledLandscapeMeanders = Utilities.scaleBetween(meanders, 0.15f, 0.25f, streamMeanderThreshold, 1.0f);
        }
        float swlx = (float)dx + this.meanderWarp.getOffsetX(dx, dz) * scaledLandscapeMeanders;
        float swlz = (float)dz + this.meanderWarp.getOffsetZ(dx, dz) * scaledLandscapeMeanders;
        cell.streamRiverLandscapeValue = this.streamRiverNoise.GetSimplexFractal(swlx, swlz);
    }

    public static boolean isRiver(Cell cell) {
        return cell.mainRiverValue > RiverGenerator.scaleSize(0.9997f, cell.continentValue) || cell.streamRiverValue > RiverGenerator.scaleSize(0.9983f, cell.continentValue);
    }

    public static boolean isRiverValleySharp(Cell cell) {
        return cell.mainRiverLandscapeValue > RiverGenerator.scaleSize(0.9947f, cell.continentValue) || cell.streamRiverLandscapeValue > RiverGenerator.scaleSize(0.9837f, cell.continentValue);
    }

    public static boolean isRiverValleySmooth(Cell cell) {
        return cell.mainRiverLandscapeValue > RiverGenerator.scaleSize(0.9967f, cell.continentValue) || cell.streamRiverLandscapeValue > RiverGenerator.scaleSize(0.99f, cell.continentValue);
    }

    private static float scaleSize(float max, float continent) {
        return Utilities.scaleBetween(continent, max - 0.0015f, max, 0.0f, 1.0f);
    }
}

