/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.world.generation.layer;

import com.matez.wildnature.world.generation.grid.Cell;
import com.matez.wildnature.world.generation.provider.WNGridBiomeProvider;
import net.minecraft.util.FastRandom;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeManager;
import net.minecraft.world.biome.IBiomeMagnifier;

public class SmoothColumnBiomeMagnifier
implements IBiomeMagnifier {
    public static final SmoothColumnBiomeMagnifier VANILLA = new SmoothColumnBiomeMagnifier(0.9);
    public static final SmoothColumnBiomeMagnifier SMOOTH = new SmoothColumnBiomeMagnifier(0.7);
    private final double fuzzValue;

    public SmoothColumnBiomeMagnifier(double fuzzValue) {
        this.fuzzValue = fuzzValue;
    }

    public Biome func_225532_a_(long seed, int x, int y, int z, BiomeManager.IBiomeReader biomeReader) {
        int offsetX = x - 2;
        int offsetZ = z - 2;
        int coordX = offsetX >> 2;
        int coordZ = offsetZ >> 2;
        double localX = (double)(offsetX & 3) / 4.0;
        double localZ = (double)(offsetZ & 3) / 4.0;
        double minDistance = Double.MAX_VALUE;
        int index = 0;
        for (int i = 0; i < 4; ++i) {
            boolean flagZ;
            boolean flagX = (i & 2) == 0;
            double distance = this.distanceToCorner(seed, flagX ? coordX : coordX + 1, (flagZ = (i & 1) == 0) ? coordZ : coordZ + 1, flagX ? localX : localX - 1.0, flagZ ? localZ : localZ - 1.0);
            if (!(distance < minDistance)) continue;
            minDistance = distance;
            index = i;
        }
        return biomeReader.func_225526_b_((index & 2) == 0 ? coordX : coordX + 1, 0, (index & 1) == 0 ? coordZ : coordZ + 1);
    }

    public Biome getBiome(long seed, int x, int y, int z, WNGridBiomeProvider biomeReader, boolean fakeBiomes) {
        int offsetX = x - 2;
        int offsetZ = z - 2;
        int coordX = offsetX >> 2;
        int coordZ = offsetZ >> 2;
        double localX = (double)(offsetX & 3) / 4.0;
        double localZ = (double)(offsetZ & 3) / 4.0;
        double minDistance = Double.MAX_VALUE;
        int index = 0;
        for (int i = 0; i < 4; ++i) {
            boolean flagZ;
            boolean flagX = (i & 2) == 0;
            double distance = this.distanceToCorner(seed, flagX ? coordX : coordX + 1, (flagZ = (i & 1) == 0) ? coordZ : coordZ + 1, flagX ? localX : localX - 1.0, flagZ ? localZ : localZ - 1.0);
            if (!(distance < minDistance)) continue;
            minDistance = distance;
            index = i;
        }
        return biomeReader.getNoiseBiome((index & 2) == 0 ? coordX : coordX + 1, 0, (index & 1) == 0 ? coordZ : coordZ + 1, fakeBiomes);
    }

    public Biome getBiome(long seed, int x, int y, int z, Cell cell, WNGridBiomeProvider biomeReader, boolean fakeBiomes) {
        int offsetX = x - 2;
        int offsetZ = z - 2;
        int coordX = offsetX >> 2;
        int coordZ = offsetZ >> 2;
        double localX = (double)(offsetX & 3) / 4.0;
        double localZ = (double)(offsetZ & 3) / 4.0;
        double minDistance = Double.MAX_VALUE;
        int index = 0;
        for (int i = 0; i < 4; ++i) {
            boolean flagZ;
            boolean flagX = (i & 2) == 0;
            double distance = this.distanceToCorner(seed, flagX ? coordX : coordX + 1, (flagZ = (i & 1) == 0) ? coordZ : coordZ + 1, flagX ? localX : localX - 1.0, flagZ ? localZ : localZ - 1.0);
            if (!(distance < minDistance)) continue;
            minDistance = distance;
            index = i;
        }
        return biomeReader.getNoiseBiome(cell, (index & 2) == 0 ? coordX : coordX + 1, 0, (index & 1) == 0 ? coordZ : coordZ + 1, fakeBiomes);
    }

    private double distanceToCorner(long seed, int coordX, int coordZ, double localX, double localZ) {
        long localSeed = FastRandom.func_226162_a_((long)seed, (long)coordX);
        localSeed = FastRandom.func_226162_a_((long)localSeed, (long)coordZ);
        localSeed = FastRandom.func_226162_a_((long)localSeed, (long)coordX);
        localSeed = FastRandom.func_226162_a_((long)localSeed, (long)coordZ);
        double varianceX = this.randomValue(localSeed);
        localSeed = FastRandom.func_226162_a_((long)localSeed, (long)seed);
        double varianceZ = this.randomValue(localSeed);
        return this.square(localZ + varianceZ) + this.square(localX + varianceX);
    }

    private double randomValue(long seed) {
        return (double)((int)Math.floorMod(seed >> 24, 1024L)) / 1024.0 * this.fuzzValue - 0.5 * this.fuzzValue;
    }

    private double square(double value) {
        return value * value;
    }
}

