/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.world.generation.layer;

import com.matez.wildnature.init.WN;
import com.matez.wildnature.util.config.CommonConfig;
import com.matez.wildnature.world.generation.biome.registry.WNBiomes;
import com.matez.wildnature.world.generation.layer.WNLayerUtil;
import java.util.ArrayList;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.gen.INoiseRandom;
import net.minecraft.world.gen.layer.traits.IBishopTransformer;

public enum WNIslandLayer implements IBishopTransformer
{
    INSTANCE;

    private static final int EASTER_ISLAND;
    private static final int TROPICAL_ISLAND;
    private static final int MADAGASCAR;
    private static final int CHRISTMAS_ISLAND;
    public static ArrayList<Island> islands;

    public static void applyIslands() {
        WN.LOGGER.debug("Applying islands");
        islands.add(new Island(EASTER_ISLAND, 70));
        islands.add(new Island(TROPICAL_ISLAND, 40));
        islands.add(new Island(MADAGASCAR, 30));
        islands.add(new Island(CHRISTMAS_ISLAND, 50));
        WN.LOGGER.debug("Islands appiled: ");
        for (Island island : islands) {
            WN.LOGGER.debug("Island " + island.getBiome());
        }
    }

    public int func_202792_a(INoiseRandom context, int side, int side1, int side2, int side3, int side4) {
        if (WNLayerUtil.isOcean(side) && WNLayerUtil.isOcean(side1) && WNLayerUtil.isOcean(side2) && WNLayerUtil.isOcean(side3) && WNLayerUtil.isOcean(side4)) {
            for (Island island : islands) {
                if (context.func_202696_a(island.rarity) != 0) continue;
                WN.LOGGER.debug("adding island " + island.getBiome());
                if (CommonConfig.blacklistedBiomes.contains(Registry.field_212624_m.func_148745_a(island.getBiome()))) continue;
                WN.LOGGER.debug("added island " + island.getBiome());
                return island.getBiome();
            }
        }
        for (Island island : islands) {
            if (!this.isSame(side, island.getBiome()) && !this.isSame(side1, island.getBiome()) && !this.isSame(side2, island.getBiome()) && !this.isSame(side3, island.getBiome()) && !this.isSame(side4, island.getBiome()) || context.func_202696_a(island.rarity) == 0 || CommonConfig.blacklistedBiomes.contains(Registry.field_212624_m.func_148745_a(island.getBiome()))) continue;
            return island.getBiome();
        }
        return side;
    }

    private boolean isSame(int biome, int island) {
        return biome == island;
    }

    static {
        EASTER_ISLAND = Registry.field_212624_m.func_148757_b((Object)WNBiomes.EasterIsland);
        TROPICAL_ISLAND = Registry.field_212624_m.func_148757_b((Object)WNBiomes.TropicalIsland);
        MADAGASCAR = Registry.field_212624_m.func_148757_b((Object)WNBiomes.Madagascar);
        CHRISTMAS_ISLAND = Registry.field_212624_m.func_148757_b((Object)WNBiomes.ChristmasIsland);
        islands = new ArrayList();
        WNIslandLayer.applyIslands();
    }

    public static class Island {
        private int biome;
        private int rarity;

        public Island(int b, int rarity) {
            this.biome = b;
            this.rarity = rarity;
        }

        public int getBiome() {
            return this.biome;
        }

        public int getRarity() {
            return this.rarity;
        }
    }
}

