/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.world.generation.layer;

import com.matez.wildnature.init.WN;
import com.matez.wildnature.util.config.CommonConfig;
import com.matez.wildnature.world.generation.layer.WNEdgeBiomeLayer;
import com.matez.wildnature.world.generation.layer.WNGroupLayer;
import com.matez.wildnature.world.generation.layer.WNIslandLayer;
import com.matez.wildnature.world.generation.layer.WNMixRiverLayer;
import com.matez.wildnature.world.generation.layer.WNRiverLayer;
import com.matez.wildnature.world.generation.layer.WNShoreLayer;
import com.matez.wildnature.world.generation.layer.WNWeightedBiomeLayer;
import java.util.function.LongFunction;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.gen.IExtendedNoiseRandom;
import net.minecraft.world.gen.LazyAreaLayerContext;
import net.minecraft.world.gen.OverworldGenSettings;
import net.minecraft.world.gen.area.IArea;
import net.minecraft.world.gen.area.IAreaFactory;
import net.minecraft.world.gen.layer.AddBambooForestLayer;
import net.minecraft.world.gen.layer.AddIslandLayer;
import net.minecraft.world.gen.layer.AddMushroomIslandLayer;
import net.minecraft.world.gen.layer.AddSnowLayer;
import net.minecraft.world.gen.layer.DeepOceanLayer;
import net.minecraft.world.gen.layer.EdgeLayer;
import net.minecraft.world.gen.layer.HillsLayer;
import net.minecraft.world.gen.layer.IslandLayer;
import net.minecraft.world.gen.layer.Layer;
import net.minecraft.world.gen.layer.LayerUtil;
import net.minecraft.world.gen.layer.MixOceansLayer;
import net.minecraft.world.gen.layer.OceanLayer;
import net.minecraft.world.gen.layer.RareBiomeLayer;
import net.minecraft.world.gen.layer.RemoveTooMuchOceanLayer;
import net.minecraft.world.gen.layer.SmoothLayer;
import net.minecraft.world.gen.layer.StartRiverLayer;
import net.minecraft.world.gen.layer.ZoomLayer;
import net.minecraft.world.gen.layer.traits.IAreaTransformer1;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.WorldTypeEvent;
import net.minecraftforge.eventbus.api.Event;

public class WNLayerUtil
extends LayerUtil {
    protected static final int WARM_OCEAN = Registry.field_212624_m.func_148757_b((Object)Biomes.field_203614_T);
    protected static final int LUKEWARM_OCEAN = Registry.field_212624_m.func_148757_b((Object)Biomes.field_203615_U);
    protected static final int OCEAN = Registry.field_212624_m.func_148757_b((Object)Biomes.field_76771_b);
    protected static final int COLD_OCEAN = Registry.field_212624_m.func_148757_b((Object)Biomes.field_203616_V);
    protected static final int FROZEN_OCEAN = Registry.field_212624_m.func_148757_b((Object)Biomes.field_76776_l);
    protected static final int DEEP_WARM_OCEAN = Registry.field_212624_m.func_148757_b((Object)Biomes.field_203617_W);
    protected static final int DEEP_LUKEWARM_OCEAN = Registry.field_212624_m.func_148757_b((Object)Biomes.field_203618_X);
    protected static final int DEEP_OCEAN = Registry.field_212624_m.func_148757_b((Object)Biomes.field_150575_M);
    protected static final int DEEP_COLD_OCEAN = Registry.field_212624_m.func_148757_b((Object)Biomes.field_203619_Y);
    protected static final int DEEP_FROZEN_OCEAN = Registry.field_212624_m.func_148757_b((Object)Biomes.field_203620_Z);

    public static <T extends IArea, C extends IExtendedNoiseRandom<T>> IAreaFactory<T> repeat(long seed, IAreaTransformer1 parent, IAreaFactory<T> p_202829_3_, int count, LongFunction<C> contextFactory) {
        IAreaFactory iareafactory = p_202829_3_;
        for (int i = 0; i < count; ++i) {
            iareafactory = parent.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(seed + (long)i), iareafactory);
        }
        return iareafactory;
    }

    public static <T extends IArea, C extends IExtendedNoiseRandom<T>> IAreaFactory<T> createBiomeFactory(LongFunction<C> context, IAreaFactory<T> landFactory) {
        IAreaFactory biomeFactory = WNWeightedBiomeLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)context.apply(200L), landFactory);
        biomeFactory = AddBambooForestLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)context.apply(1001L), biomeFactory);
        biomeFactory = LayerUtil.func_202829_a((long)1000L, (IAreaTransformer1)ZoomLayer.NORMAL, (IAreaFactory)biomeFactory, (int)2, context);
        biomeFactory = WNEdgeBiomeLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)context.apply(1000L), biomeFactory);
        return biomeFactory;
    }

    public static <T extends IArea, C extends IExtendedNoiseRandom<T>> IAreaFactory<T> func_227475_a_(WorldType worldType, OverworldGenSettings settings, LongFunction<C> context) {
        int k;
        int i;
        WN.wnInfo("Using WNLayer");
        IAreaFactory<T> terrainFactory = IslandLayer.INSTANCE.func_202823_a((IExtendedNoiseRandom)context.apply(1L));
        terrainFactory = ZoomLayer.FUZZY.func_202713_a((IExtendedNoiseRandom)context.apply(2000L), (IAreaFactory)terrainFactory);
        terrainFactory = AddIslandLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)context.apply(1L), (IAreaFactory)terrainFactory);
        terrainFactory = ZoomLayer.NORMAL.func_202713_a((IExtendedNoiseRandom)context.apply(2001L), (IAreaFactory)terrainFactory);
        terrainFactory = AddIslandLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)context.apply(2L), (IAreaFactory)terrainFactory);
        terrainFactory = AddIslandLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)context.apply(50L), (IAreaFactory)terrainFactory);
        terrainFactory = AddIslandLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)context.apply(70L), (IAreaFactory)terrainFactory);
        terrainFactory = RemoveTooMuchOceanLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)context.apply(2L), (IAreaFactory)terrainFactory);
        IAreaFactory<T> iareafactory1 = OceanLayer.INSTANCE.func_202823_a((IExtendedNoiseRandom)context.apply(2L));
        iareafactory1 = WNLayerUtil.repeat(2001L, (IAreaTransformer1)ZoomLayer.NORMAL, iareafactory1, 6, context);
        terrainFactory = AddSnowLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)context.apply(2L), (IAreaFactory)terrainFactory);
        terrainFactory = AddIslandLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)context.apply(3L), (IAreaFactory)terrainFactory);
        terrainFactory = EdgeLayer.CoolWarm.INSTANCE.func_202713_a((IExtendedNoiseRandom)context.apply(2L), (IAreaFactory)terrainFactory);
        terrainFactory = EdgeLayer.HeatIce.INSTANCE.func_202713_a((IExtendedNoiseRandom)context.apply(2L), (IAreaFactory)terrainFactory);
        terrainFactory = EdgeLayer.Special.INSTANCE.func_202713_a((IExtendedNoiseRandom)context.apply(3L), (IAreaFactory)terrainFactory);
        terrainFactory = ZoomLayer.NORMAL.func_202713_a((IExtendedNoiseRandom)context.apply(2002L), (IAreaFactory)terrainFactory);
        terrainFactory = ZoomLayer.NORMAL.func_202713_a((IExtendedNoiseRandom)context.apply(2003L), (IAreaFactory)terrainFactory);
        terrainFactory = AddIslandLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)context.apply(4L), (IAreaFactory)terrainFactory);
        terrainFactory = AddMushroomIslandLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)context.apply(5L), (IAreaFactory)terrainFactory);
        terrainFactory = WNIslandLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)context.apply(5L), (IAreaFactory)terrainFactory);
        terrainFactory = DeepOceanLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)context.apply(4L), (IAreaFactory)terrainFactory);
        terrainFactory = WNLayerUtil.repeat(1000L, (IAreaTransformer1)ZoomLayer.NORMAL, terrainFactory, 0, context);
        int j = i = 4;
        if (settings != null) {
            i = (Integer)CommonConfig.biomeSize.get();
            j = (Integer)CommonConfig.riverSize.get();
        }
        if (worldType == WorldType.field_77135_d) {
            i = 6;
        }
        i = WNLayerUtil.getModdedBiomeSize(worldType, i);
        IAreaFactory<T> riverFactory = WNLayerUtil.repeat(1000L, (IAreaTransformer1)ZoomLayer.NORMAL, terrainFactory, 0, context);
        riverFactory = StartRiverLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)context.apply(100L), riverFactory);
        IAreaFactory biomeFactory = null;
        biomeFactory = (Boolean)CommonConfig.generateOnlyWildNature.get() == false ? worldType.getBiomeLayer(terrainFactory, settings, context) : WNLayerUtil.createBiomeFactory(context, riverFactory);
        IAreaFactory<T> lvt_9_1_ = WNLayerUtil.repeat(1000L, (IAreaTransformer1)ZoomLayer.NORMAL, riverFactory, 2, context);
        biomeFactory = WNGroupLayer.INSTANCE.func_202707_a((IExtendedNoiseRandom)context.apply(1000L), biomeFactory, lvt_9_1_);
        biomeFactory = HillsLayer.INSTANCE.func_202707_a((IExtendedNoiseRandom)context.apply(1000L), biomeFactory, lvt_9_1_);
        riverFactory = WNLayerUtil.repeat(1000L, (IAreaTransformer1)ZoomLayer.NORMAL, riverFactory, 2, context);
        riverFactory = WNLayerUtil.repeat(1000L, (IAreaTransformer1)ZoomLayer.NORMAL, riverFactory, j, context);
        riverFactory = WNRiverLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)context.apply(1L), riverFactory);
        riverFactory = SmoothLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)context.apply(1000L), (IAreaFactory)riverFactory);
        riverFactory = WNLayerUtil.repeat(1000L, (IAreaTransformer1)ZoomLayer.NORMAL, riverFactory, 3, context);
        biomeFactory = RareBiomeLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)context.apply(1001L), biomeFactory);
        for (k = 0; k < i - (i > 4 ? 4 : 0); ++k) {
            biomeFactory = ZoomLayer.NORMAL.func_202713_a((IExtendedNoiseRandom)context.apply(1000 + k), biomeFactory);
        }
        for (k = 0; k < (i > 4 ? 4 : 4 - i); ++k) {
            biomeFactory = ZoomLayer.NORMAL.func_202713_a((IExtendedNoiseRandom)context.apply(1000 + k), biomeFactory);
            if (k == 0) {
                biomeFactory = AddIslandLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)context.apply(3L), biomeFactory);
            }
            if (k != 1 && i != 1) continue;
            biomeFactory = WNShoreLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)context.apply(1000L), biomeFactory);
        }
        biomeFactory = SmoothLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)context.apply(1000L), biomeFactory);
        biomeFactory = WNMixRiverLayer.INSTANCE.func_202707_a((IExtendedNoiseRandom)context.apply(100L), biomeFactory, riverFactory);
        biomeFactory = MixOceansLayer.INSTANCE.func_202707_a((IExtendedNoiseRandom)context.apply(100L), biomeFactory, iareafactory1);
        return biomeFactory;
    }

    public static Layer func_227474_a_(long seed, WorldType type, OverworldGenSettings settings) {
        int i = 25;
        IAreaFactory iareafactory = WNLayerUtil.func_227475_a_(type, settings, p_227473_2_ -> new LazyAreaLayerContext(25, seed, p_227473_2_));
        return new Layer(iareafactory);
    }

    public static boolean areBiomesSimilar(int p_202826_0_, int p_202826_1_) {
        if (p_202826_0_ == p_202826_1_) {
            return true;
        }
        Biome biome = (Biome)Registry.field_212624_m.func_148745_a(p_202826_0_);
        Biome biome1 = (Biome)Registry.field_212624_m.func_148745_a(p_202826_1_);
        if (biome != null && biome1 != null) {
            if (biome != Biomes.field_150607_aa && biome != Biomes.field_150608_ab) {
                if (biome.func_201856_r() != Biome.Category.NONE && biome1.func_201856_r() != Biome.Category.NONE && biome.func_201856_r() == biome1.func_201856_r()) {
                    return true;
                }
                return biome == biome1;
            }
            return biome1 == Biomes.field_150607_aa || biome1 == Biomes.field_150608_ab;
        }
        return false;
    }

    public static int getModdedBiomeSize(WorldType worldType, int original) {
        WorldTypeEvent.BiomeSize event = new WorldTypeEvent.BiomeSize(worldType, original);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.getNewSize();
    }

    public static boolean isOcean(int biomeIn) {
        return biomeIn == WARM_OCEAN || biomeIn == LUKEWARM_OCEAN || biomeIn == OCEAN || biomeIn == COLD_OCEAN || biomeIn == FROZEN_OCEAN || biomeIn == DEEP_WARM_OCEAN || biomeIn == DEEP_LUKEWARM_OCEAN || biomeIn == DEEP_OCEAN || biomeIn == DEEP_COLD_OCEAN || biomeIn == DEEP_FROZEN_OCEAN;
    }

    public static boolean isShallowOcean(int biomeIn) {
        return biomeIn == WARM_OCEAN || biomeIn == LUKEWARM_OCEAN || biomeIn == OCEAN || biomeIn == COLD_OCEAN || biomeIn == FROZEN_OCEAN;
    }
}

