/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.world.generation.layer;

import com.matez.wildnature.world.generation.biome.registry.WNBiomes;
import com.matez.wildnature.world.generation.layer.WNLayerUtil;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.gen.INoiseRandom;
import net.minecraft.world.gen.layer.traits.ICastleTransformer;

public enum WNShoreLayer implements ICastleTransformer
{
    INSTANCE;

    private static final int BEACH;
    private static final int SNOWY_BEACH;
    private static final int DESERT;
    private static final int MOUNTAINS;
    private static final int WOODED_MOUNTAINS;
    private static final int FOREST;
    private static final int JUNGLE;
    private static final int JUNGLE_EDGE;
    private static final int JUNGLE_HILLS;
    private static final int BADLANDS;
    private static final int WOODED_BADLANDS_PLATEAU;
    private static final int BADLANDS_PLATEAU;
    private static final int ERODED_BADLANDS;
    private static final int MODIFIED_WOODED_BADLANDS_PLATEAU;
    private static final int MODIFIED_BADLANDS_PLATEAU;
    private static final int MUSHROOM_FIELDS;
    private static final int MUSHROOM_FIELD_SHORE;
    private static final int RIVER;
    private static final int MOUNTAIN_EDGE;
    private static final int STONE_SHORE;
    private static final int SWAMP;
    private static final int TAIGA;
    private static final int WHITE_BEACH;
    private static final int MAHOGANY_RAINFOREST;
    private static final int MAHOGANY_CLIFFS;
    private static final int TROPICAL_ISLAND;
    private static final int MADAGASCAR;
    private static final int MADAGASCAR_VALLEY;
    private static final int TROPICAL_CLIFFS;
    private static final int CANYONS;
    private static final int GRAND_CANYON;
    private static final int CANYON_RIVER;
    private static final int ICELAND_RIVER;
    private static final int ICELANDS;
    private static final int DAINTREE_RIVER;
    private static final int DAINTREE_CLIFFS;
    private static final int POLDERS;
    private static final int POLDERS_EDGE;
    private static final int TATRA_FOOTHILLS;
    private static final int TATRA_LOWER_FOREST;
    private static final int TATRA_UPPER_FOREST;
    private static final int TATRA_MOUNTAINS;
    private static final int TATRA_GREENED_PEAK;
    private static final int TATRA_KASPROWY_PEAK;
    private static final int CHOCHOLOWSKA_GLADE;
    private static final int FIREWEED_VALLEY;
    private static final int CRACOW_GORGE;
    private static final int MORSKIE_OKO;
    private static final int GIEWONT;
    private static final int RYSY;
    private static final int TATRA_STREAM;
    private static final int SNOWY_TATRA_FOOTHILLS;
    private static final int SNOWY_TATRA_LOWER_FOREST;
    private static final int SNOWY_TATRA_UPPER_FOREST;
    private static final int SNOWY_TATRA_MOUNTAINS;
    private static final int SNOWY_TATRA_KASPROWY_PEAK;
    private static final int SNOWY_CHOCHOLOWSKA_GLADE;
    private static final int SNOWY_FIREWEED_VALLEY;
    private static final int SNOWY_CRACOW_GORGE;
    private static final int FROZEN_MORSKIE_OKO;
    private static final int SNOWY_GIEWONT;

    private static boolean isTatra(int biomeNear) {
        return biomeNear == TATRA_FOOTHILLS || biomeNear == TATRA_LOWER_FOREST || biomeNear == TATRA_UPPER_FOREST || biomeNear == TATRA_MOUNTAINS || biomeNear == TATRA_GREENED_PEAK || biomeNear == TATRA_KASPROWY_PEAK || biomeNear == CHOCHOLOWSKA_GLADE || biomeNear == FIREWEED_VALLEY || biomeNear == CRACOW_GORGE || biomeNear == MORSKIE_OKO || biomeNear == GIEWONT || biomeNear == RYSY;
    }

    private static boolean isSnowyTatra(int biomeNear) {
        return biomeNear == SNOWY_TATRA_LOWER_FOREST || biomeNear == SNOWY_TATRA_UPPER_FOREST || biomeNear == SNOWY_TATRA_MOUNTAINS || biomeNear == SNOWY_TATRA_KASPROWY_PEAK || biomeNear == SNOWY_CHOCHOLOWSKA_GLADE || biomeNear == SNOWY_FIREWEED_VALLEY || biomeNear == SNOWY_CRACOW_GORGE || biomeNear == FROZEN_MORSKIE_OKO || biomeNear == SNOWY_GIEWONT || biomeNear == RYSY;
    }

    public int func_202748_a(INoiseRandom context, int north, int west, int south, int east, int center) {
        Biome biome = (Biome)Registry.field_212624_m.func_148745_a(center);
        if (center == MUSHROOM_FIELDS) {
            if (WNLayerUtil.isShallowOcean(north) || WNLayerUtil.isShallowOcean(west) || WNLayerUtil.isShallowOcean(south) || WNLayerUtil.isShallowOcean(east)) {
                return MUSHROOM_FIELD_SHORE;
            }
        } else {
            if (center == CANYONS || center == GRAND_CANYON) {
                return center;
            }
            if (WNShoreLayer.isCanyonCompatible(north) || WNShoreLayer.isCanyonCompatible(south) || WNShoreLayer.isCanyonCompatible(west) || WNShoreLayer.isCanyonCompatible(east)) {
                return CANYON_RIVER;
            }
            if (center == ICELANDS) {
                return center;
            }
            if (center == DAINTREE_CLIFFS) {
                return center;
            }
            if (center == CRACOW_GORGE) {
                return center;
            }
            if (WNShoreLayer.isTatra(center)) {
                return center;
            }
            if (WNShoreLayer.isSnowyTatra(center)) {
                return center;
            }
            if (WNShoreLayer.isPolderComaptible(center)) {
                return center;
            }
            if (WNShoreLayer.isIceCanyonCompatible(north) || WNShoreLayer.isIceCanyonCompatible(south) || WNShoreLayer.isIceCanyonCompatible(west) || WNShoreLayer.isIceCanyonCompatible(east)) {
                return CANYON_RIVER;
            }
            if (WNShoreLayer.isDaintreeCanyonCompatible(north) || WNShoreLayer.isDaintreeCanyonCompatible(south) || WNShoreLayer.isDaintreeCanyonCompatible(west) || WNShoreLayer.isDaintreeCanyonCompatible(east)) {
                return DAINTREE_RIVER;
            }
            if (WNShoreLayer.isCracowGorgeCompatible(north) || WNShoreLayer.isCracowGorgeCompatible(south) || WNShoreLayer.isCracowGorgeCompatible(west) || WNShoreLayer.isCracowGorgeCompatible(east)) {
                return TATRA_STREAM;
            }
            if (WNShoreLayer.isTatra(north) || WNShoreLayer.isTatra(south) || WNShoreLayer.isTatra(west) || WNShoreLayer.isTatra(east)) {
                return TATRA_FOOTHILLS;
            }
            if (WNShoreLayer.isSnowyTatra(north) || WNShoreLayer.isSnowyTatra(south) || WNShoreLayer.isSnowyTatra(west) || WNShoreLayer.isSnowyTatra(east)) {
                return SNOWY_TATRA_FOOTHILLS;
            }
            if (WNShoreLayer.isPolderComaptible(north) || WNShoreLayer.isPolderComaptible(south) || WNShoreLayer.isPolderComaptible(west) || WNShoreLayer.isPolderComaptible(east)) {
                return POLDERS_EDGE;
            }
            if (center == MAHOGANY_RAINFOREST || center == MAHOGANY_CLIFFS || center == TROPICAL_ISLAND || center == TROPICAL_CLIFFS || center == MADAGASCAR || center == MADAGASCAR_VALLEY) {
                if (WNLayerUtil.isShallowOcean(north) || WNLayerUtil.isShallowOcean(west) || WNLayerUtil.isShallowOcean(south) || WNLayerUtil.isShallowOcean(east)) {
                    return WHITE_BEACH;
                }
            } else if (biome != null && biome.func_201856_r() == Biome.Category.JUNGLE) {
                if (!(WNShoreLayer.isJungleCompatible(north) && WNShoreLayer.isJungleCompatible(west) && WNShoreLayer.isJungleCompatible(south) && WNShoreLayer.isJungleCompatible(east))) {
                    return JUNGLE_EDGE;
                }
                if (WNLayerUtil.isOcean(north) || WNLayerUtil.isOcean(west) || WNLayerUtil.isOcean(south) || WNLayerUtil.isOcean(east)) {
                    return BEACH;
                }
            } else if (center != MOUNTAINS && center != WOODED_MOUNTAINS && center != MOUNTAIN_EDGE) {
                if (biome != null && biome.func_201851_b() == Biome.RainType.SNOW) {
                    if (!WNLayerUtil.isOcean(center) && (WNLayerUtil.isOcean(north) || WNLayerUtil.isOcean(west) || WNLayerUtil.isOcean(south) || WNLayerUtil.isOcean(east))) {
                        return SNOWY_BEACH;
                    }
                } else if (center != BADLANDS && center != WOODED_BADLANDS_PLATEAU) {
                    if (!WNLayerUtil.isOcean(center) && center != RIVER && center != SWAMP && (WNLayerUtil.isOcean(north) || WNLayerUtil.isOcean(west) || WNLayerUtil.isOcean(south) || WNLayerUtil.isOcean(east))) {
                        return BEACH;
                    }
                } else if (!(WNLayerUtil.isOcean(north) || WNLayerUtil.isOcean(west) || WNLayerUtil.isOcean(south) || WNLayerUtil.isOcean(east) || this.isMesa(north) && this.isMesa(west) && this.isMesa(south) && this.isMesa(east))) {
                    return DESERT;
                }
            } else if (!WNLayerUtil.isOcean(center) && (WNLayerUtil.isOcean(north) || WNLayerUtil.isOcean(west) || WNLayerUtil.isOcean(south) || WNLayerUtil.isOcean(east))) {
                return STONE_SHORE;
            }
        }
        return center;
    }

    private static boolean isJungleCompatible(int p_151631_0_) {
        if (Registry.field_212624_m.func_148745_a(p_151631_0_) != null && ((Biome)Registry.field_212624_m.func_148745_a(p_151631_0_)).func_201856_r() == Biome.Category.JUNGLE) {
            return true;
        }
        return p_151631_0_ == JUNGLE_EDGE || p_151631_0_ == JUNGLE || p_151631_0_ == JUNGLE_HILLS || p_151631_0_ == FOREST || p_151631_0_ == TAIGA || WNLayerUtil.isOcean(p_151631_0_);
    }

    private static boolean isCanyonCompatible(int biomeNear) {
        return biomeNear == GRAND_CANYON || biomeNear == CANYONS || biomeNear == CANYON_RIVER;
    }

    private static boolean isIceCanyonCompatible(int biomeNear) {
        return biomeNear == ICELANDS || biomeNear == ICELAND_RIVER;
    }

    private static boolean isDaintreeCanyonCompatible(int biomeNear) {
        return biomeNear == DAINTREE_CLIFFS || biomeNear == DAINTREE_RIVER;
    }

    private static boolean isCracowGorgeCompatible(int biomeNear) {
        return biomeNear == CRACOW_GORGE || biomeNear == TATRA_STREAM;
    }

    private static boolean isPolderComaptible(int biomeNear) {
        return biomeNear == POLDERS || biomeNear == POLDERS_EDGE;
    }

    private boolean isMesa(int p_151633_1_) {
        return p_151633_1_ == BADLANDS || p_151633_1_ == WOODED_BADLANDS_PLATEAU || p_151633_1_ == BADLANDS_PLATEAU || p_151633_1_ == ERODED_BADLANDS || p_151633_1_ == MODIFIED_WOODED_BADLANDS_PLATEAU || p_151633_1_ == MODIFIED_BADLANDS_PLATEAU;
    }

    static {
        BEACH = Registry.field_212624_m.func_148757_b((Object)Biomes.field_76787_r);
        SNOWY_BEACH = Registry.field_212624_m.func_148757_b((Object)Biomes.field_150577_O);
        DESERT = Registry.field_212624_m.func_148757_b((Object)Biomes.field_76769_d);
        MOUNTAINS = Registry.field_212624_m.func_148757_b((Object)Biomes.field_76770_e);
        WOODED_MOUNTAINS = Registry.field_212624_m.func_148757_b((Object)Biomes.field_150580_W);
        FOREST = Registry.field_212624_m.func_148757_b((Object)Biomes.field_76767_f);
        JUNGLE = Registry.field_212624_m.func_148757_b((Object)Biomes.field_76782_w);
        JUNGLE_EDGE = Registry.field_212624_m.func_148757_b((Object)Biomes.field_150574_L);
        JUNGLE_HILLS = Registry.field_212624_m.func_148757_b((Object)Biomes.field_76792_x);
        BADLANDS = Registry.field_212624_m.func_148757_b((Object)Biomes.field_150589_Z);
        WOODED_BADLANDS_PLATEAU = Registry.field_212624_m.func_148757_b((Object)Biomes.field_150607_aa);
        BADLANDS_PLATEAU = Registry.field_212624_m.func_148757_b((Object)Biomes.field_150608_ab);
        ERODED_BADLANDS = Registry.field_212624_m.func_148757_b((Object)Biomes.field_185437_ai);
        MODIFIED_WOODED_BADLANDS_PLATEAU = Registry.field_212624_m.func_148757_b((Object)Biomes.field_185438_aj);
        MODIFIED_BADLANDS_PLATEAU = Registry.field_212624_m.func_148757_b((Object)Biomes.field_185439_ak);
        MUSHROOM_FIELDS = Registry.field_212624_m.func_148757_b((Object)Biomes.field_76789_p);
        MUSHROOM_FIELD_SHORE = Registry.field_212624_m.func_148757_b((Object)Biomes.field_76788_q);
        RIVER = Registry.field_212624_m.func_148757_b((Object)Biomes.field_76781_i);
        MOUNTAIN_EDGE = Registry.field_212624_m.func_148757_b((Object)Biomes.field_76783_v);
        STONE_SHORE = Registry.field_212624_m.func_148757_b((Object)Biomes.field_150576_N);
        SWAMP = Registry.field_212624_m.func_148757_b((Object)Biomes.field_76780_h);
        TAIGA = Registry.field_212624_m.func_148757_b((Object)Biomes.field_76768_g);
        WHITE_BEACH = Registry.field_212624_m.func_148757_b((Object)WNBiomes.WhiteBeach);
        MAHOGANY_RAINFOREST = Registry.field_212624_m.func_148757_b((Object)WNBiomes.MahoganyRainforest);
        MAHOGANY_CLIFFS = Registry.field_212624_m.func_148757_b((Object)WNBiomes.MahoganyCliffs);
        TROPICAL_ISLAND = Registry.field_212624_m.func_148757_b((Object)WNBiomes.TropicalIsland);
        MADAGASCAR = Registry.field_212624_m.func_148757_b((Object)WNBiomes.Madagascar);
        MADAGASCAR_VALLEY = Registry.field_212624_m.func_148757_b((Object)WNBiomes.MadagascarValley);
        TROPICAL_CLIFFS = Registry.field_212624_m.func_148757_b((Object)WNBiomes.TropicalCliffs);
        CANYONS = Registry.field_212624_m.func_148757_b((Object)WNBiomes.Canyons);
        GRAND_CANYON = Registry.field_212624_m.func_148757_b((Object)WNBiomes.GrandCanyon);
        CANYON_RIVER = Registry.field_212624_m.func_148757_b((Object)WNBiomes.CanyonRiver);
        ICELAND_RIVER = Registry.field_212624_m.func_148757_b((Object)WNBiomes.IcelandRiver);
        ICELANDS = Registry.field_212624_m.func_148757_b((Object)WNBiomes.Icelands);
        DAINTREE_RIVER = Registry.field_212624_m.func_148757_b((Object)WNBiomes.DaintreeRiver);
        DAINTREE_CLIFFS = Registry.field_212624_m.func_148757_b((Object)WNBiomes.DaintreeCliffs);
        POLDERS = Registry.field_212624_m.func_148757_b((Object)WNBiomes.Polders);
        POLDERS_EDGE = Registry.field_212624_m.func_148757_b((Object)WNBiomes.PoldersEdge);
        TATRA_FOOTHILLS = Registry.field_212624_m.func_148757_b((Object)WNBiomes.TatraFoothills);
        TATRA_LOWER_FOREST = Registry.field_212624_m.func_148757_b((Object)WNBiomes.TatraLowerForest);
        TATRA_UPPER_FOREST = Registry.field_212624_m.func_148757_b((Object)WNBiomes.TatraUpperForest);
        TATRA_MOUNTAINS = Registry.field_212624_m.func_148757_b((Object)WNBiomes.TatraMountains);
        TATRA_GREENED_PEAK = Registry.field_212624_m.func_148757_b((Object)WNBiomes.TatraGreenedPeak);
        TATRA_KASPROWY_PEAK = Registry.field_212624_m.func_148757_b((Object)WNBiomes.TatraKasprowyPeak);
        CHOCHOLOWSKA_GLADE = Registry.field_212624_m.func_148757_b((Object)WNBiomes.ChocholowskaGlade);
        FIREWEED_VALLEY = Registry.field_212624_m.func_148757_b((Object)WNBiomes.FireweedValley);
        CRACOW_GORGE = Registry.field_212624_m.func_148757_b((Object)WNBiomes.CracowGorge);
        MORSKIE_OKO = Registry.field_212624_m.func_148757_b((Object)WNBiomes.MorskieOko);
        GIEWONT = Registry.field_212624_m.func_148757_b((Object)WNBiomes.Giewont);
        RYSY = Registry.field_212624_m.func_148757_b((Object)WNBiomes.Rysy);
        TATRA_STREAM = Registry.field_212624_m.func_148757_b((Object)WNBiomes.TatraStream);
        SNOWY_TATRA_FOOTHILLS = Registry.field_212624_m.func_148757_b((Object)WNBiomes.SnowyTatraFoothills);
        SNOWY_TATRA_LOWER_FOREST = Registry.field_212624_m.func_148757_b((Object)WNBiomes.SnowyTatraLowerForest);
        SNOWY_TATRA_UPPER_FOREST = Registry.field_212624_m.func_148757_b((Object)WNBiomes.SnowyTatraUpperForest);
        SNOWY_TATRA_MOUNTAINS = Registry.field_212624_m.func_148757_b((Object)WNBiomes.SnowyTatraMountains);
        SNOWY_TATRA_KASPROWY_PEAK = Registry.field_212624_m.func_148757_b((Object)WNBiomes.SnowyTatraKasprowyPeak);
        SNOWY_CHOCHOLOWSKA_GLADE = Registry.field_212624_m.func_148757_b((Object)WNBiomes.SnowyChocholowskaGlade);
        SNOWY_FIREWEED_VALLEY = Registry.field_212624_m.func_148757_b((Object)WNBiomes.SnowyFireweedValley);
        SNOWY_CRACOW_GORGE = Registry.field_212624_m.func_148757_b((Object)WNBiomes.SnowyCracowGorge);
        FROZEN_MORSKIE_OKO = Registry.field_212624_m.func_148757_b((Object)WNBiomes.FrozenMorskieOko);
        SNOWY_GIEWONT = Registry.field_212624_m.func_148757_b((Object)WNBiomes.SnowyGiewont);
    }
}

