/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.world.generation.layer.grid;

import com.matez.wildnature.world.generation.biome.registry.WNBiomes;
import com.matez.wildnature.world.generation.biome.setup.grid.BiomeGroup;
import com.matez.wildnature.world.generation.biome.setup.grid.IslandBiome;
import com.matez.wildnature.world.generation.grid.Cell;
import com.matez.wildnature.world.generation.provider.WNGridBiomeProvider;
import com.matez.wildnature.world.generation.transformer.BiomeTransformer;
import com.matez.wildnature.world.generation.transformer.transformers.EdgeTransformer;
import com.matez.wildnature.world.generation.transformer.transformers.IslandTransformer;
import com.matez.wildnature.world.generation.transformer.transformers.MainBiomeTransformer;
import com.matez.wildnature.world.generation.transformer.transformers.MainSubbiomeTransformer;
import com.matez.wildnature.world.generation.transformer.transformers.RiverTransformer;
import com.matez.wildnature.world.generation.transformer.transformers.RiverValleyTransformer;
import com.matez.wildnature.world.generation.transformer.transformers.ShoreTransformer;
import java.util.ArrayList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.Heightmap;

public class GridBiomeLayer {
    public static ArrayList<BiomeGroup> OCEANS;
    private WNGridBiomeProvider provider;
    private final BiomeTransformer mainBiomeTransformer = new MainBiomeTransformer();
    private final BiomeTransformer mainSubBiomeTransformer = new MainSubbiomeTransformer();
    private final BiomeTransformer shoreTransformer = new ShoreTransformer();
    private final BiomeTransformer edgeTransformer = new EdgeTransformer();
    private final BiomeTransformer smallIslandTransformer = new IslandTransformer(IslandBiome.IslandType.SMALL);
    private final BiomeTransformer bigIslandTransformer = new IslandTransformer(IslandBiome.IslandType.BIG);
    private final BiomeTransformer riverTransformer = new RiverTransformer();
    private final BiomeTransformer riverValleyTransformer = new RiverValleyTransformer();

    public GridBiomeLayer(WNGridBiomeProvider provider) {
        this.provider = provider;
        OCEANS = new ArrayList();
        OCEANS.add(WNBiomes.OCEAN);
        OCEANS.add(WNBiomes.COLD_OCEAN);
        OCEANS.add(WNBiomes.FROZEN_OCEAN);
        OCEANS.add(WNBiomes.LUKEWARM_OCEAN);
        OCEANS.add(WNBiomes.WARM_OCEAN);
        OCEANS.add(WNBiomes.DEEP_OCEAN);
        OCEANS.add(WNBiomes.DEEP_COLD_OCEAN);
        OCEANS.add(WNBiomes.DEEP_FROZEN_OCEAN);
        OCEANS.add(WNBiomes.DEEP_LUKEWARM_OCEAN);
        OCEANS.add(WNBiomes.DEEP_WARM_OCEAN);
    }

    public Biome getBiome(int x, int z, boolean fakeBiomes) {
        Cell cell = this.provider.getNoiseCell(x, z);
        Biome b = this.get(x, z, cell, fakeBiomes);
        cell = null;
        return b;
    }

    public Biome getBiome(Cell cell, int x, int z, boolean fakeBiomes) {
        return this.get(x, z, cell, fakeBiomes);
    }

    public Biome filterBiomes(int x, int z, Cell cell, boolean fakeBiomes) {
        int directionMove = 16;
        Cell northCell = this.provider.getNoiseCell(x + directionMove, z).copy();
        Cell southCell = this.provider.getNoiseCell(x - directionMove, z).copy();
        Cell eastCell = this.provider.getNoiseCell(x, z + directionMove).copy();
        Cell westCell = this.provider.getNoiseCell(x, z - directionMove).copy();
        Biome biome = this.applyTransformers(x, z, cell, northCell, southCell, eastCell, westCell, fakeBiomes);
        northCell = null;
        southCell = null;
        eastCell = null;
        westCell = null;
        return biome;
    }

    public Biome applyTransformers(int x, int z, Cell cell, Cell northCell, Cell southCell, Cell eastCell, Cell westCell, boolean fakeBiomes) {
        BiomeGroup biomeGroup = null;
        biomeGroup = this.mainBiomeTransformer.bgApply(cell);
        BiomeGroup northBiomeGroup = northCell == cell ? biomeGroup : this.mainBiomeTransformer.bgApply(northCell);
        BiomeGroup southBiomeGroup = southCell == cell ? biomeGroup : this.mainBiomeTransformer.bgApply(southCell);
        BiomeGroup eastBiomeGroup = eastCell == cell ? biomeGroup : this.mainBiomeTransformer.bgApply(eastCell);
        BiomeGroup westBiomeGroup = westCell == cell ? biomeGroup : this.mainBiomeTransformer.bgApply(westCell);
        biomeGroup = this.bigIslandTransformer.bgApply(biomeGroup, cell);
        northBiomeGroup = this.bigIslandTransformer.bgApply(northBiomeGroup, northCell);
        southBiomeGroup = this.bigIslandTransformer.bgApply(southBiomeGroup, southCell);
        eastBiomeGroup = this.bigIslandTransformer.bgApply(eastBiomeGroup, eastCell);
        westBiomeGroup = this.bigIslandTransformer.bgApply(westBiomeGroup, westCell);
        biomeGroup = this.edgeTransformer.apply(biomeGroup, northBiomeGroup, southBiomeGroup, eastBiomeGroup, westBiomeGroup, cell);
        biomeGroup = this.shoreTransformer.apply(biomeGroup, northBiomeGroup, southBiomeGroup, eastBiomeGroup, westBiomeGroup, cell);
        if (fakeBiomes) {
            biomeGroup = this.riverValleyTransformer.bgApply(biomeGroup, cell);
        }
        biomeGroup = this.riverTransformer.bgApply(biomeGroup, cell);
        biomeGroup = this.smallIslandTransformer.bgApply(biomeGroup, cell);
        Biome biome = this.mainSubBiomeTransformer.apply(biomeGroup, cell);
        return biome;
    }

    public Biome get(int x, int z, Cell cell, boolean fakeBiomes) {
        return this.filterBiomes(x, z, cell.copy(), fakeBiomes);
    }

    public static Biome applyHeightmapBiome(Biome biome, BlockPos pos, IWorld world, int div) {
        return GridBiomeLayer.applyHeightmapBiome(Heightmap.Type.OCEAN_FLOOR_WG, biome, world.func_217349_x(pos), world.func_181545_F(), pos.func_177958_n() / div, pos.func_177952_p() / div);
    }

    public static Biome applyHeightmapBiome(Heightmap.Type type, Biome biome, IChunk chunk, int seaLevel, int x, int z) {
        if (biome.func_185355_j() > 0.0f && biome.func_201856_r() != Biome.Category.BEACH && biome.func_201856_r() != Biome.Category.SWAMP && chunk.func_201576_a(type, x, z) < seaLevel - 2) {
            BiomeTransformer.TempCategory category = BiomeTransformer.TempCategory.getFromTemperature(-0.1f, 1.0f, biome.func_185353_n());
            if (category == BiomeTransformer.TempCategory.ICY) {
                return WNBiomes.FrozenLake;
            }
            if (category == BiomeTransformer.TempCategory.COLD) {
                return WNBiomes.ColdLake;
            }
            if (category == BiomeTransformer.TempCategory.TEMPERATE) {
                return WNBiomes.WarmLake;
            }
            if (category == BiomeTransformer.TempCategory.WARM) {
                return WNBiomes.WarmLake;
            }
            if (category == BiomeTransformer.TempCategory.HOT) {
                return WNBiomes.WarmLake;
            }
        }
        return biome;
    }

    public BiomeTransformer getMainBiomeTransformer() {
        return this.mainBiomeTransformer;
    }
}

