/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.world.generation.maps;

import com.matez.wildnature.util.other.Utilities;
import com.matez.wildnature.world.generation.grid.Cell;
import com.matez.wildnature.world.generation.noise.fastNoise.FastNoise;
import java.util.Random;

public class ClimateMap {
    private int xMove;
    private int zMove;
    private long seed;

    public ClimateMap(long seed) {
        this.seed = seed;
        Random random = new Random(seed);
        this.xMove = Utilities.rint(-100000, 100000, random);
        this.zMove = Utilities.rint(-100000, 100000, random);
    }

    public void apply(Cell cell, float x, float z) {
        float dx = (float)this.xMove + x;
        float dz = (float)this.zMove + z;
        FastNoise tempNoise = new FastNoise((int)this.seed);
        tempNoise.SetNoiseType(FastNoise.NoiseType.Simplex);
        tempNoise.SetFrequency(5.0E-4f);
        FastNoise moistNoise = new FastNoise((int)this.seed);
        moistNoise.SetNoiseType(FastNoise.NoiseType.Simplex);
        moistNoise.SetFrequency(3.0E-4f);
        cell.cellTemparature = Utilities.scaleBetween(tempNoise.GetSimplex((float)cell.biomeCellX / 4.0f, cell.biomeCellZ), 1.0f, -1.0f, -0.8f, 0.8f);
        cell.temparature = Utilities.scaleBetween(tempNoise.GetSimplex(dx / 4.0f, dz), 1.0f, -1.0f, -0.8f, 0.8f);
        cell.cellMoisture = Utilities.scaleBetween(moistNoise.GetSimplex(cell.biomeCellX, cell.biomeCellZ), 1.0f, -1.0f, -0.6f, 0.6f);
        cell.moisture = Utilities.scaleBetween(moistNoise.GetSimplex(dx, dz), 1.0f, -1.0f, -0.6f, 0.6f);
    }
}

