/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.world.generation.noise;

import com.matez.wildnature.world.generation.noise.Noise;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Random;

public class OctaveNoiseSampler<T extends Noise> {
    private Noise[] samplers;
    private double clamp;
    private double frequency;
    private double amplitudeLow;
    private double amplitudeHigh;

    private Constructor<T> getNoiseConstructor(Class<T> clazz) {
        try {
            return clazz.getDeclaredConstructor(Long.TYPE);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            return null;
        }
    }

    private T create(Constructor<T> constructor, long seed) {
        if (constructor == null) {
            return null;
        }
        try {
            return (T)((Noise)constructor.newInstance(seed));
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public OctaveNoiseSampler(Class<T> classT, Random rand, int octaves, double frequency, double amplitudeHigh, double amplitudeLow) {
        this.samplers = new Noise[octaves];
        this.clamp = 1.0 / (1.0 - 1.0 / Math.pow(2.0, octaves));
        Constructor<T> constructor = this.getNoiseConstructor(classT);
        for (int i = 0; i < octaves; ++i) {
            this.samplers[i] = this.create(constructor, rand.nextLong());
        }
        this.frequency = frequency;
        this.amplitudeLow = amplitudeLow;
        this.amplitudeHigh = amplitudeHigh;
    }

    public double sample(double x, double y) {
        double amplFreq = 0.5;
        double result = 0.0;
        for (Noise sampler : this.samplers) {
            result += amplFreq * sampler.sample(x / (amplFreq * this.frequency), y / (amplFreq * this.frequency));
            amplFreq *= 0.5;
        }
        return (result *= this.clamp) > 0.0 ? result * this.amplitudeHigh : result * this.amplitudeLow;
    }

    public double sample(double x, double y, double z) {
        double amplFreq = 0.5;
        double result = 0.0;
        for (Noise sampler : this.samplers) {
            double freq = amplFreq * this.frequency;
            result += amplFreq * sampler.sample(x / freq, y / freq, z / freq);
            amplFreq *= 0.5;
        }
        return (result *= this.clamp) > 0.0 ? result * this.amplitudeHigh : result * this.amplitudeLow;
    }

    public double sampleCustom(double x, double y, double freqModifier, double amplitudeHMod, double amplitudeLMod, int octaves) {
        double amplFreq = 0.5;
        double result = 0.0;
        double sampleFreq = this.frequency * freqModifier;
        for (int i = 0; i < octaves; ++i) {
            Noise sampler = this.samplers[i];
            double freq = amplFreq * sampleFreq;
            result += amplFreq * sampler.sample(x / freq, y / freq);
            amplFreq *= 0.5;
        }
        double sampleClamp = 1.0 / (1.0 - 1.0 / Math.pow(2.0, octaves));
        return (result *= sampleClamp) > 0.0 ? result * this.amplitudeHigh * amplitudeHMod : result * this.amplitudeLow * amplitudeLMod;
    }

    public double sampleCustom(double x, double y, double z, double freqModifier, double amplitudeHMod, double amplitudeLMod, int octaves) {
        double amplFreq = 0.5;
        double result = 0.0;
        double sampleFreq = this.frequency * freqModifier;
        for (int i = 0; i < octaves; ++i) {
            Noise sampler = this.samplers[i];
            double freq = amplFreq * sampleFreq;
            result += amplFreq * sampler.sample(x / freq, y / freq, z / freq);
            amplFreq *= 0.5;
        }
        double sampleClamp = 1.0 / (1.0 - 1.0 / Math.pow(2.0, octaves));
        return (result *= sampleClamp) > 0.0 ? result * this.amplitudeHigh * amplitudeHMod : result * this.amplitudeLow * amplitudeLMod;
    }
}

