/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.world.generation.processors;

import com.matez.wildnature.world.generation.biome.setup.WNGenSettings;
import com.matez.wildnature.world.generation.processors.TerrainProcessor;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;

public class ThermalErosionProcessor
implements TerrainProcessor {
    private int size = 16;
    private final double threshold = 0.6f;
    private final double amplitude = 0.8f;
    private ChunkGenerator<WNGenSettings> generator;
    private BlockState DEFAULT_FLUID;
    private static final int[] vertexData = new int[]{0, 1, 1, 1, 1, 0, 1, -1, 0, -1, -1, -1, -1, 0, -1, 1};
    private Heightmap.Type heightmap = Heightmap.Type.MOTION_BLOCKING_NO_LEAVES;

    @Override
    public void init(ChunkGenerator<WNGenSettings> generator, long seed) {
        this.generator = generator;
        this.DEFAULT_FLUID = ((WNGenSettings)generator.func_201496_a_()).func_205533_m();
    }

    private IChunk[] getNeighbours(IWorld world, int x, int z) {
        return new IChunk[]{world.func_212866_a_(x - 1, z), world.func_212866_a_(x - 1, z + 1), world.func_212866_a_(x, z + 1), world.func_212866_a_(x + 1, z + 1), world.func_212866_a_(x + 1, z), world.func_212866_a_(x + 1, z - 1), world.func_212866_a_(x, z - 1), world.func_212866_a_(x - 1, z - 1)};
    }

    private int[] next(int x, int z, int k) {
        return new int[]{vertexData[2 * k] + x, vertexData[2 * k + 1] + z};
    }

    private int[] wrapPosition(int x, int z, IChunk[] borders) {
        int k = -1;
        if (x < 0) {
            if (z < 0) {
                k = 7;
                z = this.size - 1;
            } else if (z >= this.size) {
                k = 1;
                z = 0;
            } else {
                k = 0;
            }
            x = this.size - 1;
        } else if (x >= this.size) {
            if (z < 0) {
                k = 5;
                z = this.size - 1;
            } else if (z >= this.size) {
                k = 3;
                z = 0;
            } else {
                k = 4;
            }
            x = 0;
        } else if (z < 0) {
            k = 6;
            z = this.size - 1;
        } else if (z >= this.size) {
            k = 2;
            z = 0;
        }
        return new int[]{k, x, z};
    }

    private int[] applyAmplitude(int fX, int fZ, int tX, int tZ, int k, IChunk[] borders, int[] noise) {
        int n = fX * this.size + fZ;
        noise[n] = (int)((double)noise[n] + (double)0.8f);
        if (k != -1) {
            int tY = borders[k].func_201576_a(this.heightmap, tX, tZ);
            BlockPos displacementPos = new BlockPos(tX, tY, tZ);
            if (tY <= 63) {
                borders[k].func_177436_a(displacementPos, this.DEFAULT_FLUID, false);
            } else {
                borders[k].func_177436_a(displacementPos, Blocks.field_150350_a.func_176223_P(), false);
            }
        } else {
            int n2 = tX * this.size + tZ;
            noise[n2] = (int)((double)noise[n2] - (double)0.8f);
        }
        return noise;
    }

    private int[] thermalStep(IChunk chunkIn, IChunk[] borders, int[] noise) {
        for (int x = 0; x < this.size; ++x) {
            for (int z = 0; z < this.size; ++z) {
                int val = noise[x * this.size + z];
                int xSlope = -1;
                int zSlope = -1;
                double maxZDiff = -1.0;
                int kthBorder = -1;
                for (int k = 0; k < 8; ++k) {
                    double zDiff;
                    int height = -1;
                    int[] nextVals = this.next(x, z, k);
                    int xn = nextVals[0];
                    int zn = nextVals[1];
                    if (xn < 0 || xn >= this.size || zn < 0 || zn >= this.size) {
                        int[] wrappedData = this.wrapPosition(xn, zn, borders);
                        kthBorder = wrappedData[0];
                        xn = wrappedData[1];
                        zn = wrappedData[2];
                        height = borders[kthBorder].func_201576_a(this.heightmap, xn, zn);
                    }
                    if (height == -1) {
                        height = noise[xn * this.size + zn];
                    }
                    if (!((zDiff = (double)(val - height)) > 0.0) || !(zDiff > maxZDiff)) continue;
                    maxZDiff = zDiff;
                    xSlope = xn;
                    zSlope = zn;
                }
                if (!(maxZDiff / (double)(x - xSlope) > (double)0.6f)) continue;
                this.applyAmplitude(xSlope, zSlope, x, z, kthBorder, borders, noise);
            }
        }
        return noise;
    }

    @Override
    public void process(IWorld world, IChunk chunk, Random rand, int chunkX, int chunkZ, int relativeX, int relativeZ, int[] noise) {
        IChunk chunkIn = world.func_212866_a_(chunkX, chunkZ);
        IChunk[] borders = this.getNeighbours(world, chunkX, chunkZ);
        int iterations = 3000;
        for (int i = 0; i < iterations; ++i) {
            this.thermalStep(chunkIn, borders, noise);
        }
        BlockPos.Mutable pos = new BlockPos.Mutable();
        for (int x = 0; x < this.size; ++x) {
            for (int z = 0; z < this.size; ++z) {
                for (int y = noise[x * 16 + z]; y < 256; ++y) {
                    pos.func_181079_c(x, y, z);
                    if (y <= 63) {
                        chunkIn.func_177436_a((BlockPos)pos, this.DEFAULT_FLUID, false);
                        continue;
                    }
                    chunkIn.func_177436_a((BlockPos)pos, Blocks.field_150350_a.func_176223_P(), false);
                }
            }
        }
    }
}

