/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.world.generation.processors;

import com.matez.wildnature.world.generation.biome.setup.WNGenSettings;
import com.matez.wildnature.world.generation.processors.TerrainProcessor;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;

public class ThermalErosionTestProcessor
implements TerrainProcessor {
    public int size = 16;
    private final float threshold = 0.6f;
    private final double amplitude = 0.8f;
    private BlockState DEFAULT_FLUID;
    private ChunkGenerator<WNGenSettings> generator;

    @Override
    public void init(ChunkGenerator<WNGenSettings> generator, long seed) {
        this.generator = generator;
        this.DEFAULT_FLUID = ((WNGenSettings)generator.func_201496_a_()).func_205533_m();
    }

    private int[] next(int x, int z, int k) {
        int[][] storedData = new int[9][2];
        int i = 0;
        for (int xo = -1; xo <= 1; ++xo) {
            for (int zo = -1; zo <= 1; ++zo) {
                storedData[i++] = new int[]{x + xo, z + zo};
            }
        }
        return storedData[k];
    }

    private void thermalStep(IChunk chunkIn, int x, int z, int[] noise) {
        int val = noise[x * this.size + z];
        int slopeX = -1;
        int slopeZ = -1;
        float maxZDiff = -1.0f;
        for (int k = 0; k < 8; ++k) {
            float zDiff;
            int[] nextVals = this.next(x, z, k);
            int xn = nextVals[0];
            int zn = nextVals[1];
            if (xn < 0 || xn >= this.size || zn < 0 || zn >= this.size || !((zDiff = (float)(val - noise[xn * this.size + zn])) > 0.0f) || !(zDiff > maxZDiff)) continue;
            maxZDiff = zDiff;
            slopeX = xn;
            slopeZ = zn;
        }
        if (maxZDiff / (float)(x - slopeX) > 0.6f) {
            this.applyAmplitude(chunkIn, slopeX, slopeZ, x, z, noise);
        }
        if (maxZDiff / (float)(z - slopeZ) > 0.6f) {
            this.applyAmplitude(chunkIn, slopeX, slopeZ, x, z, noise);
        }
    }

    private int[] applyAmplitude(IChunk chunk, int fX, int fZ, int tX, int tZ, int[] noise) {
        int n = fX * this.size + fZ;
        noise[n] = (int)((double)noise[n] + (double)0.8f);
        BlockPos pos = new BlockPos(tX, noise[tX * this.size + tZ], tZ);
        if (chunk.func_180495_p(pos) != this.DEFAULT_FLUID) {
            chunk.func_177436_a(pos, Blocks.field_150350_a.func_176223_P(), false);
        }
        return noise;
    }

    @Override
    public void process(IWorld world, IChunk chunk, Random rand, int chunkX, int chunkZ, int relativeX, int relativeZ, int[] noise) {
        int iterations = 3000000;
        for (int i = 0; i < iterations; ++i) {
            this.thermalStep(chunk, relativeX, relativeZ, noise);
        }
    }
}

