/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.world.generation.provider;

import com.matez.wildnature.world.generation.chunk.WNWorldContext;
import com.matez.wildnature.world.generation.grid.Cell;
import com.matez.wildnature.world.generation.layer.grid.GridBiomeLayer;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.biome.provider.OverworldBiomeProviderSettings;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.registries.ForgeRegistries;

public class WNGridBiomeProvider
extends BiomeProvider {
    private OverworldBiomeProviderSettings settings;
    private WNWorldContext context;
    private GridBiomeLayer layer;

    protected WNGridBiomeProvider(OverworldBiomeProviderSettings settings) {
        super(WNGridBiomeProvider.getBiomes());
        this.settings = settings;
        this.layer = new GridBiomeLayer(this);
    }

    public GridBiomeLayer getLayer() {
        return this.layer;
    }

    public void setContext(WNWorldContext context) {
        this.context = context;
    }

    public WNWorldContext getContext() {
        return this.context;
    }

    private static Set<Biome> getBiomes() {
        HashSet<Biome> biomeSet = new HashSet<Biome>();
        for (Biome biome : ForgeRegistries.BIOMES) {
            if (!BiomeDictionary.getTypes((Biome)biome).contains(BiomeDictionary.Type.OVERWORLD)) continue;
            biomeSet.add(biome);
        }
        return biomeSet;
    }

    public Cell getNoiseCell(int x, int z) {
        return this.context.getHeightmap().apply(new Cell(), x, z);
    }

    public Biome getNoiseBiome(int x, int y, int z, boolean fakeBiomes) {
        return this.layer.getBiome(x, z, fakeBiomes);
    }

    public Biome getNoiseBiome(Cell cell, int x, int y, int z) {
        return this.layer.getBiome(cell, x, z, false);
    }

    public Biome getNoiseBiome(Cell cell, int x, int y, int z, boolean fakeBiomes) {
        return this.layer.getBiome(cell, x, z, fakeBiomes);
    }

    public Biome func_225526_b_(int x, int y, int z) {
        return this.layer.getBiome(x, z, false);
    }
}

