/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.world.generation.provider;

import com.matez.wildnature.client.gui.screen.world.WNWorldSettingsScreen;
import com.matez.wildnature.init.WN;
import com.matez.wildnature.util.config.CommonConfig;
import com.matez.wildnature.world.generation.biome.setup.WNGenSettings;
import com.matez.wildnature.world.generation.chunk.WNWorldContext;
import com.matez.wildnature.world.generation.chunk.deprecated.WNChunkGeneratorOverworld;
import com.matez.wildnature.world.generation.chunk.generation.WNSimplexChunkGenerator;
import com.matez.wildnature.world.generation.chunk.type.WNChunkGeneratorType;
import com.matez.wildnature.world.generation.layer.WNBiomeLayer;
import com.matez.wildnature.world.generation.provider.WNBiomeProviderType;
import com.matez.wildnature.world.generation.provider.WNGridBiomeProvider;
import java.util.function.LongFunction;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.CreateBuffetWorldScreen;
import net.minecraft.client.gui.screen.CreateFlatWorldScreen;
import net.minecraft.client.gui.screen.CreateWorldScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.biome.provider.BiomeProviderType;
import net.minecraft.world.biome.provider.IBiomeProviderSettings;
import net.minecraft.world.biome.provider.OverworldBiomeProviderSettings;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.ChunkGeneratorType;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.IExtendedNoiseRandom;
import net.minecraft.world.gen.OverworldGenSettings;
import net.minecraft.world.gen.area.IArea;
import net.minecraft.world.gen.area.IAreaFactory;
import net.minecraft.world.gen.layer.AddBambooForestLayer;
import net.minecraft.world.gen.layer.EdgeBiomeLayer;
import net.minecraft.world.gen.layer.LayerUtil;
import net.minecraft.world.gen.layer.ZoomLayer;
import net.minecraft.world.gen.layer.traits.IAreaTransformer1;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class WNWorldType
extends WorldType {
    public static WNSimplexChunkGenerator generator;

    public WNWorldType(String name) {
        super(name);
    }

    public ChunkGenerator<?> createChunkGenerator(World world) {
        System.out.println("Generating dimension: " + world.func_201675_m().func_186058_p().toString());
        if (world.func_201675_m().func_186058_p() == DimensionType.field_223227_a_) {
            WN.wnInfo("Generating WildNature World");
            WN.runningWorld = world;
            ChunkGeneratorType<WNGenSettings, WNChunkGeneratorOverworld> genOld = WNChunkGeneratorType.WILDNATURE;
            ChunkGeneratorType<WNGenSettings, WNSimplexChunkGenerator> genNew = WNChunkGeneratorType.SIMPLEX_TEST;
            WNGenSettings genSettings = (WNGenSettings)genOld.func_205483_a();
            genSettings.func_214969_a(Blocks.field_150348_b.func_176223_P());
            genSettings.func_214970_b(Blocks.field_150355_j.func_176223_P());
            WNWorldContext context = new WNWorldContext(world.func_72905_C());
            WN.LOGGER.info("Seed set to " + context.getSeed());
            BiomeProviderType<OverworldBiomeProviderSettings, WNGridBiomeProvider> bpt = WNBiomeProviderType.WILDNATURE_GRID;
            OverworldBiomeProviderSettings settings = ((OverworldBiomeProviderSettings)bpt.func_226840_a_(world.func_72912_H())).func_205441_a(new OverworldGenSettings());
            WNGridBiomeProvider provider = (WNGridBiomeProvider)bpt.func_205457_a((IBiomeProviderSettings)settings);
            provider.setContext(context);
            if (((String)CommonConfig.generatorType.get()).equals("old")) {
                return genOld.create(world, (BiomeProvider)provider, (GenerationSettings)genSettings);
            }
            WNSimplexChunkGenerator generator = (WNSimplexChunkGenerator)genNew.create(world, (BiomeProvider)provider, (GenerationSettings)genSettings);
            generator.setContext(context);
            WNWorldType.generator = generator;
            return generator;
        }
        return world.func_201675_m().func_186060_c();
    }

    public <T extends IArea, C extends IExtendedNoiseRandom<T>> IAreaFactory<T> getBiomeLayer(IAreaFactory<T> parentLayer, OverworldGenSettings chunkSettings, LongFunction<C> contextFactory) {
        parentLayer = new WNBiomeLayer(this.getWorldType(), chunkSettings.func_202199_l()).func_202713_a((IExtendedNoiseRandom)contextFactory.apply(200L), parentLayer);
        parentLayer = AddBambooForestLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(1001L), parentLayer);
        parentLayer = LayerUtil.func_202829_a((long)1000L, (IAreaTransformer1)ZoomLayer.NORMAL, (IAreaFactory)parentLayer, (int)2, contextFactory);
        parentLayer = EdgeBiomeLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(1000L), parentLayer);
        return parentLayer;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onCustomizeButton(Minecraft mc, CreateWorldScreen gui) {
        if (this == WorldType.field_77138_c) {
            mc.func_147108_a((Screen)new CreateFlatWorldScreen(gui, gui.field_146334_a));
        } else if (this == WorldType.field_205394_h) {
            mc.func_147108_a((Screen)new CreateBuffetWorldScreen(gui, gui.field_146334_a));
        } else if (this == WN.WNWorldType) {
            mc.func_147108_a((Screen)new WNWorldSettingsScreen(gui, gui.field_146334_a));
        }
    }
}

