/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.world.generation.structures.nature.fallen;

import com.google.gson.annotations.Expose;
import com.matez.wildnature.common.blocks.FloweringLeaves;
import com.matez.wildnature.common.blocks.FruitableLeaves;
import com.matez.wildnature.util.lists.WNBlocks;
import com.matez.wildnature.util.other.Utilities;
import com.matez.wildnature.world.generation.structures.nature.SchemFeature;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.LogBlock;
import net.minecraft.block.SnowBlock;
import net.minecraft.block.VineBlock;
import net.minecraft.fluid.Fluids;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;

public class FallenSchemFeature
extends SchemFeature {
    private final int maxFall = 25;
    @Expose
    public ArrayList<BlockPos> vineBlocks = new ArrayList();

    @Override
    protected boolean place(IWorldGenerationReader worldIn, Random rand, BlockPos position, boolean isNaturalPlace) {
        BlockPos soilPos = position.func_177977_b();
        if (isNaturalPlace) {
            if (!this.canGrowTree(worldIn, position.func_177977_b(), this.getSapling())) {
                return false;
            }
            int x = 0;
            while (FallenSchemFeature.isWater((IWorldGenerationBaseReader)worldIn, soilPos)) {
                soilPos = soilPos.func_177977_b();
                ++x;
            }
            if (x >= 15) {
                return false;
            }
        }
        this.world = (IWorld)worldIn;
        this.startBlockPos = soilPos.func_177981_b(this.terrainIncrease + 2);
        this.random = rand;
        this.rotation = Utilities.rint(1, 4, rand);
        this.canGenerate = true;
        this.addedBlocks.clear();
        this.vineBlocks.clear();
        this.virtualPlace = false;
        this.setBlocks();
        this.checkVines();
        this.addedBlocks.clear();
        this.vineBlocks.clear();
        return true;
    }

    private void checkVines() {
        for (BlockPos vineBlock : this.vineBlocks) {
            BlockState state = this.world.func_180495_p(vineBlock);
            if (state.func_196955_c((IWorldReader)this.world, vineBlock)) continue;
            this.world.func_180501_a(vineBlock, Blocks.field_150350_a.func_176223_P(), 2);
        }
    }

    @Override
    public void Block(int x, int y, int z, BlockState state) {
        if (this.LOG_OVERRIDE != null && state.func_177230_c() instanceof LogBlock) {
            state = this.LOG_OVERRIDE;
        }
        if (this.LEAVES_OVERRIDE != null && state.func_177230_c() instanceof LeavesBlock) {
            state = this.LEAVES_OVERRIDE;
        }
        if (state.func_177230_c() == WNBlocks.MAGNOLIA_LEAVES || state.func_177230_c() == WNBlocks.FORSYTHIA_LEAVES || Utilities.rint(0, 10) == 0) {
            if (state.func_177230_c() instanceof FloweringLeaves) {
                state = (BlockState)state.func_206870_a((IProperty)FloweringLeaves.FLOWERING, (Comparable)Boolean.valueOf(true));
            } else if (state.func_177230_c() instanceof FruitableLeaves) {
                state = (BlockState)state.func_206870_a((IProperty)((FruitableLeaves)state.func_177230_c()).getStage(), (Comparable)Integer.valueOf(Utilities.rint(1, ((FruitableLeaves)state.func_177230_c()).getMaxStages())));
            }
        }
        BlockPos pos = this.startBlockPos;
        int sx = this.startBlockPos.func_177958_n();
        int sy = this.startBlockPos.func_177956_o() - 1;
        int sz = this.startBlockPos.func_177952_p();
        if (this.rotation >= 1 && this.rotation <= 4) {
            if (this.rotation == 1) {
                pos = new BlockPos(x, y, z);
            } else if (this.rotation == 2) {
                pos = new BlockPos(x, y, z).func_190942_a(Rotation.CLOCKWISE_180);
                state = state.func_185907_a(Rotation.CLOCKWISE_180);
            } else if (this.rotation == 3) {
                pos = new BlockPos(x, y, z).func_190942_a(Rotation.CLOCKWISE_90);
                state = state.func_185907_a(Rotation.CLOCKWISE_90);
            } else {
                pos = new BlockPos(x, y, z).func_190942_a(Rotation.COUNTERCLOCKWISE_90);
                state = state.func_185907_a(Rotation.COUNTERCLOCKWISE_90);
            }
        } else {
            throw new IllegalArgumentException("Unknown rotation for tree at " + this.startBlockPos.toString() + " :\nrotation = " + this.rotation + " (1-4)\n   Please report it to author!");
        }
        pos = new BlockPos(pos.func_177958_n() + sx, pos.func_177956_o() + sy, pos.func_177952_p() + sz);
        if (this.world.func_180495_p(pos).func_177230_c() == Blocks.field_150355_j && state.func_177230_c() instanceof IWaterLoggable) {
            state = (BlockState)state.func_206870_a((IProperty)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(true));
        }
        pos = this.fallBlock(this.world, state, pos);
        if (!state.func_200132_m() && (this.world.func_180495_p(pos).func_200132_m() || this.world.func_180495_p(pos).func_204520_s().func_206886_c() == Fluids.field_204546_a || this.world.func_180495_p(pos).func_204520_s().func_206886_c() == Fluids.field_204547_b)) {
            return;
        }
        if (!this.virtualPlace) {
            if (this.isLeaf(state.func_177230_c()) && !this.world.func_180495_p(pos).func_200132_m()) {
                this.world.func_180501_a(pos, state, 19);
            } else if (!this.isLeaf(state.func_177230_c())) {
                this.world.func_180501_a(pos, state, 19);
            }
        }
        if (this.isLeaf(state.func_177230_c()) && !this.world.func_180495_p(pos).func_200132_m() || !this.isLeaf(state.func_177230_c())) {
            this.addedBlocks.add(pos);
            if (state.func_177230_c() instanceof VineBlock) {
                this.vineBlocks.add(pos);
            }
        }
    }

    private BlockPos fallBlock(IWorld world, BlockState state, BlockPos pos) {
        BlockPos.Mutable mutable = new BlockPos.Mutable(pos);
        for (int i = 0; i < 25; ++i) {
            if (mutable.func_177977_b().func_177956_o() <= 5) {
                return mutable;
            }
            if (world.func_180495_p(mutable.func_177977_b()).func_200132_m() && !(world.func_180495_p(mutable.func_177977_b()).func_177230_c() instanceof SnowBlock)) break;
            mutable.func_185336_p(mutable.func_177956_o() - 1);
        }
        return mutable;
    }

    @Override
    public FallenSchemFeature setCustomLeafOverride(BlockState leaf) {
        super.setCustomLeafOverride(leaf);
        return this;
    }

    @Override
    public FallenSchemFeature setCustomLogOverride(BlockState log) {
        super.setCustomLogOverride(log);
        return this;
    }
}

