/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.world.generation.surface.builders;

import com.matez.wildnature.world.generation.noise.bukkit.SimplexOctaveGenerator;
import com.matez.wildnature.world.generation.noise.sponge.module.source.Perlin;
import com.matez.wildnature.world.generation.noise.sponge.module.source.RidgedMulti;
import com.matez.wildnature.world.generation.surface.configs.CanyonSurfaceBuilderConfig;
import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.surfacebuilders.ISurfaceBuilderConfig;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;

public class GrandCanyonSurfaceBuilder
extends SurfaceBuilder<CanyonSurfaceBuilderConfig> {
    private static final RidgedMulti ridgedMultiNoise = new RidgedMulti();
    private static final Perlin heightNoise = new Perlin();
    public static SimplexOctaveGenerator crackNoise;

    public GrandCanyonSurfaceBuilder(Function<Dynamic<?>, ? extends CanyonSurfaceBuilderConfig> p_i51312_1_) {
        super(p_i51312_1_);
        ridgedMultiNoise.setFrequency(0.01);
        ridgedMultiNoise.setOctaveCount(1);
        ridgedMultiNoise.setLacunarity(0.0);
        heightNoise.setFrequency(0.03);
        heightNoise.setOctaveCount(2);
        heightNoise.setLacunarity(0.0);
        heightNoise.setPersistence(-0.4);
        this.setRegistryName("wildnature", "grand_canyon_surface_builder");
    }

    public void buildSurface(Random random, IChunk chunkIn, Biome biomeIn, int x, int z, int startHeight, double noise, BlockState defaultBlock, BlockState defaultFluid, int seaLevel, long seed, CanyonSurfaceBuilderConfig config) {
        ridgedMultiNoise.setSeed((int)seed);
        heightNoise.setSeed((int)seed);
        int realY = startHeight;
        int realY1 = startHeight;
        int realY2 = startHeight;
        int realY3 = startHeight;
        int realY4 = startHeight;
        int realY5 = startHeight;
        double vnoise = ridgedMultiNoise.getValue(x, 1.0, z);
        double hnoise = heightNoise.getValue(x, 1.0, z);
        double hvar = 0.0;
        if (hnoise >= 0.2) {
            hvar += 1.0;
            if (hnoise >= 0.28) {
                hvar += 1.0;
            }
            if (hnoise >= 0.35) {
                hvar += 1.0;
            }
        } else if (hnoise < 0.18) {
            hvar -= 1.0;
        }
        if (vnoise >= 0.45 && vnoise <= 2.0) {
            int a;
            int startPointY2;
            int height2;
            BlockPos pos = new BlockPos((double)x, (double)(seaLevel + 90) + hvar, (double)z);
            int height = this.getNoiseHeight(vnoise, 0.45, 0.625, 20, 60, 17, 0.63, random, seed, pos);
            realY -= height;
            int startPointY = -height / 2;
            for (int a2 = pos.func_177956_o() - startPointY; a2 > pos.func_177956_o() - height; --a2) {
                if (a2 >= seaLevel) {
                    chunkIn.func_177436_a(new BlockPos(pos.func_177958_n(), a2, pos.func_177952_p()), Blocks.field_150350_a.func_176223_P(), false);
                    continue;
                }
                chunkIn.func_177436_a(new BlockPos(pos.func_177958_n(), a2, pos.func_177952_p()), Blocks.field_150355_j.func_176223_P(), false);
            }
            if (vnoise >= 0.48) {
                BlockPos pos2 = new BlockPos((double)x, (double)(seaLevel + 60) + hvar, (double)z);
                height2 = this.getNoiseHeight(vnoise, 0.48, 0.625, 15, 40, 17, 0.63, random, seed, pos);
                realY1 -= height2;
                startPointY2 = -height2 / 2;
                for (a = pos2.func_177956_o() - startPointY2; a > pos2.func_177956_o() - height2; --a) {
                    if (a >= seaLevel) {
                        chunkIn.func_177436_a(new BlockPos(pos2.func_177958_n(), a, pos2.func_177952_p()), Blocks.field_150350_a.func_176223_P(), false);
                        continue;
                    }
                    chunkIn.func_177436_a(new BlockPos(pos2.func_177958_n(), a, pos2.func_177952_p()), Blocks.field_150355_j.func_176223_P(), false);
                }
            }
            if (vnoise >= 0.51) {
                BlockPos pos2 = new BlockPos((double)x, (double)(seaLevel + 35) + hvar, (double)z);
                height2 = this.getNoiseHeight(vnoise, 0.51, 0.625, 10, 25, 17, 0.63, random, seed, pos);
                realY2 -= height2;
                startPointY2 = -height2 / 2;
                for (a = pos2.func_177956_o() - startPointY2; a > pos2.func_177956_o() - height2; --a) {
                    if (a >= seaLevel) {
                        chunkIn.func_177436_a(new BlockPos(pos2.func_177958_n(), a, pos2.func_177952_p()), Blocks.field_150350_a.func_176223_P(), false);
                        continue;
                    }
                    chunkIn.func_177436_a(new BlockPos(pos2.func_177958_n(), a, pos2.func_177952_p()), Blocks.field_150355_j.func_176223_P(), false);
                }
            }
            if (vnoise >= 0.54) {
                BlockPos pos2 = new BlockPos((double)x, (double)(seaLevel + 25) + hvar, (double)z);
                height2 = this.getNoiseHeight(vnoise, 0.54, 0.625, 6, 15, 17, 0.63, random, seed, pos);
                realY3 -= height2;
                startPointY2 = -height2 / 2;
                for (a = pos2.func_177956_o() - startPointY2; a > pos2.func_177956_o() - height2; --a) {
                    if (a >= seaLevel) {
                        chunkIn.func_177436_a(new BlockPos(pos2.func_177958_n(), a, pos2.func_177952_p()), Blocks.field_150350_a.func_176223_P(), false);
                        continue;
                    }
                    chunkIn.func_177436_a(new BlockPos(pos2.func_177958_n(), a, pos2.func_177952_p()), Blocks.field_150355_j.func_176223_P(), false);
                }
            }
            if (vnoise >= 0.57) {
                BlockPos pos2 = new BlockPos((double)x, (double)(seaLevel + 8) + hvar, (double)z);
                height2 = this.getNoiseHeight(vnoise, 0.57, 0.625, 1, 13, 17, 0.63, random, seed, pos);
                realY5 -= height2;
                startPointY2 = -height2 / 2;
                for (a = pos2.func_177956_o() - startPointY2; a > pos2.func_177956_o() - height2; --a) {
                    if (a >= seaLevel) {
                        chunkIn.func_177436_a(new BlockPos(pos2.func_177958_n(), a, pos2.func_177952_p()), Blocks.field_150350_a.func_176223_P(), false);
                        continue;
                    }
                    chunkIn.func_177436_a(new BlockPos(pos2.func_177958_n(), a, pos2.func_177952_p()), Blocks.field_150355_j.func_176223_P(), false);
                }
            }
            if (vnoise >= 0.58) {
                BlockPos pos2 = new BlockPos((double)x, (double)seaLevel + hvar, (double)z);
                height2 = this.getNoiseHeight(vnoise, 0.58, 0.625, 0, 10, 17, 0.63, random, seed, pos);
                realY4 -= height2;
                startPointY2 = -height2 / 2;
                for (a = pos2.func_177956_o() - startPointY2; a > pos2.func_177956_o() - height2; --a) {
                    if (a >= seaLevel) {
                        chunkIn.func_177436_a(new BlockPos(pos2.func_177958_n(), a, pos2.func_177952_p()), Blocks.field_150350_a.func_176223_P(), false);
                        continue;
                    }
                    chunkIn.func_177436_a(new BlockPos(pos2.func_177958_n(), a, pos2.func_177952_p()), Blocks.field_150355_j.func_176223_P(), false);
                }
            }
        }
        config.getConfig().func_205548_a(seed);
        config.getConfig().func_205610_a_(random, chunkIn, biomeIn, x, z, realY, noise, defaultBlock, defaultFluid, seaLevel, seed, (ISurfaceBuilderConfig)config);
        config.getConfig().func_205610_a_(random, chunkIn, biomeIn, x, z, realY1, noise, defaultBlock, defaultFluid, seaLevel, seed, (ISurfaceBuilderConfig)config);
        config.getConfig().func_205610_a_(random, chunkIn, biomeIn, x, z, realY2, noise, defaultBlock, defaultFluid, seaLevel, seed, (ISurfaceBuilderConfig)config);
        config.getConfig().func_205610_a_(random, chunkIn, biomeIn, x, z, realY3, noise, defaultBlock, defaultFluid, seaLevel, seed, (ISurfaceBuilderConfig)config);
        config.getConfig().func_205610_a_(random, chunkIn, biomeIn, x, z, realY4, noise, defaultBlock, defaultFluid, seaLevel, seed, (ISurfaceBuilderConfig)config);
        config.getConfig().func_205610_a_(random, chunkIn, biomeIn, x, z, realY5, noise, defaultBlock, defaultFluid, seaLevel, seed, (ISurfaceBuilderConfig)config);
    }

    public int getNoiseHeight(double noise, double minNoise, double maxNoise, int minHeight, int maxHeight, int maxHeightIfCavern, double cavernWhenNoise, Random random, long seed, BlockPos pos) {
        return this.calculateHeightByCenter(noise, minNoise, maxNoise, minHeight, maxHeight, maxHeightIfCavern, cavernWhenNoise);
    }

    private int calculateHeightByCenter(double noise, double minNoise, double maxNoise, int minHeight, int maxHeight, int maxHeightIfCavern, double cavernWhenNoise) {
        double noiseCenter = (maxNoise - minNoise) / 2.0 + minNoise;
        double noisePercent = 0.0;
        noisePercent = noiseCenter > noise ? this.calculatePercent(noise, minNoise, noiseCenter) : (noiseCenter < noise ? (noise > cavernWhenNoise ? this.calculatePercent(noise, maxHeightIfCavern, noiseCenter) : this.calculatePercent(noise, maxHeight, noiseCenter)) : 1.0);
        int maxHeightCalc = maxHeight - minHeight;
        double height = (double)maxHeightCalc * noisePercent;
        return (int)Math.round(height) + minHeight;
    }

    private double calculatePercent(double noise, double minNoise, double maxNoise) {
        double maxNoiseCalc = maxNoise - minNoise;
        double noiseCalc = noise - minNoise;
        return noiseCalc / maxNoiseCalc;
    }
}

