/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.world.generation.transformer;

import com.google.common.collect.ArrayListMultimap;
import com.matez.wildnature.init.WN;
import com.matez.wildnature.util.noise.NoiseUtil;
import com.matez.wildnature.util.other.Utilities;
import com.matez.wildnature.world.generation.biome.registry.WNBiomes;
import com.matez.wildnature.world.generation.biome.setup.grid.BiomeGroup;
import com.matez.wildnature.world.generation.grid.Cell;
import com.matez.wildnature.world.generation.transformer.transformers.MainBiomeTransformer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;

public abstract class BiomeTransformer {
    public BiomeGroup bgApply(Cell cell) {
        return this.bgApply(TempCategory.getFromTemperature(-1.0f, 1.0f, cell.cellTemparature), WetCategory.getFromMoisture(-1.0f, 1.0f, cell.cellMoisture), cell, BiomeTransformer.getCategoryFromContinent(cell.cellContinent), cell.biomeCellIdentity);
    }

    protected BiomeGroup bgApply(TempCategory tempCategory, WetCategory wetCategory, Cell cell, MainBiomeTransformer.TerrainCategory category, float identity) {
        return null;
    }

    public BiomeGroup bgApply(BiomeGroup oldBiomeGroup, Cell cell) {
        return this.bgApply(oldBiomeGroup, TempCategory.getFromTemperature(-0.1f, 1.0f, oldBiomeGroup.getBaseBiome().func_185353_n()), WetCategory.getFromMoisture(0.0f, 1.0f, oldBiomeGroup.getBaseBiome().func_76727_i()), cell, BiomeTransformer.getCategoryFromContinent(cell.continentValue), cell.subBiomeCellIdentity);
    }

    protected BiomeGroup bgApply(BiomeGroup oldBiomeGroup, TempCategory tempCategory, WetCategory wetCategory, Cell cell, MainBiomeTransformer.TerrainCategory category, float identity) {
        return oldBiomeGroup;
    }

    public BiomeGroup bgApply(int x, int z, BiomeGroup oldBiomeGroup, Cell cell) {
        return this.bgApply(x, z, oldBiomeGroup, TempCategory.getFromTemperature(-0.1f, 1.0f, oldBiomeGroup.getBaseBiome().func_185353_n()), WetCategory.getFromMoisture(0.0f, 1.0f, oldBiomeGroup.getBaseBiome().func_76727_i()), cell, BiomeTransformer.getCategoryFromContinent(cell.continentValue), cell.subBiomeCellIdentity);
    }

    protected BiomeGroup bgApply(int x, int z, BiomeGroup oldBiomeGroup, TempCategory tempCategory, WetCategory wetCategory, Cell cell, MainBiomeTransformer.TerrainCategory category, float identity) {
        return oldBiomeGroup;
    }

    public Biome apply(BiomeGroup oldBiomeGroup, Cell cell) {
        return this.apply(oldBiomeGroup, TempCategory.getFromTemperature(-0.1f, 1.0f, oldBiomeGroup.getBaseBiome().func_185353_n()), WetCategory.getFromMoisture(0.0f, 1.0f, oldBiomeGroup.getBaseBiome().func_76727_i()), cell, BiomeTransformer.getCategoryFromContinent(cell.continentValue), cell.subBiomeCellIdentity);
    }

    protected Biome apply(BiomeGroup oldBiomeGroup, TempCategory tempCategory, WetCategory wetCategory, Cell cell, MainBiomeTransformer.TerrainCategory category, float identity) {
        return oldBiomeGroup.getBaseBiome();
    }

    public BiomeGroup apply(BiomeGroup oldBiomeGroup, BiomeGroup northBiomeGroup, BiomeGroup southBiomeGroup, BiomeGroup eastBiomeGroup, BiomeGroup westBiomeGroup, Cell cell) {
        return this.apply(oldBiomeGroup, northBiomeGroup, southBiomeGroup, eastBiomeGroup, westBiomeGroup, TempCategory.getFromTemperature(-0.1f, 1.0f, oldBiomeGroup.getBaseBiome().func_185353_n()), WetCategory.getFromMoisture(0.0f, 1.0f, oldBiomeGroup.getBaseBiome().func_76727_i()), cell, BiomeTransformer.getCategoryFromContinent(cell.continentValue), cell.subBiomeCellIdentity);
    }

    protected BiomeGroup apply(BiomeGroup oldBiomeGroup, BiomeGroup northBiomeGroup, BiomeGroup southBiomeGroup, BiomeGroup eastBiomeGroup, BiomeGroup westBiomeGroup, TempCategory tempCategory, WetCategory wetCategory, Cell cell, MainBiomeTransformer.TerrainCategory category, float identity) {
        return oldBiomeGroup;
    }

    public Biome apply(Biome oldCenterBiome, Biome oldNorthBiome, Biome oldSouthBiome, Biome oldEastBiome, Biome oldWestBiome, Cell cell) {
        return this.apply(oldCenterBiome, oldNorthBiome, oldSouthBiome, oldEastBiome, oldWestBiome, TempCategory.getFromTemperature(-0.1f, 1.0f, oldCenterBiome.func_185353_n()), WetCategory.getFromMoisture(0.0f, 1.0f, oldCenterBiome.func_76727_i()), cell, BiomeTransformer.getCategoryFromContinent(cell.continentValue), cell.subBiomeCellIdentity);
    }

    protected Biome apply(Biome oldCenterBiome, Biome oldNorthBiome, Biome oldSouthBiome, Biome oldEastBiome, Biome oldWestBiome, TempCategory tempCategory, WetCategory wetCategory, Cell cell, MainBiomeTransformer.TerrainCategory category, float identity) {
        return oldCenterBiome;
    }

    public static MainBiomeTransformer.TerrainCategory getCategoryFromContinent(float cellContinent) {
        if (cellContinent >= 0.6f) {
            return MainBiomeTransformer.TerrainCategory.HIGHLANDS;
        }
        if (cellContinent >= 0.2f && cellContinent < 0.6f) {
            return MainBiomeTransformer.TerrainCategory.LOWLANDS;
        }
        if (cellContinent >= 0.15f && cellContinent < 0.2f) {
            return MainBiomeTransformer.TerrainCategory.OCEAN;
        }
        return MainBiomeTransformer.TerrainCategory.DEEP_OCEAN;
    }

    public Biome getBiome(List<Biome> filteredBiomes, float identity) {
        if (!filteredBiomes.isEmpty()) {
            Biome[] filtered = filteredBiomes.toArray(new Biome[0]);
            int index = NoiseUtil.round(identity * (float)(filtered.length - 1));
            return filtered[index];
        }
        WN.LOGGER.warn("BiomeTransformer returned empty array. That shouldn't happen!");
        return Biomes.field_76771_b;
    }

    public BiomeGroup getBiomeGroup(List<BiomeGroup> filteredBiomes, float identity) {
        if (!filteredBiomes.isEmpty()) {
            BiomeGroup[] filtered = filteredBiomes.toArray(new BiomeGroup[0]);
            int index = NoiseUtil.round(identity * (float)(filtered.length - 1));
            return filtered[index];
        }
        WN.LOGGER.warn("BiomeTransformer returned empty array. That shouldn't happen!");
        return null;
    }

    public static ArrayListMultimap<Integer, BiomeGroup> getBiomesByTemperature(List<BiomeGroup> filter, TempCategory category) {
        ArrayListMultimap multimap = ArrayListMultimap.create();
        for (BiomeGroup biomeGroup : filter) {
            TempCategory biomeCategory = TempCategory.getFromTemperature(-0.1f, 1.0f, biomeGroup.getBaseBiome().func_76727_i());
            int distance = Math.abs(Math.min(category.ordinal(), biomeCategory.ordinal()) - Math.max(category.ordinal(), biomeCategory.ordinal()));
            multimap.put((Object)distance, (Object)biomeGroup);
        }
        return multimap;
    }

    public static ArrayListMultimap<Integer, BiomeGroup> getBiomesByMoisture(List<BiomeGroup> filter, WetCategory category) {
        ArrayListMultimap multimap = ArrayListMultimap.create();
        for (BiomeGroup biomeGroup : filter) {
            WetCategory biomeCategory = WetCategory.getFromMoisture(0.0f, 1.0f, biomeGroup.getBaseBiome().func_76727_i());
            int distance = Math.abs(Math.min(category.ordinal(), biomeCategory.ordinal()) - Math.max(category.ordinal(), biomeCategory.ordinal()));
            multimap.put((Object)distance, (Object)biomeGroup);
        }
        return multimap;
    }

    public static ArrayListMultimap<Integer, BiomeGroup> getBiomesByTemperatureAndMoisture(List<BiomeGroup> filter, TempCategory tempCategory, WetCategory wetCategory) {
        ArrayListMultimap multimap = ArrayListMultimap.create();
        for (BiomeGroup biomeGroup : filter) {
            TempCategory biomeTempCategory = TempCategory.getFromTemperature(-0.1f, 1.0f, biomeGroup.getBaseBiome().func_185353_n());
            WetCategory biomeWetCategory = WetCategory.getFromMoisture(0.0f, 1.0f, biomeGroup.getBaseBiome().func_76727_i());
            int tempDistance = Math.abs(Math.min(tempCategory.ordinal(), biomeTempCategory.ordinal()) - Math.max(tempCategory.ordinal(), biomeTempCategory.ordinal()));
            int wetDistance = Math.abs(Math.min(wetCategory.ordinal(), biomeWetCategory.ordinal()) - Math.max(wetCategory.ordinal(), biomeWetCategory.ordinal()));
            multimap.put((Object)(tempDistance + wetDistance), (Object)biomeGroup);
        }
        return multimap;
    }

    public static List<BiomeGroup> getBiomesByTemperatureAndMoisture(List<BiomeGroup> filter, MainBiomeTransformer.TerrainCategory category, TempCategory tempCategory, WetCategory wetCategory) {
        ArrayListMultimap<Integer, BiomeGroup> multimap = BiomeTransformer.getBiomesByTemperatureAndMoisture(filter, tempCategory, wetCategory);
        ArrayList<BiomeGroup> groups = new ArrayList<BiomeGroup>(multimap.get((Object)0));
        if (category == MainBiomeTransformer.TerrainCategory.DEEP_OCEAN || category == MainBiomeTransformer.TerrainCategory.OCEAN) {
            ArrayList<BiomeGroup> oceans = new ArrayList<BiomeGroup>();
            if (tempCategory == TempCategory.ICY) {
                if (category == MainBiomeTransformer.TerrainCategory.OCEAN) {
                    oceans.add(WNBiomes.FROZEN_OCEAN);
                } else {
                    oceans.add(WNBiomes.DEEP_FROZEN_OCEAN);
                }
            } else if (tempCategory == TempCategory.COLD) {
                if (category == MainBiomeTransformer.TerrainCategory.OCEAN) {
                    oceans.add(WNBiomes.COLD_OCEAN);
                } else {
                    oceans.add(WNBiomes.DEEP_COLD_OCEAN);
                }
            } else if (tempCategory == TempCategory.TEMPERATE) {
                if (category == MainBiomeTransformer.TerrainCategory.OCEAN) {
                    oceans.add(WNBiomes.OCEAN);
                } else {
                    oceans.add(WNBiomes.DEEP_OCEAN);
                }
            } else if (tempCategory == TempCategory.WARM) {
                if (category == MainBiomeTransformer.TerrainCategory.OCEAN) {
                    oceans.add(WNBiomes.LUKEWARM_OCEAN);
                } else {
                    oceans.add(WNBiomes.DEEP_LUKEWARM_OCEAN);
                }
            } else if (category == MainBiomeTransformer.TerrainCategory.OCEAN) {
                oceans.add(WNBiomes.WARM_OCEAN);
            } else {
                oceans.add(WNBiomes.DEEP_WARM_OCEAN);
            }
            return oceans.isEmpty() ? groups : oceans;
        }
        int i = 0;
        while (groups.size() < Math.min(filter.size(), 5)) {
            ArrayList newGroups = new ArrayList(multimap.get((Object)(++i)));
            for (int j = 0; j < newGroups.size() && groups.size() < Math.min(filter.size(), 8); ++j) {
                groups.add((BiomeGroup)newGroups.get(j));
            }
        }
        return groups;
    }

    public static enum WetCategory {
        DRY("dry"),
        TEMPERATE("temperate"),
        WET("wet");

        private static final Map<String, WetCategory> BY_NAME;
        private final String name;

        private WetCategory(String nameIn) {
            this.name = nameIn;
        }

        public String getName() {
            return this.name;
        }

        public static WetCategory getFromMoisture(float min, float max, float moisture) {
            float scaled = Utilities.scaleBetween(moisture, -1.0f, 1.0f, min, max);
            if (scaled < -1.0f) {
                scaled = -1.0f;
            } else if (scaled > 1.0f) {
                scaled = 1.0f;
            }
            if (scaled >= -1.0f && (double)scaled < -0.35) {
                return DRY;
            }
            if ((double)scaled >= -0.35 && (double)scaled <= 0.35) {
                return TEMPERATE;
            }
            if ((double)scaled > 0.35 && scaled <= 1.0f) {
                return WET;
            }
            return TEMPERATE;
        }

        static {
            BY_NAME = Arrays.stream(WetCategory.values()).collect(Collectors.toMap(WetCategory::getName, p_222356_0_ -> p_222356_0_));
        }
    }

    public static enum TempCategory {
        ICY("icy"),
        COLD("cold"),
        TEMPERATE("temperate"),
        WARM("warm"),
        HOT("hot");

        private static final Map<String, TempCategory> BY_NAME;
        private final String name;

        private TempCategory(String nameIn) {
            this.name = nameIn;
        }

        public String getName() {
            return this.name;
        }

        public static TempCategory getFromTemperature(float min, float max, float temperature) {
            float scaled = Utilities.scaleBetween(temperature, -1.0f, 1.0f, min, max);
            if (scaled < -1.0f) {
                scaled = -1.0f;
            } else if (scaled > 1.0f) {
                scaled = 1.0f;
            }
            if (scaled >= -1.0f && (double)scaled < -0.6) {
                return ICY;
            }
            if ((double)scaled >= -0.6 && (double)scaled < -0.2) {
                return COLD;
            }
            if ((double)scaled >= -0.2 && (double)scaled <= 0.2) {
                return TEMPERATE;
            }
            if ((double)scaled > 0.2 && (double)scaled <= 0.6) {
                return WARM;
            }
            if ((double)scaled > 0.6) {
                return HOT;
            }
            return TEMPERATE;
        }

        static {
            BY_NAME = Arrays.stream(TempCategory.values()).collect(Collectors.toMap(TempCategory::getName, p_222356_0_ -> p_222356_0_));
        }
    }
}

