/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.world.generation.transformer.transformers;

import com.matez.wildnature.init.WN;
import com.matez.wildnature.util.other.Utilities;
import com.matez.wildnature.world.generation.biome.setup.grid.BiomeGroup;
import com.matez.wildnature.world.generation.biome.setup.grid.IslandBiome;
import com.matez.wildnature.world.generation.grid.Cell;
import com.matez.wildnature.world.generation.transformer.BiomeTransformer;
import com.matez.wildnature.world.generation.transformer.transformers.MainBiomeTransformer;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.world.biome.Biome;

public class IslandTransformer
extends BiomeTransformer {
    private IslandBiome.IslandType type;
    private ArrayList<IslandBiome> islandBiomes = new ArrayList();

    public IslandTransformer(IslandBiome.IslandType type) {
        this.type = type;
        for (IslandBiome islandBiome : IslandBiome.getIslandBiomes()) {
            if (islandBiome.getType() != type) continue;
            for (int i = 0; i < islandBiome.getWeight(); ++i) {
                this.islandBiomes.add(islandBiome);
            }
        }
        WN.LOGGER.debug("Added island biomes for island type " + type.name() + ": " + this.islandBiomes.toString());
    }

    @Override
    protected BiomeGroup bgApply(BiomeGroup oldBiomeGroup, BiomeTransformer.TempCategory tempCategory, BiomeTransformer.WetCategory wetCategory, Cell cell, MainBiomeTransformer.TerrainCategory category, float identity) {
        if (!this.islandBiomes.isEmpty()) {
            Random random = new Random((long)((this.type == IslandBiome.IslandType.SMALL ? cell.smallIslandCellIdentity : cell.bigIslandCellIdentity) * 1000000.0f));
            if (this.type == IslandBiome.IslandType.BIG && Utilities.rint(0, IslandBiome.RARITY_BIG, random) == 0 || this.type == IslandBiome.IslandType.SMALL && Utilities.rint(0, IslandBiome.RARITY_SMALL, random) == 0) {
                ArrayList<BiomeGroup> passingBiomeGroups = new ArrayList<BiomeGroup>();
                for (IslandBiome islandBiome : this.islandBiomes) {
                    boolean passing = false;
                    for (Biome ocean : islandBiome.getOceans()) {
                        if (oldBiomeGroup.getBaseBiome() != ocean) continue;
                        passing = true;
                        break;
                    }
                    if (!passing) continue;
                    passingBiomeGroups.add(islandBiome.getIslandBiome());
                }
                if (passingBiomeGroups.isEmpty()) {
                    return oldBiomeGroup;
                }
                return this.getBiomeGroup(passingBiomeGroups, this.type == IslandBiome.IslandType.SMALL ? cell.smallIslandCellIdentity : cell.bigIslandCellIdentity);
            }
        }
        return oldBiomeGroup;
    }
}

