/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.world.generation.transformer.transformers;

import com.matez.wildnature.init.WN;
import com.matez.wildnature.world.generation.biome.registry.WNBiomes;
import com.matez.wildnature.world.generation.biome.setup.grid.BiomeGroup;
import com.matez.wildnature.world.generation.grid.Cell;
import com.matez.wildnature.world.generation.transformer.BiomeTransformer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import net.minecraftforge.common.BiomeDictionary;

public class MainBiomeTransformer
extends BiomeTransformer {
    protected LinkedHashMap<TerrainCategory, BiomeGroup[]> weightedBiomeGroups = new LinkedHashMap();
    protected LinkedHashMap<TerrainCategory, LinkedHashMap<BiomeTransformer.TempCategory, LinkedHashMap<BiomeTransformer.WetCategory, List<BiomeGroup>>>> climaticBiomeGroups = new LinkedHashMap();

    public MainBiomeTransformer() {
        this.initWeightedBiomeGroups();
        this.initClimaticBiomeGroups();
    }

    private void initWeightedBiomeGroups() {
        WN.LOGGER.debug("Init weighted biome groups");
        for (TerrainCategory value : TerrainCategory.values()) {
            ArrayList<BiomeGroup> biomeGroups = new ArrayList<BiomeGroup>();
            for (BiomeGroup biomeGroup : this.getBiomeGroups(value)) {
                for (int i = 0; i < biomeGroup.getWeight(); ++i) {
                    biomeGroups.add(biomeGroup);
                }
            }
            WN.LOGGER.debug("--- " + value.getName() + " - " + biomeGroups.size() + " entries.");
            this.weightedBiomeGroups.put(value, biomeGroups.toArray(new BiomeGroup[0]));
        }
        WN.LOGGER.debug("Initialized terrain weighted biome groups: " + this.weightedBiomeGroups.hashCode());
    }

    private BiomeGroup[] getBiomeGroups(TerrainCategory category) {
        if (category == TerrainCategory.DEEP_OCEAN) {
            return new BiomeGroup[]{WNBiomes.DEEP_OCEAN, WNBiomes.DEEP_COLD_OCEAN, WNBiomes.DEEP_FROZEN_OCEAN, WNBiomes.DEEP_LUKEWARM_OCEAN, WNBiomes.DEEP_WARM_OCEAN};
        }
        if (category == TerrainCategory.OCEAN) {
            return new BiomeGroup[]{WNBiomes.OCEAN, WNBiomes.COLD_OCEAN, WNBiomes.FROZEN_OCEAN, WNBiomes.LUKEWARM_OCEAN, WNBiomes.WARM_OCEAN};
        }
        return BiomeGroup.guess(category, new BiomeDictionary.Type[0], new BiomeDictionary.Type[0], false);
    }

    private void initClimaticBiomeGroups() {
        WN.LOGGER.debug("Init climatic biome groups... ");
        for (TerrainCategory value : TerrainCategory.values()) {
            WN.LOGGER.debug("--- initializing " + value.getName());
            LinkedHashMap tempGroups = new LinkedHashMap();
            for (BiomeTransformer.TempCategory tempValue : BiomeTransformer.TempCategory.values()) {
                LinkedHashMap<BiomeTransformer.WetCategory, List<BiomeGroup>> wetGroups = new LinkedHashMap<BiomeTransformer.WetCategory, List<BiomeGroup>>();
                for (BiomeTransformer.WetCategory wetValue : BiomeTransformer.WetCategory.values()) {
                    List<BiomeGroup> biomeGroups = BiomeTransformer.getBiomesByTemperatureAndMoisture(Arrays.asList((Object[])this.weightedBiomeGroups.get((Object)value)), value, tempValue, wetValue);
                    wetGroups.put(wetValue, biomeGroups);
                    WN.LOGGER.debug("----- adding " + biomeGroups.size() + " biomes with temp " + tempValue.getName() + " and moist " + wetValue.getName());
                }
                tempGroups.put(tempValue, wetGroups);
            }
            this.climaticBiomeGroups.put(value, tempGroups);
        }
        WN.LOGGER.debug("Initialized terrain weighted biome groups");
    }

    public List<BiomeGroup> getClimaticBiomeGroups(TerrainCategory category, BiomeTransformer.TempCategory tempCategory, BiomeTransformer.WetCategory wetCategory) {
        return this.climaticBiomeGroups.get((Object)category).get((Object)tempCategory).get((Object)wetCategory);
    }

    @Override
    protected BiomeGroup bgApply(BiomeTransformer.TempCategory tempCategory, BiomeTransformer.WetCategory wetCategory, Cell cell, TerrainCategory category, float identity) {
        return this.getBiomeGroup(this.getClimaticBiomeGroups(category, tempCategory, wetCategory), identity);
    }

    public static enum TerrainCategory {
        DEEP_OCEAN("deep_ocean", 0),
        OCEAN("ocean", 1),
        LOWLANDS("lowlands", 2),
        HIGHLANDS("highlands", 3);

        private String name;
        private int index;

        private TerrainCategory(String name, int index) {
            this.name = name;
            this.index = index;
        }

        public String getName() {
            return this.name;
        }

        public int getIndex() {
            return this.index;
        }

        public static TerrainCategory getByIndex(int index) {
            for (TerrainCategory value : TerrainCategory.values()) {
                if (value.getIndex() != index) continue;
                return value;
            }
            return null;
        }
    }
}

