/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.world.generation.transformer.transformers;

import com.matez.wildnature.world.generation.biome.registry.WNBiomes;
import com.matez.wildnature.world.generation.biome.setup.grid.BiomeGroup;
import com.matez.wildnature.world.generation.grid.Cell;
import com.matez.wildnature.world.generation.heightmap.modules.RiverGenerator;
import com.matez.wildnature.world.generation.layer.grid.GridBiomeLayer;
import com.matez.wildnature.world.generation.transformer.BiomeTransformer;
import com.matez.wildnature.world.generation.transformer.transformers.MainBiomeTransformer;
import net.minecraft.world.biome.Biome;

public class RiverTransformer
extends BiomeTransformer {
    @Override
    protected BiomeGroup bgApply(BiomeGroup oldBiomeGroup, BiomeTransformer.TempCategory tempCategory, BiomeTransformer.WetCategory wetCategory, Cell cell, MainBiomeTransformer.TerrainCategory category, float identity) {
        if (!this.isOcean(oldBiomeGroup) && RiverGenerator.isRiver(cell)) {
            if (tempCategory == BiomeTransformer.TempCategory.WARM || tempCategory == BiomeTransformer.TempCategory.HOT) {
                if (oldBiomeGroup.getBaseBiome().func_201856_r() == Biome.Category.JUNGLE) {
                    return WNBiomes.AMAZON_RIVER;
                }
                if (oldBiomeGroup.getBaseBiome().func_201856_r() == Biome.Category.DESERT && (wetCategory == BiomeTransformer.WetCategory.DRY || wetCategory == BiomeTransformer.WetCategory.TEMPERATE)) {
                    return WNBiomes.NILE_RIVER;
                }
            }
            if (tempCategory == BiomeTransformer.TempCategory.ICY) {
                return WNBiomes.FROZEN_RIVER;
            }
            return WNBiomes.RIVER;
        }
        return oldBiomeGroup;
    }

    private boolean isOcean(BiomeGroup oldBiomeGroup) {
        for (BiomeGroup ocean : GridBiomeLayer.OCEANS) {
            if (oldBiomeGroup.getId() != ocean.getId()) continue;
            return true;
        }
        return false;
    }
}

