/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.world.generation.transformer.transformers;

import com.matez.wildnature.world.generation.biome.registry.WNBiomes;
import com.matez.wildnature.world.generation.biome.setup.grid.BiomeGroup;
import com.matez.wildnature.world.generation.biome.setup.grid.SubBiome;
import com.matez.wildnature.world.generation.grid.Cell;
import com.matez.wildnature.world.generation.heightmap.modules.RiverGenerator;
import com.matez.wildnature.world.generation.layer.grid.GridBiomeLayer;
import com.matez.wildnature.world.generation.transformer.BiomeTransformer;
import com.matez.wildnature.world.generation.transformer.transformers.MainBiomeTransformer;

public class RiverValleyTransformer
extends BiomeTransformer {
    public static BiomeGroup riverValleySharp = BiomeGroup.SingleBuilder.configure("river_valley_sharp", WNBiomes.RiverValleySharp, new SubBiome[0]);
    public static BiomeGroup riverValleySmooth = BiomeGroup.SingleBuilder.configure("river_valley_smooth", WNBiomes.RiverValleySmooth, new SubBiome[0]);

    @Override
    protected BiomeGroup bgApply(BiomeGroup oldBiomeGroup, BiomeTransformer.TempCategory tempCategory, BiomeTransformer.WetCategory wetCategory, Cell cell, MainBiomeTransformer.TerrainCategory category, float identity) {
        if (!this.isOcean(oldBiomeGroup)) {
            if (RiverGenerator.isRiverValleySmooth(cell)) {
                return riverValleySmooth;
            }
            if (RiverGenerator.isRiverValleySharp(cell)) {
                return riverValleySmooth;
            }
        }
        return oldBiomeGroup;
    }

    private boolean isOcean(BiomeGroup oldBiomeGroup) {
        for (BiomeGroup ocean : GridBiomeLayer.OCEANS) {
            if (oldBiomeGroup.getId() != ocean.getId()) continue;
            return true;
        }
        return false;
    }
}

