/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.world.generation.transformer.transformers;

import com.matez.wildnature.world.generation.biome.registry.WNBiomes;
import com.matez.wildnature.world.generation.biome.setup.grid.BiomeGroup;
import com.matez.wildnature.world.generation.grid.Cell;
import com.matez.wildnature.world.generation.transformer.BiomeTransformer;
import com.matez.wildnature.world.generation.transformer.transformers.MainBiomeTransformer;
import java.util.ArrayList;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;

public class ShoreTransformer
extends BiomeTransformer {
    private final ArrayList<BiomeGroup> OCEANS = new ArrayList();

    public ShoreTransformer() {
        this.OCEANS.add(WNBiomes.OCEAN);
        this.OCEANS.add(WNBiomes.COLD_OCEAN);
        this.OCEANS.add(WNBiomes.FROZEN_OCEAN);
        this.OCEANS.add(WNBiomes.LUKEWARM_OCEAN);
        this.OCEANS.add(WNBiomes.WARM_OCEAN);
        this.OCEANS.add(WNBiomes.DEEP_OCEAN);
        this.OCEANS.add(WNBiomes.DEEP_COLD_OCEAN);
        this.OCEANS.add(WNBiomes.DEEP_FROZEN_OCEAN);
        this.OCEANS.add(WNBiomes.DEEP_LUKEWARM_OCEAN);
        this.OCEANS.add(WNBiomes.DEEP_WARM_OCEAN);
    }

    @Override
    protected BiomeGroup apply(BiomeGroup oldBiomeGroup, BiomeGroup northBiomeGroup, BiomeGroup southBiomeGroup, BiomeGroup eastBiomeGroup, BiomeGroup westBiomeGroup, BiomeTransformer.TempCategory tempCategory, BiomeTransformer.WetCategory wetCategory, Cell cell, MainBiomeTransformer.TerrainCategory category, float identity) {
        for (BiomeGroup ocean : this.OCEANS) {
            if (northBiomeGroup.getId() != ocean.getId() && southBiomeGroup.getId() != ocean.getId() && eastBiomeGroup.getId() != ocean.getId() && westBiomeGroup.getId() != ocean.getId()) continue;
            boolean isOceanCenter = true;
            for (BiomeGroup oc2 : this.OCEANS) {
                if (oldBiomeGroup.getId() != oc2.getId()) continue;
                isOceanCenter = false;
            }
            if (!isOceanCenter) continue;
            if (oldBiomeGroup.getBaseBiome() == Biomes.field_76789_p) {
                return WNBiomes.MUSHROOM_FIELD_SHORE;
            }
            if (tempCategory == BiomeTransformer.TempCategory.ICY) {
                if (oldBiomeGroup.getBaseBiome().func_201856_r() == Biome.Category.EXTREME_HILLS) {
                    return WNBiomes.COLD_STONE_SHORE;
                }
                return WNBiomes.ICY_BEACH;
            }
            if (tempCategory == BiomeTransformer.TempCategory.COLD) {
                if (oldBiomeGroup.getBaseBiome().func_201856_r() == Biome.Category.EXTREME_HILLS) {
                    return WNBiomes.STONE_SHORE;
                }
                return WNBiomes.COLD_BEACH;
            }
            if (tempCategory == BiomeTransformer.TempCategory.TEMPERATE) {
                return WNBiomes.TEMPERATE_BEACH;
            }
            if (tempCategory != BiomeTransformer.TempCategory.WARM && tempCategory != BiomeTransformer.TempCategory.HOT) continue;
            if (oldBiomeGroup.getBaseBiome().func_201856_r() == Biome.Category.JUNGLE) {
                return WNBiomes.TROPICAL_BEACH;
            }
            return WNBiomes.WARM_BEACH;
        }
        return oldBiomeGroup;
    }
}

