/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.extension.factory;

import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.extension.factory.parser.mask.BiomeMaskParser;
import com.sk89q.worldedit.extension.factory.parser.mask.BlockCategoryMaskParser;
import com.sk89q.worldedit.extension.factory.parser.mask.BlockStateMaskParser;
import com.sk89q.worldedit.extension.factory.parser.mask.BlocksMaskParser;
import com.sk89q.worldedit.extension.factory.parser.mask.ExistingMaskParser;
import com.sk89q.worldedit.extension.factory.parser.mask.ExpressionMaskParser;
import com.sk89q.worldedit.extension.factory.parser.mask.LazyRegionMaskParser;
import com.sk89q.worldedit.extension.factory.parser.mask.NegateMaskParser;
import com.sk89q.worldedit.extension.factory.parser.mask.NoiseMaskParser;
import com.sk89q.worldedit.extension.factory.parser.mask.OffsetMaskParser;
import com.sk89q.worldedit.extension.factory.parser.mask.RegionMaskParser;
import com.sk89q.worldedit.extension.factory.parser.mask.SolidMaskParser;
import com.sk89q.worldedit.extension.input.InputParseException;
import com.sk89q.worldedit.extension.input.NoMatchException;
import com.sk89q.worldedit.extension.input.ParserContext;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.function.mask.MaskIntersection;
import com.sk89q.worldedit.internal.registry.AbstractFactory;
import com.sk89q.worldedit.internal.registry.InputParser;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public final class MaskFactory
extends AbstractFactory<Mask> {
    public MaskFactory(WorldEdit worldEdit) {
        super(worldEdit, new BlocksMaskParser(worldEdit));
        this.register(new ExistingMaskParser(worldEdit));
        this.register(new SolidMaskParser(worldEdit));
        this.register(new LazyRegionMaskParser(worldEdit));
        this.register(new RegionMaskParser(worldEdit));
        this.register(new OffsetMaskParser(worldEdit));
        this.register(new NoiseMaskParser(worldEdit));
        this.register(new BlockStateMaskParser(worldEdit));
        this.register(new NegateMaskParser(worldEdit));
        this.register(new ExpressionMaskParser(worldEdit));
        this.register(new BlockCategoryMaskParser(worldEdit));
        this.register(new BiomeMaskParser(worldEdit));
    }

    @Override
    public List<String> getSuggestions(String input) {
        String[] split = input.split(" ");
        if (split.length > 1) {
            String prev = input.substring(0, input.lastIndexOf(" ")) + " ";
            return super.getSuggestions(split[split.length - 1]).stream().map(s -> prev + s).collect(Collectors.toList());
        }
        return super.getSuggestions(input);
    }

    @Override
    public Mask parseFromInput(String input, ParserContext context) throws InputParseException {
        ArrayList<Mask> masks = new ArrayList<Mask>();
        for (String component : input.split(" ")) {
            if (component.isEmpty()) continue;
            for (InputParser parser : this.getParsers()) {
                Mask match = (Mask)parser.parseFromInput(component, context);
                if (match == null) continue;
                masks.add(match);
            }
        }
        switch (masks.size()) {
            case 0: {
                throw new NoMatchException(TranslatableComponent.of("worldedit.error.no-match", TextComponent.of(input)));
            }
            case 1: {
                return (Mask)masks.get(0);
            }
        }
        return new MaskIntersection(masks);
    }
}

