/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.extent.clipboard.io.legacycompat;

import com.sk89q.jnbt.CompoundTag;
import com.sk89q.jnbt.CompoundTagBuilder;
import com.sk89q.jnbt.IntTag;
import com.sk89q.jnbt.ListTag;
import com.sk89q.jnbt.Tag;
import com.sk89q.worldedit.extent.clipboard.io.legacycompat.NBTCompatibilityHandler;
import com.sk89q.worldedit.registry.state.DirectionalProperty;
import com.sk89q.worldedit.registry.state.IntegerProperty;
import com.sk89q.worldedit.registry.state.Property;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockType;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;

public class BannerBlockCompatibilityHandler
implements NBTCompatibilityHandler {
    private static final DirectionalProperty FacingProperty;
    private static final IntegerProperty RotationProperty;

    @Override
    public <B extends BlockStateHolder<B>> boolean isAffectedBlock(B block) {
        return block.getBlockType() == BlockTypes.WHITE_BANNER || block.getBlockType() == BlockTypes.WHITE_WALL_BANNER;
    }

    @Override
    public <B extends BlockStateHolder<B>> B updateNBT(B block, Map<String, Tag> values) {
        Tag typeTag = values.get("Base");
        if (typeTag instanceof IntTag) {
            BlockType type;
            boolean isWall = block.getBlockType() == BlockTypes.WHITE_WALL_BANNER;
            String bannerType = BannerBlockCompatibilityHandler.convertBannerType(((IntTag)typeTag).getValue(), isWall);
            if (bannerType != null && (type = BlockTypes.get("minecraft:" + bannerType)) != null) {
                BlockStateHolder<BlockState> state = type.getDefaultState();
                if (isWall) {
                    Property facingProp = type.getProperty("facing");
                    state = state.with(facingProp, (Object)block.getState(FacingProperty));
                } else {
                    Property rotationProp = type.getProperty("rotation");
                    state = state.with(rotationProp, block.getState(RotationProperty));
                }
                values.remove("Base");
                Tag patternsTag = values.get("Patterns");
                if (patternsTag instanceof ListTag) {
                    ArrayList<Tag> tempList = new ArrayList<Tag>();
                    Iterator iterator = ((ListTag)patternsTag).getValue().iterator();
                    while (iterator.hasNext()) {
                        Tag pattern = (Tag)iterator.next();
                        if (pattern instanceof CompoundTag) {
                            Object patternMap = ((CompoundTag)pattern).getValue();
                            Tag colorTag = (Tag)patternMap.get("Color");
                            CompoundTagBuilder builder = CompoundTagBuilder.create();
                            builder.putAll((Map<String, ? extends Tag>)patternMap);
                            if (colorTag instanceof IntTag) {
                                builder.putInt("Color", 15 - ((IntTag)colorTag).getValue());
                            }
                            tempList.add(builder.build());
                            continue;
                        }
                        tempList.add(pattern);
                    }
                    values.put("Patterns", new ListTag(((ListTag)patternsTag).getType(), tempList));
                }
                return (B)state;
            }
        }
        return block;
    }

    private static String convertBannerType(int oldType, boolean isWall) {
        String color;
        switch (oldType) {
            case 0: {
                color = "black";
                break;
            }
            case 1: {
                color = "red";
                break;
            }
            case 2: {
                color = "green";
                break;
            }
            case 3: {
                color = "brown";
                break;
            }
            case 4: {
                color = "blue";
                break;
            }
            case 5: {
                color = "purple";
                break;
            }
            case 6: {
                color = "cyan";
                break;
            }
            case 7: {
                color = "light_gray";
                break;
            }
            case 8: {
                color = "gray";
                break;
            }
            case 9: {
                color = "pink";
                break;
            }
            case 10: {
                color = "lime";
                break;
            }
            case 11: {
                color = "yellow";
                break;
            }
            case 12: {
                color = "light_blue";
                break;
            }
            case 13: {
                color = "magenta";
                break;
            }
            case 14: {
                color = "orange";
                break;
            }
            case 15: {
                color = "white";
                break;
            }
            default: {
                return null;
            }
        }
        return color + (isWall ? "_wall_banner" : "_banner");
    }

    static {
        IntegerProperty tempRotation;
        DirectionalProperty tempFacing;
        try {
            tempFacing = (DirectionalProperty)BlockTypes.WHITE_WALL_BANNER.getProperty("facing");
            tempRotation = (IntegerProperty)BlockTypes.WHITE_BANNER.getProperty("rotation");
        }
        catch (ClassCastException | IllegalArgumentException | NullPointerException e) {
            tempFacing = null;
            tempRotation = null;
        }
        FacingProperty = tempFacing;
        RotationProperty = tempRotation;
    }
}

