/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.extent.clipboard.io.legacycompat;

import com.sk89q.jnbt.IntTag;
import com.sk89q.jnbt.Tag;
import com.sk89q.worldedit.extent.clipboard.io.legacycompat.NBTCompatibilityHandler;
import com.sk89q.worldedit.registry.state.DirectionalProperty;
import com.sk89q.worldedit.registry.state.EnumProperty;
import com.sk89q.worldedit.registry.state.Property;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockType;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.util.Map;

public class BedBlockCompatibilityHandler
implements NBTCompatibilityHandler {
    private static final DirectionalProperty FacingProperty;
    private static final EnumProperty PartProperty;

    @Override
    public <B extends BlockStateHolder<B>> boolean isAffectedBlock(B block) {
        return block.getBlockType() == BlockTypes.RED_BED;
    }

    @Override
    public <B extends BlockStateHolder<B>> B updateNBT(B block, Map<String, Tag> values) {
        BlockType type;
        String bedType;
        Tag typeTag = values.get("color");
        if (typeTag instanceof IntTag && (bedType = this.convertBedType(((IntTag)typeTag).getValue())) != null && (type = BlockTypes.get("minecraft:" + bedType)) != null) {
            BlockStateHolder<BlockState> state = type.getDefaultState();
            Property facingProp = type.getProperty("facing");
            state = ((BlockState)state).with(facingProp, (Object)block.getState(FacingProperty));
            Property occupiedProp = type.getProperty("occupied");
            state = ((BlockState)state).with(occupiedProp, (Object)false);
            Property partProp = type.getProperty("part");
            state = ((BlockState)state).with(partProp, block.getState(PartProperty));
            values.remove("color");
            return (B)state;
        }
        return block;
    }

    private String convertBedType(int oldType) {
        String color;
        switch (oldType) {
            case 0: {
                color = "white";
                break;
            }
            case 1: {
                color = "orange";
                break;
            }
            case 2: {
                color = "magenta";
                break;
            }
            case 3: {
                color = "light_blue";
                break;
            }
            case 4: {
                color = "yellow";
                break;
            }
            case 5: {
                color = "lime";
                break;
            }
            case 6: {
                color = "pink";
                break;
            }
            case 7: {
                color = "gray";
                break;
            }
            case 8: {
                color = "light_gray";
                break;
            }
            case 9: {
                color = "cyan";
                break;
            }
            case 10: {
                color = "purple";
                break;
            }
            case 11: {
                color = "blue";
                break;
            }
            case 12: {
                color = "brown";
                break;
            }
            case 13: {
                color = "green";
                break;
            }
            case 14: {
                color = "red";
                break;
            }
            case 15: {
                color = "black";
                break;
            }
            default: {
                return null;
            }
        }
        return color + "_bed";
    }

    static {
        EnumProperty tempPart;
        DirectionalProperty tempFacing;
        try {
            tempFacing = (DirectionalProperty)BlockTypes.RED_BED.getProperty("facing");
            tempPart = (EnumProperty)BlockTypes.RED_BED.getProperty("part");
        }
        catch (ClassCastException | IllegalArgumentException | NullPointerException e) {
            tempFacing = null;
            tempPart = null;
        }
        FacingProperty = tempFacing;
        PartProperty = tempPart;
    }
}

