/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.fabric;

import com.sk89q.jnbt.CompoundTag;
import com.sk89q.util.StringUtil;
import com.sk89q.worldedit.blocks.BaseItemStack;
import com.sk89q.worldedit.entity.BaseEntity;
import com.sk89q.worldedit.extension.platform.AbstractPlayerActor;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.extent.inventory.BlockBag;
import com.sk89q.worldedit.fabric.FabricAdapter;
import com.sk89q.worldedit.fabric.FabricWorld;
import com.sk89q.worldedit.fabric.FabricWorldEdit;
import com.sk89q.worldedit.fabric.ThreadSafeCache;
import com.sk89q.worldedit.fabric.internal.ExtendedPlayerEntity;
import com.sk89q.worldedit.fabric.internal.NBTConverter;
import com.sk89q.worldedit.fabric.net.handler.WECUIPacketHandler;
import com.sk89q.worldedit.internal.cui.CUIEvent;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.math.Vector3;
import com.sk89q.worldedit.session.SessionKey;
import com.sk89q.worldedit.util.HandSide;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.util.formatting.WorldEditText;
import com.sk89q.worldedit.util.formatting.component.TextUtils;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.serializer.gson.GsonComponentSerializer;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockTypes;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.Locale;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2596;
import net.minecraft.class_2622;
import net.minecraft.class_2626;
import net.minecraft.class_2658;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5250;

public class FabricPlayer
extends AbstractPlayerActor {
    private static final int STRUCTURE_BLOCK_PACKET_ID = 7;
    private final class_3222 player;

    protected FabricPlayer(class_3222 player) {
        this.player = player;
        ThreadSafeCache.getInstance().getOnlineIds().add(this.getUniqueId());
    }

    @Override
    public UUID getUniqueId() {
        return this.player.method_5667();
    }

    @Override
    public BaseItemStack getItemInHand(HandSide handSide) {
        class_1799 is = this.player.method_5998(handSide == HandSide.MAIN_HAND ? class_1268.field_5808 : class_1268.field_5810);
        return FabricAdapter.adapt(is);
    }

    @Override
    public String getName() {
        return this.player.method_5477().method_10851();
    }

    @Override
    public BaseEntity getState() {
        throw new UnsupportedOperationException("Cannot create a state from this object");
    }

    @Override
    public Location getLocation() {
        Vector3 position = Vector3.at(this.player.method_23317(), this.player.method_23318(), this.player.method_23321());
        return new Location((Extent)FabricWorldEdit.inst.getWorld(this.player.field_6002), position, this.player.field_6031, this.player.field_5965);
    }

    @Override
    public boolean setLocation(Location location) {
        return false;
    }

    @Override
    public World getWorld() {
        return FabricWorldEdit.inst.getWorld(this.player.field_6002);
    }

    @Override
    public void giveItem(BaseItemStack itemStack) {
        this.player.field_7514.method_7394(FabricAdapter.adapt(itemStack));
    }

    @Override
    public void dispatchCUIEvent(CUIEvent event) {
        String[] params = event.getParameters();
        String send = event.getTypeId();
        if (params.length > 0) {
            send = send + "|" + StringUtil.joinString(params, "|");
        }
        class_2540 buffer = new class_2540(Unpooled.copiedBuffer((byte[])send.getBytes(WECUIPacketHandler.UTF_8_CHARSET)));
        class_2658 packet = new class_2658(new class_2960("worldedit", "cui"), buffer);
        this.player.field_13987.method_14364((class_2596)packet);
    }

    @Override
    public Locale getLocale() {
        return TextUtils.getLocaleByMinecraftTag(((ExtendedPlayerEntity)this.player).getLanguage());
    }

    @Override
    public void printRaw(String msg) {
        for (String part : msg.split("\n")) {
            this.player.method_7353((class_2561)new class_2585(part), false);
        }
    }

    @Override
    public void printDebug(String msg) {
        this.sendColorized(msg, class_124.field_1080);
    }

    @Override
    public void print(String msg) {
        this.sendColorized(msg, class_124.field_1076);
    }

    @Override
    public void printError(String msg) {
        this.sendColorized(msg, class_124.field_1061);
    }

    @Override
    public void print(Component component) {
        this.player.method_7353((class_2561)class_2561.class_2562.method_10877((String)GsonComponentSerializer.INSTANCE.serialize(WorldEditText.format(component, this.getLocale()))), false);
    }

    private void sendColorized(String msg, class_124 formatting) {
        for (String part : msg.split("\n")) {
            class_5250 component = new class_2585(part).method_27694(style -> style.method_10977(formatting));
            this.player.method_7353((class_2561)component, false);
        }
    }

    @Override
    public boolean trySetPosition(Vector3 pos, float pitch, float yaw) {
        this.player.field_13987.method_14363(pos.getX(), pos.getY(), pos.getZ(), yaw, pitch);
        return true;
    }

    @Override
    public String[] getGroups() {
        return new String[0];
    }

    @Override
    public BlockBag getInventoryBlockBag() {
        return null;
    }

    @Override
    public boolean hasPermission(String perm) {
        return FabricWorldEdit.inst.getPermissionsProvider().hasPermission(this.player, perm);
    }

    @Override
    @Nullable
    public <T> T getFacet(Class<? extends T> cls) {
        return null;
    }

    @Override
    public boolean isAllowedToFly() {
        return this.player.field_7503.field_7478;
    }

    @Override
    public void setFlying(boolean flying) {
        if (this.player.field_7503.field_7479 != flying) {
            this.player.field_7503.field_7479 = flying;
            this.player.method_7355();
        }
    }

    @Override
    public <B extends BlockStateHolder<B>> void sendFakeBlock(BlockVector3 pos, B block) {
        World world = this.getWorld();
        if (!(world instanceof FabricWorld)) {
            return;
        }
        class_2338 loc = FabricAdapter.toBlockPos(pos);
        if (block == null) {
            class_2626 packetOut = new class_2626((class_1922)((FabricWorld)world).getWorld(), loc);
            this.player.field_13987.method_14364((class_2596)packetOut);
        } else {
            BaseBlock baseBlock;
            CompoundTag nbtData;
            class_2626 packetOut = new class_2626();
            class_2540 buf = new class_2540(Unpooled.buffer());
            buf.method_10807(loc);
            buf.method_10804(class_2248.method_9507((class_2680)FabricAdapter.adapt(block.toImmutableState())));
            try {
                packetOut.method_11053(buf);
            }
            catch (IOException e) {
                return;
            }
            this.player.field_13987.method_14364((class_2596)packetOut);
            if (block instanceof BaseBlock && block.getBlockType().equals(BlockTypes.STRUCTURE_BLOCK) && (nbtData = (baseBlock = (BaseBlock)block).getNbtData()) != null) {
                this.player.field_13987.method_14364((class_2596)new class_2622(new class_2338(pos.getBlockX(), pos.getBlockY(), pos.getBlockZ()), 7, NBTConverter.toNative(nbtData)));
            }
        }
    }

    @Override
    public SessionKey getSessionKey() {
        return new SessionKeyImpl(this.player.method_5667(), this.player.method_5477().getString());
    }

    private static class SessionKeyImpl
    implements SessionKey {
        private final UUID uuid;
        private final String name;

        private SessionKeyImpl(UUID uuid, String name) {
            this.uuid = uuid;
            this.name = name;
        }

        @Override
        public UUID getUniqueId() {
            return this.uuid;
        }

        @Override
        @Nullable
        public String getName() {
            return this.name;
        }

        @Override
        public boolean isActive() {
            return ThreadSafeCache.getInstance().getOnlineIds().contains(this.uuid);
        }

        @Override
        public boolean isPersistent() {
            return true;
        }
    }
}

