/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.fabric;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Futures;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.MaxChangedBlocksException;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.blocks.BaseItem;
import com.sk89q.worldedit.blocks.BaseItemStack;
import com.sk89q.worldedit.entity.BaseEntity;
import com.sk89q.worldedit.entity.Entity;
import com.sk89q.worldedit.fabric.FabricAdapter;
import com.sk89q.worldedit.fabric.FabricEntity;
import com.sk89q.worldedit.fabric.FabricWorldEdit;
import com.sk89q.worldedit.fabric.MutableBiomeArray;
import com.sk89q.worldedit.fabric.WorldEditFakePlayer;
import com.sk89q.worldedit.fabric.WorldEditGenListener;
import com.sk89q.worldedit.fabric.internal.ExtendedMinecraftServer;
import com.sk89q.worldedit.fabric.internal.FabricWorldNativeAccess;
import com.sk89q.worldedit.fabric.internal.NBTConverter;
import com.sk89q.worldedit.fabric.mixin.AccessorLevelProperties;
import com.sk89q.worldedit.fabric.mixin.AccessorServerChunkManager;
import com.sk89q.worldedit.internal.Constants;
import com.sk89q.worldedit.internal.block.BlockStateIdAccess;
import com.sk89q.worldedit.math.BlockVector2;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.math.Vector3;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.util.Direction;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.util.SideEffect;
import com.sk89q.worldedit.util.SideEffectSet;
import com.sk89q.worldedit.util.TreeGenerator;
import com.sk89q.worldedit.world.AbstractWorld;
import com.sk89q.worldedit.world.RegenOptions;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.item.ItemTypes;
import com.sk89q.worldedit.world.weather.WeatherType;
import com.sk89q.worldedit.world.weather.WeatherTypes;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1542;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2802;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import net.minecraft.class_2975;
import net.minecraft.class_3031;
import net.minecraft.class_3037;
import net.minecraft.class_32;
import net.minecraft.class_3215;
import net.minecraft.class_3218;
import net.minecraft.class_3829;
import net.minecraft.class_3864;
import net.minecraft.class_3949;
import net.minecraft.class_3965;
import net.minecraft.class_4545;
import net.minecraft.class_4547;
import net.minecraft.class_4548;
import net.minecraft.class_5217;
import net.minecraft.class_5268;
import net.minecraft.class_5281;
import net.minecraft.class_5285;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.io.FileUtils;

public class FabricWorld
extends AbstractWorld {
    private static final Random random = new Random();
    private final WeakReference<class_1937> worldRef;
    private final FabricWorldNativeAccess worldNativeAccess;
    private static final LoadingCache<class_3218, WorldEditFakePlayer> fakePlayers = CacheBuilder.newBuilder().weakKeys().softValues().build(CacheLoader.from(WorldEditFakePlayer::new));

    FabricWorld(class_1937 world) {
        Preconditions.checkNotNull((Object)world);
        this.worldRef = new WeakReference<class_1937>(world);
        this.worldNativeAccess = new FabricWorldNativeAccess(this.worldRef);
    }

    public class_1937 getWorld() {
        class_1937 world = (class_1937)this.worldRef.get();
        if (world != null) {
            return world;
        }
        throw new RuntimeException("The reference to the world was lost (i.e. the world may have been unloaded)");
    }

    @Override
    public String getName() {
        class_5217 levelProperties = this.getWorld().method_8401();
        return ((class_5268)levelProperties).method_150();
    }

    @Override
    public String getId() {
        return this.getName() + "_" + this.getWorld().method_29287().method_29177();
    }

    @Override
    public Path getStoragePath() {
        class_1937 world = this.getWorld();
        MinecraftServer server = world.method_8503();
        Preconditions.checkState((boolean)(server instanceof ExtendedMinecraftServer), (Object)"Need a server world");
        return ((ExtendedMinecraftServer)server).getStoragePath(world);
    }

    @Override
    public <B extends BlockStateHolder<B>> boolean setBlock(BlockVector3 position, B block, SideEffectSet sideEffects) throws WorldEditException {
        return this.worldNativeAccess.setBlock(position, block, sideEffects);
    }

    @Override
    public Set<SideEffect> applySideEffects(BlockVector3 position, BlockState previousType, SideEffectSet sideEffectSet) {
        this.worldNativeAccess.applySideEffects(position, previousType, sideEffectSet);
        return Sets.intersection(FabricWorldEdit.inst.getPlatform().getSupportedSideEffects(), sideEffectSet.getSideEffectsToApply());
    }

    @Override
    public int getBlockLightLevel(BlockVector3 position) {
        Preconditions.checkNotNull((Object)position);
        return this.getWorld().method_22339(FabricAdapter.toBlockPos(position));
    }

    @Override
    public boolean clearContainerBlockContents(BlockVector3 position) {
        Preconditions.checkNotNull((Object)position);
        class_2586 tile = this.getWorld().method_8321(FabricAdapter.toBlockPos(position));
        if (tile instanceof class_3829) {
            ((class_3829)tile).method_5448();
            return true;
        }
        return false;
    }

    @Override
    public boolean fullySupports3DBiomes() {
        class_4545 biomeAccessType = this.getWorld().method_8597().method_22415();
        return !(biomeAccessType instanceof class_4547);
    }

    @Override
    public BiomeType getBiome(BlockVector3 position) {
        Preconditions.checkNotNull((Object)position);
        class_2818 chunk = this.getWorld().method_8497(position.getX() >> 4, position.getZ() >> 4);
        return this.getBiomeInChunk(position, (class_2791)chunk);
    }

    private BiomeType getBiomeInChunk(BlockVector3 position, class_2791 chunk) {
        class_4548 biomeArray = (class_4548)Preconditions.checkNotNull((Object)chunk.method_12036());
        return FabricAdapter.adapt(biomeArray.method_16359(position.getX() >> 2, position.getY() >> 2, position.getZ() >> 2));
    }

    @Override
    public boolean setBiome(BlockVector3 position, BiomeType biome) {
        Preconditions.checkNotNull((Object)position);
        Preconditions.checkNotNull((Object)biome);
        class_2818 chunk = this.getWorld().method_8497(position.getBlockX() >> 4, position.getBlockZ() >> 4);
        MutableBiomeArray biomeArray = MutableBiomeArray.inject((class_4548)Preconditions.checkNotNull((Object)chunk.method_12036()));
        biomeArray.setBiome(position.getX(), position.getY(), position.getZ(), FabricAdapter.adapt(biome));
        chunk.method_12008(true);
        return true;
    }

    @Override
    public boolean useItem(BlockVector3 position, BaseItem item, Direction face) {
        WorldEditFakePlayer fakePlayer;
        class_1799 stack = FabricAdapter.adapt(new BaseItemStack(item.getType(), item.getNbtData(), 1));
        class_3218 world = (class_3218)this.getWorld();
        try {
            fakePlayer = (WorldEditFakePlayer)((Object)fakePlayers.get((Object)world));
        }
        catch (ExecutionException ignored) {
            return false;
        }
        fakePlayer.method_6122(class_1268.field_5808, stack);
        fakePlayer.method_5641(position.getBlockX(), position.getBlockY(), position.getBlockZ(), (float)face.toVector().toYaw(), (float)face.toVector().toPitch());
        class_2338 blockPos = FabricAdapter.toBlockPos(position);
        class_3965 rayTraceResult = new class_3965(FabricAdapter.toVec3(position), FabricAdapter.adapt(face), blockPos, false);
        class_1838 itemUseContext = new class_1838((class_1657)fakePlayer, class_1268.field_5808, rayTraceResult);
        class_1269 used = stack.method_7981(itemUseContext);
        if (used != class_1269.field_5812) {
            used = this.getWorld().method_8320(blockPos).method_26174((class_1937)world, (class_1657)fakePlayer, class_1268.field_5808, rayTraceResult);
        }
        if (used != class_1269.field_5812) {
            used = stack.method_7913((class_1937)world, (class_1657)fakePlayer, class_1268.field_5808).method_5467();
        }
        return used == class_1269.field_5812;
    }

    @Override
    public void dropItem(Vector3 position, BaseItemStack item) {
        Preconditions.checkNotNull((Object)position);
        Preconditions.checkNotNull((Object)item);
        if (item.getType() == ItemTypes.AIR) {
            return;
        }
        class_1542 entity = new class_1542(this.getWorld(), position.getX(), position.getY(), position.getZ(), FabricAdapter.adapt(item));
        entity.method_6982(10);
        this.getWorld().method_8649((class_1297)entity);
    }

    @Override
    public void simulateBlockMine(BlockVector3 position) {
        class_2338 pos = FabricAdapter.toBlockPos(position);
        this.getWorld().method_22352(pos, true);
    }

    @Override
    public boolean regenerate(Region region, EditSession editSession, RegenOptions options) {
        class_2802 provider = this.getWorld().method_8398();
        if (!(provider instanceof class_3215)) {
            return false;
        }
        try {
            this.doRegen(region, editSession, options);
        }
        catch (Exception e) {
            throw new IllegalStateException("Regen failed", e);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRegen(Region region, EditSession editSession, RegenOptions options) throws Exception {
        Path tempDir = Files.createTempDirectory("WorldEditWorldGen", new FileAttribute[0]);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                FileUtils.deleteDirectory((File)tempDir.toFile());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }));
        class_32 levelStorage = class_32.method_26999((Path)tempDir);
        try (class_32.class_5143 session = levelStorage.method_27002("WorldEditTempGen");){
            class_3218 originalWorld = (class_3218)this.getWorld();
            long seed = options.getSeed().orElse(originalWorld.method_8412());
            AccessorLevelProperties levelProperties = (AccessorLevelProperties)originalWorld.method_8503().method_27728();
            class_5285 originalOpts = levelProperties.method_28057();
            class_5285 newOpts = (class_5285)class_5285.field_24826.encodeStart((DynamicOps)class_2509.field_11560, (Object)originalOpts).flatMap(tag -> class_5285.field_24826.parse(this.recursivelySetSeed((Dynamic<class_2520>)new Dynamic((DynamicOps)class_2509.field_11560, tag), seed, new HashSet<Dynamic<class_2520>>()))).result().orElseThrow(() -> new IllegalStateException("Unable to map GeneratorOptions"));
            levelProperties.setGeneratorOptions(newOpts);
            class_5321 worldRegKey = originalWorld.method_27983();
            class_5363 dimGenOpts = (class_5363)newOpts.method_28609().method_10223(worldRegKey.method_29177());
            Preconditions.checkNotNull((Object)dimGenOpts, (String)"No DimensionOptions for %s", (Object)worldRegKey);
            try (class_3218 serverWorld = new class_3218(originalWorld.method_8503(), class_156.method_18349(), session, (class_5268)originalWorld.method_8401(), worldRegKey, originalWorld.method_29287(), originalWorld.method_8597(), (class_3949)new WorldEditGenListener(), dimGenOpts.method_29571(), originalWorld.method_27982(), seed, (List)ImmutableList.of(), false);){
                this.regenForWorld(region, editSession, serverWorld, options);
                while (originalWorld.method_8503().method_16075()) {
                    Thread.yield();
                }
            }
            finally {
                levelProperties.setGeneratorOptions(originalOpts);
            }
        }
        finally {
            FileUtils.deleteDirectory((File)tempDir.toFile());
        }
    }

    private Dynamic<class_2520> recursivelySetSeed(Dynamic<class_2520> dynamic, long seed, Set<Dynamic<class_2520>> seen) {
        if (!seen.add(dynamic)) {
            return dynamic;
        }
        return dynamic.updateMapValues(pair -> {
            if (((Dynamic)pair.getFirst()).asString("").equals("seed")) {
                return pair.mapSecond(v -> v.createLong(seed));
            }
            if (((Dynamic)pair.getSecond()).getValue() instanceof class_2487) {
                return pair.mapSecond(v -> this.recursivelySetSeed((Dynamic<class_2520>)v, seed, seen));
            }
            return pair;
        });
    }

    private void regenForWorld(Region region, EditSession editSession, class_3218 serverWorld, RegenOptions options) throws MaxChangedBlocksException {
        List<CompletableFuture<class_2791>> chunkLoadings = this.submitChunkLoadTasks(region, serverWorld);
        ((AccessorServerChunkManager)serverWorld.method_14178()).getMainThreadExecutor().method_18857(() -> {
            if (chunkLoadings.stream().anyMatch(ftr -> ftr.isDone() && Futures.getUnchecked((Future)ftr) == null)) {
                return false;
            }
            return chunkLoadings.stream().allMatch(CompletableFuture::isDone);
        });
        HashMap<class_1923, class_2791> chunks = new HashMap<class_1923, class_2791>();
        for (CompletableFuture<class_2791> future : chunkLoadings) {
            class_2791 chunk = future.getNow(null);
            Preconditions.checkState((chunk != null ? 1 : 0) != 0, (Object)"Failed to generate a chunk, regen failed.");
            chunks.put(chunk.method_12004(), chunk);
        }
        for (BlockVector3 vec : region) {
            class_2338 pos = FabricAdapter.toBlockPos(vec);
            class_2791 chunk = (class_2791)chunks.get(new class_1923(pos));
            BlockStateHolder<BlockState> state = FabricAdapter.adapt(chunk.method_8320(pos));
            class_2586 blockEntity = chunk.method_8321(pos);
            if (blockEntity != null) {
                class_2487 tag = new class_2487();
                blockEntity.method_11007(tag);
                state = state.toBaseBlock(NBTConverter.fromNative(tag));
            }
            editSession.setBlock(vec, state);
            if (!options.shouldRegenBiomes()) continue;
            if (!editSession.fullySupports3DBiomes()) {
                vec = vec.withY(0);
            }
            editSession.setBiome(vec, this.getBiomeInChunk(vec, chunk));
        }
    }

    private List<CompletableFuture<class_2791>> submitChunkLoadTasks(Region region, class_3218 world) {
        AccessorServerChunkManager chunkManager = (AccessorServerChunkManager)world.method_14178();
        ArrayList<CompletableFuture<class_2791>> chunkLoadings = new ArrayList<CompletableFuture<class_2791>>();
        for (BlockVector2 chunk : region.getChunks()) {
            chunkLoadings.add((CompletableFuture<class_2791>)chunkManager.callGetChunkFuture(chunk.getX(), chunk.getZ(), class_2806.field_12795, true).thenApply(either -> either.left().orElse(null)));
        }
        return chunkLoadings;
    }

    @Nullable
    private static class_2975<?, ?> createTreeFeatureGenerator(TreeGenerator.TreeType type) {
        switch (type) {
            case TREE: {
                return class_3031.field_24134.method_23397((class_3037)class_3864.field_21126);
            }
            case BIG_TREE: {
                return class_3031.field_24134.method_23397((class_3037)class_3864.field_21190);
            }
            case REDWOOD: {
                return class_3031.field_24134.method_23397((class_3037)class_3864.field_21185);
            }
            case TALL_REDWOOD: {
                return class_3031.field_24134.method_23397((class_3037)class_3864.field_21198);
            }
            case MEGA_REDWOOD: {
                return class_3031.field_24134.method_23397((class_3037)class_3864.field_21199);
            }
            case BIRCH: {
                return class_3031.field_24134.method_23397((class_3037)class_3864.field_21187);
            }
            case JUNGLE: {
                return class_3031.field_24134.method_23397((class_3037)class_3864.field_21200);
            }
            case SMALL_JUNGLE: {
                return class_3031.field_24134.method_23397((class_3037)class_3864.field_21167);
            }
            case SHORT_JUNGLE: {
                return class_3031.field_24134.method_23397((class_3037)class_3864.field_21183);
            }
            case JUNGLE_BUSH: {
                return class_3031.field_24134.method_23397((class_3037)class_3864.field_21196);
            }
            case SWAMP: {
                return class_3031.field_24134.method_23397((class_3037)class_3864.field_21189);
            }
            case ACACIA: {
                return class_3031.field_24134.method_23397((class_3037)class_3864.field_21186);
            }
            case DARK_OAK: {
                return class_3031.field_24134.method_23397((class_3037)class_3864.field_21197);
            }
            case TALL_BIRCH: {
                return class_3031.field_24134.method_23397((class_3037)class_3864.field_21188);
            }
            case RED_MUSHROOM: {
                return class_3031.field_13571.method_23397((class_3037)class_3864.field_21142);
            }
            case BROWN_MUSHROOM: {
                return class_3031.field_13531.method_23397((class_3037)class_3864.field_21143);
            }
            case RANDOM: {
                return FabricWorld.createTreeFeatureGenerator(TreeGenerator.TreeType.values()[ThreadLocalRandom.current().nextInt(TreeGenerator.TreeType.values().length)]);
            }
        }
        return null;
    }

    @Override
    public boolean generateTree(TreeGenerator.TreeType type, EditSession editSession, BlockVector3 position) {
        class_2975<?, ?> generator = FabricWorld.createTreeFeatureGenerator(type);
        class_3218 world = (class_3218)this.getWorld();
        class_3215 chunkManager = world.method_14178();
        return generator != null && generator.method_12862((class_5281)world, world.method_27056(), chunkManager.method_12129(), random, FabricAdapter.toBlockPos(position));
    }

    @Override
    public void checkLoadedChunk(BlockVector3 pt) {
        this.getWorld().method_22350(FabricAdapter.toBlockPos(pt));
    }

    @Override
    public void fixAfterFastMode(Iterable<BlockVector2> chunks) {
        this.fixLighting(chunks);
    }

    @Override
    public void fixLighting(Iterable<BlockVector2> chunks) {
        class_1937 world = this.getWorld();
        for (BlockVector2 chunk : chunks) {
            world.method_8398().method_12130().method_15557(new class_1923(chunk.getBlockX(), chunk.getBlockZ()), true);
        }
    }

    @Override
    public boolean playEffect(Vector3 position, int type, int data) {
        return true;
    }

    @Override
    public WeatherType getWeather() {
        class_5217 info = this.getWorld().method_8401();
        if (info.method_203()) {
            return WeatherTypes.THUNDER_STORM;
        }
        if (info.method_156()) {
            return WeatherTypes.RAIN;
        }
        return WeatherTypes.CLEAR;
    }

    @Override
    public long getRemainingWeatherDuration() {
        class_5268 info = (class_5268)this.getWorld().method_8401();
        if (info.method_203()) {
            return info.method_145();
        }
        if (info.method_156()) {
            return info.method_190();
        }
        return info.method_155();
    }

    @Override
    public void setWeather(WeatherType weatherType) {
        this.setWeather(weatherType, 0L);
    }

    @Override
    public void setWeather(WeatherType weatherType, long duration) {
        class_5268 info = (class_5268)this.getWorld().method_8401();
        if (weatherType == WeatherTypes.THUNDER_STORM) {
            info.method_167(0);
            info.method_147(true);
            info.method_173((int)duration);
        } else if (weatherType == WeatherTypes.RAIN) {
            info.method_167(0);
            info.method_157(true);
            info.method_164((int)duration);
        } else if (weatherType == WeatherTypes.CLEAR) {
            info.method_157(false);
            info.method_147(false);
            info.method_167((int)duration);
        }
    }

    @Override
    public int getMaxY() {
        return this.getWorld().method_8322() - 1;
    }

    @Override
    public BlockVector3 getSpawnPosition() {
        class_5217 worldProps = this.getWorld().method_8401();
        return BlockVector3.at(worldProps.method_215(), worldProps.method_144(), worldProps.method_166());
    }

    @Override
    public BlockState getBlock(BlockVector3 position) {
        class_2680 mcState = this.getWorld().method_8497(position.getBlockX() >> 4, position.getBlockZ() >> 4).method_8320(FabricAdapter.toBlockPos(position));
        BlockState matchingBlock = BlockStateIdAccess.getBlockStateById(class_2248.method_9507((class_2680)mcState));
        if (matchingBlock != null) {
            return matchingBlock;
        }
        return FabricAdapter.adapt(mcState);
    }

    @Override
    public BaseBlock getFullBlock(BlockVector3 position) {
        class_2338 pos = new class_2338(position.getBlockX(), position.getBlockY(), position.getBlockZ());
        class_2586 tile = ((class_2818)this.getWorld().method_22350(pos)).method_12201(pos, class_2818.class_2819.field_12859);
        if (tile != null) {
            class_2487 tag = new class_2487();
            tile.method_11007(tag);
            return this.getBlock(position).toBaseBlock(NBTConverter.fromNative(tag));
        }
        return this.getBlock(position).toBaseBlock();
    }

    @Override
    public int hashCode() {
        return this.getWorld().hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof FabricWorld) {
            FabricWorld other = (FabricWorld)o;
            class_1937 otherWorld = (class_1937)other.worldRef.get();
            class_1937 thisWorld = (class_1937)this.worldRef.get();
            return otherWorld != null && otherWorld.equals(thisWorld);
        }
        if (o instanceof World) {
            return ((World)o).getName().equals(this.getName());
        }
        return false;
    }

    @Override
    public List<? extends Entity> getEntities(Region region) {
        class_1937 world = this.getWorld();
        if (!(world instanceof class_3218)) {
            return Collections.emptyList();
        }
        return ((class_3218)world).method_18198(null, entity -> true).stream().filter(e -> region.contains(FabricAdapter.adapt(e.method_24515()))).map(FabricEntity::new).collect(Collectors.toList());
    }

    @Override
    public List<? extends Entity> getEntities() {
        class_1937 world = this.getWorld();
        if (!(world instanceof class_3218)) {
            return Collections.emptyList();
        }
        return ((class_3218)world).method_18198(null, entity -> true).stream().map(FabricEntity::new).collect(Collectors.toList());
    }

    @Override
    @Nullable
    public Entity createEntity(Location location, BaseEntity entity) {
        class_1937 world = this.getWorld();
        Optional entityType = class_1299.method_5898((String)entity.getType().getId());
        if (!entityType.isPresent()) {
            return null;
        }
        class_1297 createdEntity = ((class_1299)entityType.get()).method_5883(world);
        if (createdEntity != null) {
            CompoundTag nativeTag = entity.getNbtData();
            if (nativeTag != null) {
                class_2487 tag = NBTConverter.toNative(entity.getNbtData());
                for (String name : Constants.NO_COPY_ENTITY_NBT_FIELDS) {
                    tag.method_10551(name);
                }
                createdEntity.method_5651(tag);
            }
            createdEntity.method_5641(location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
            world.method_8649(createdEntity);
            return new FabricEntity(createdEntity);
        }
        return null;
    }
}

