/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.regions.selector;

import com.google.common.base.Preconditions;
import com.sk89q.worldedit.IncompleteRegionException;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.internal.cui.CUIRegion;
import com.sk89q.worldedit.internal.cui.SelectionCylinderEvent;
import com.sk89q.worldedit.internal.cui.SelectionMinMaxEvent;
import com.sk89q.worldedit.internal.cui.SelectionPointEvent;
import com.sk89q.worldedit.math.BlockVector2;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.math.Vector2;
import com.sk89q.worldedit.math.Vector3;
import com.sk89q.worldedit.regions.CylinderRegion;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.regions.RegionSelector;
import com.sk89q.worldedit.regions.selector.limit.SelectorLimits;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import com.sk89q.worldedit.world.World;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class CylinderRegionSelector
implements RegionSelector,
CUIRegion {
    protected static final transient NumberFormat NUMBER_FORMAT = (NumberFormat)NumberFormat.getInstance().clone();
    protected transient CylinderRegion region;

    public CylinderRegionSelector() {
        this((World)null);
    }

    public CylinderRegionSelector(@Nullable World world) {
        this.region = new CylinderRegion(world);
    }

    public CylinderRegionSelector(RegionSelector oldSelector) {
        this(((RegionSelector)Preconditions.checkNotNull((Object)oldSelector)).getIncompleteRegion().getWorld());
        if (oldSelector instanceof CylinderRegionSelector) {
            CylinderRegionSelector cylSelector = (CylinderRegionSelector)oldSelector;
            this.region = new CylinderRegion(cylSelector.region);
        } else {
            Region oldRegion;
            try {
                oldRegion = oldSelector.getRegion();
            }
            catch (IncompleteRegionException e) {
                return;
            }
            BlockVector3 pos1 = oldRegion.getMinimumPoint();
            BlockVector3 pos2 = oldRegion.getMaximumPoint();
            BlockVector3 center = pos1.add(pos2).divide(2).floor();
            this.region.setCenter(center.toBlockVector2());
            this.region.setRadius(pos2.toBlockVector2().subtract(center.toBlockVector2()).toVector2());
            this.region.setMaximumY(Math.max(pos1.getBlockY(), pos2.getBlockY()));
            this.region.setMinimumY(Math.min(pos1.getBlockY(), pos2.getBlockY()));
        }
    }

    public CylinderRegionSelector(@Nullable World world, BlockVector2 center, Vector2 radius, int minY, int maxY) {
        this(world);
        this.region.setCenter(center);
        this.region.setRadius(radius);
        this.region.setMinimumY(Math.min(minY, maxY));
        this.region.setMaximumY(Math.max(minY, maxY));
    }

    @Override
    @Nullable
    public World getWorld() {
        return this.region.getWorld();
    }

    @Override
    public void setWorld(@Nullable World world) {
        this.region.setWorld(world);
    }

    @Override
    public boolean selectPrimary(BlockVector3 position, SelectorLimits limits) {
        if (!this.region.getCenter().equals(Vector3.ZERO) && position.equals(this.region.getCenter().toBlockPoint())) {
            return false;
        }
        this.region = new CylinderRegion(this.region.getWorld());
        this.region.setCenter(position.toBlockVector2());
        this.region.setY(position.getBlockY());
        return true;
    }

    @Override
    public boolean selectSecondary(BlockVector3 position, SelectorLimits limits) {
        Vector3 center = this.region.getCenter();
        if (center.equals(Vector3.ZERO)) {
            return true;
        }
        Vector2 diff = position.toVector3().subtract(center).toVector2();
        Vector2 minRadius = diff.getMaximum(diff.multiply(-1.0));
        this.region.extendRadius(minRadius);
        this.region.setY(position.getBlockY());
        return true;
    }

    @Override
    public void explainPrimarySelection(Actor player, LocalSession session, BlockVector3 pos) {
        player.printInfo(TranslatableComponent.of("worldedit.selection.cylinder.explain.primary", TextComponent.of(pos.toString())));
        session.describeCUI(player);
    }

    @Override
    public void explainSecondarySelection(Actor player, LocalSession session, BlockVector3 pos) {
        Vector3 center = this.region.getCenter();
        if (center.equals(Vector3.ZERO)) {
            player.printError(TranslatableComponent.of("worldedit.selection.cylinder.explain.secondary-missing"));
            return;
        }
        player.printInfo(TranslatableComponent.of("worldedit.selection.cylinder.explain.secondary", TextComponent.of(NUMBER_FORMAT.format(this.region.getRadius().getX())), TextComponent.of(NUMBER_FORMAT.format(this.region.getRadius().getZ())), TextComponent.of(this.region.getVolume())));
        session.describeCUI(player);
    }

    @Override
    public void explainRegionAdjust(Actor player, LocalSession session) {
        session.describeCUI(player);
    }

    @Override
    public BlockVector3 getPrimaryPosition() throws IncompleteRegionException {
        if (!this.isDefined()) {
            throw new IncompleteRegionException();
        }
        return this.region.getCenter().toBlockPoint();
    }

    @Override
    public CylinderRegion getRegion() throws IncompleteRegionException {
        if (!this.isDefined()) {
            throw new IncompleteRegionException();
        }
        return this.region;
    }

    @Override
    public CylinderRegion getIncompleteRegion() {
        return this.region;
    }

    @Override
    public boolean isDefined() {
        return !this.region.getRadius().equals(Vector2.ZERO);
    }

    @Override
    public void learnChanges() {
    }

    @Override
    public void clear() {
        this.region = new CylinderRegion(this.region.getWorld());
    }

    @Override
    public String getTypeName() {
        return "Cylinder";
    }

    @Override
    public List<Component> getSelectionInfoLines() {
        ArrayList<Component> lines = new ArrayList<Component>();
        if (!this.region.getCenter().equals(Vector3.ZERO)) {
            lines.add(TranslatableComponent.of("worldedit.selection.cylinder.info.center", TextComponent.of(this.region.getCenter().toString())));
        }
        if (!this.region.getRadius().equals(Vector2.ZERO)) {
            lines.add(TranslatableComponent.of("worldedit.selection.cylinder.info.radius", TextComponent.of(this.region.getRadius().toString())));
        }
        return lines;
    }

    @Override
    public long getVolume() {
        return this.region.getVolume();
    }

    @Override
    public void describeCUI(LocalSession session, Actor player) {
        session.dispatchCUIEvent(player, new SelectionCylinderEvent(this.region.getCenter().toBlockPoint(), this.region.getRadius()));
        session.dispatchCUIEvent(player, new SelectionMinMaxEvent(this.region.getMinimumY(), this.region.getMaximumY()));
    }

    @Override
    public void describeLegacyCUI(LocalSession session, Actor player) {
        if (this.isDefined()) {
            session.dispatchCUIEvent(player, new SelectionPointEvent(0, this.region.getMinimumPoint(), this.getVolume()));
            session.dispatchCUIEvent(player, new SelectionPointEvent(1, this.region.getMaximumPoint(), this.getVolume()));
        }
    }

    @Override
    public int getProtocolVersion() {
        return 1;
    }

    @Override
    public String getTypeID() {
        return "cylinder";
    }

    @Override
    public String getLegacyTypeID() {
        return "cuboid";
    }

    static {
        NUMBER_FORMAT.setMaximumFractionDigits(3);
    }
}

