/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.util.formatting.component;

import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.util.SideEffect;
import com.sk89q.worldedit.util.SideEffectSet;
import com.sk89q.worldedit.util.formatting.component.PaginationBox;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import com.sk89q.worldedit.util.formatting.text.event.ClickEvent;
import com.sk89q.worldedit.util.formatting.text.event.HoverEvent;
import com.sk89q.worldedit.util.formatting.text.format.TextColor;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;

public class SideEffectBox
extends PaginationBox {
    private static List<SideEffect> sideEffects;
    private SideEffectSet sideEffectSet;
    private static final SideEffect.State[] SHOWN_VALUES;

    private static List<SideEffect> getSideEffects() {
        if (sideEffects == null) {
            sideEffects = WorldEdit.getInstance().getPlatformManager().getSupportedSideEffects().stream().sorted(Comparator.comparing(Enum::name)).collect(Collectors.toList());
        }
        return sideEffects;
    }

    public SideEffectBox(SideEffectSet sideEffectSet) {
        super("Side Effects");
        this.sideEffectSet = sideEffectSet;
    }

    @Override
    public Component getComponent(int number) {
        SideEffect effect = SideEffectBox.getSideEffects().get(number);
        SideEffect.State state = this.sideEffectSet.getState(effect);
        TextComponent.Builder builder = TextComponent.builder();
        builder = (TextComponent.Builder)builder.append(TranslatableComponent.of(effect.getDisplayName(), TextColor.YELLOW).hoverEvent(HoverEvent.of(HoverEvent.Action.SHOW_TEXT, TranslatableComponent.of(effect.getDescription()))));
        for (SideEffect.State uiState : SHOWN_VALUES) {
            builder = (TextComponent.Builder)builder.append((Component)TextComponent.space());
            builder = (TextComponent.Builder)builder.append(((TranslatableComponent)TranslatableComponent.of(uiState.getDisplayName(), uiState == state ? TextColor.WHITE : TextColor.GRAY).clickEvent(ClickEvent.runCommand("//perf -h " + effect.name().toLowerCase(Locale.US) + " " + uiState.name().toLowerCase(Locale.US)))).hoverEvent(HoverEvent.showText(uiState == state ? TranslatableComponent.of("worldedit.sideeffect.box.current") : TranslatableComponent.of("worldedit.sideeffect.box.change-to", TranslatableComponent.of(uiState.getDisplayName())))));
        }
        return builder.build();
    }

    @Override
    public int getComponentsSize() {
        return SideEffectBox.getSideEffects().size();
    }

    static {
        SHOWN_VALUES = new SideEffect.State[]{SideEffect.State.OFF, SideEffect.State.ON};
    }
}

