/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.world.chunk;

import com.sk89q.jnbt.ByteTag;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.jnbt.IntTag;
import com.sk89q.jnbt.ListTag;
import com.sk89q.jnbt.LongArrayTag;
import com.sk89q.jnbt.NBTUtils;
import com.sk89q.jnbt.Tag;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.registry.state.Property;
import com.sk89q.worldedit.world.DataException;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockType;
import com.sk89q.worldedit.world.block.BlockTypes;
import com.sk89q.worldedit.world.chunk.Chunk;
import com.sk89q.worldedit.world.storage.InvalidFormatException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class AnvilChunk13
implements Chunk {
    private CompoundTag rootTag;
    private BlockState[][] blocks;
    private int rootX;
    private int rootZ;
    private Map<BlockVector3, Map<String, Tag>> tileEntities;

    public AnvilChunk13(CompoundTag tag) throws DataException {
        this.rootTag = tag;
        this.rootX = NBTUtils.getChildTag((Map<String, Tag>)this.rootTag.getValue(), "xPos", IntTag.class).getValue();
        this.rootZ = NBTUtils.getChildTag((Map<String, Tag>)this.rootTag.getValue(), "zPos", IntTag.class).getValue();
        this.blocks = new BlockState[16][];
        Object sections = NBTUtils.getChildTag((Map<String, Tag>)this.rootTag.getValue(), "Sections", ListTag.class).getValue();
        Iterator iterator = sections.iterator();
        while (iterator.hasNext()) {
            List<CompoundTag> paletteEntries;
            int paletteSize;
            byte y;
            CompoundTag sectionTag;
            Tag rawSectionTag = (Tag)iterator.next();
            if (!(rawSectionTag instanceof CompoundTag) || !(sectionTag = (CompoundTag)rawSectionTag).getValue().containsKey("Y") || (y = NBTUtils.getChildTag((Map<String, Tag>)sectionTag.getValue(), "Y", ByteTag.class).getValue().byteValue()) < 0 || y >= 16 || (paletteSize = (paletteEntries = sectionTag.getList("Palette", CompoundTag.class)).size()) == 0) continue;
            BlockState[] palette = new BlockState[paletteSize];
            for (int paletteEntryId = 0; paletteEntryId < paletteSize; ++paletteEntryId) {
                CompoundTag paletteEntry = paletteEntries.get(paletteEntryId);
                BlockType type = BlockTypes.get(paletteEntry.getString("Name"));
                if (type == null) {
                    throw new InvalidFormatException("Invalid block type: " + paletteEntry.getString("Name"));
                }
                BlockState blockState = type.getDefaultState();
                if (paletteEntry.containsKey("Properties")) {
                    CompoundTag properties = NBTUtils.getChildTag((Map<String, Tag>)paletteEntry.getValue(), "Properties", CompoundTag.class);
                    for (Property<?> property : blockState.getStates().keySet()) {
                        if (!properties.containsKey(property.getName())) continue;
                        String value = properties.getString(property.getName());
                        try {
                            blockState = this.getBlockStateWith(blockState, property, value);
                        }
                        catch (IllegalArgumentException e) {
                            throw new InvalidFormatException("Invalid block state for " + blockState.getBlockType().getId() + ", " + property.getName() + ": " + value);
                        }
                    }
                }
                palette[paletteEntryId] = blockState;
            }
            long[] blockStatesSerialized = NBTUtils.getChildTag((Map<String, Tag>)sectionTag.getValue(), "BlockStates", LongArrayTag.class).getValue();
            BlockState[] chunkSectionBlocks = new BlockState[4096];
            this.blocks[y] = chunkSectionBlocks;
            this.readBlockStates(palette, blockStatesSerialized, chunkSectionBlocks);
        }
    }

    protected void readBlockStates(BlockState[] palette, long[] blockStatesSerialized, BlockState[] chunkSectionBlocks) throws InvalidFormatException {
        int paletteBits = 4;
        while (1 << paletteBits < palette.length) {
            ++paletteBits;
        }
        int paletteMask = (1 << paletteBits) - 1;
        long currentSerializedValue = 0L;
        int nextSerializedItem = 0;
        int remainingBits = 0;
        for (int blockPos = 0; blockPos < chunkSectionBlocks.length; ++blockPos) {
            int localBlockId;
            if (remainingBits < paletteBits) {
                int bitsNextLong = paletteBits - remainingBits;
                localBlockId = (int)currentSerializedValue;
                if (nextSerializedItem >= blockStatesSerialized.length) {
                    throw new InvalidFormatException("Too short block state table");
                }
                currentSerializedValue = blockStatesSerialized[nextSerializedItem++];
                localBlockId = (int)((long)localBlockId | (currentSerializedValue & (long)((1 << bitsNextLong) - 1)) << remainingBits);
                currentSerializedValue >>>= bitsNextLong;
                remainingBits = 64 - bitsNextLong;
            } else {
                localBlockId = (int)(currentSerializedValue & (long)paletteMask);
                currentSerializedValue >>>= paletteBits;
                remainingBits -= paletteBits;
            }
            if (localBlockId >= palette.length) {
                throw new InvalidFormatException("Invalid block state table entry: " + localBlockId);
            }
            chunkSectionBlocks[blockPos] = palette[localBlockId];
        }
    }

    private <T> BlockState getBlockStateWith(BlockState source, Property<T> property, String value) {
        return source.with(property, property.getValueFor(value));
    }

    private void populateTileEntities() throws DataException {
        this.tileEntities = new HashMap<BlockVector3, Map<String, Tag>>();
        if (!this.rootTag.getValue().containsKey("TileEntities")) {
            return;
        }
        Object tags = NBTUtils.getChildTag((Map<String, Tag>)this.rootTag.getValue(), "TileEntities", ListTag.class).getValue();
        Iterator iterator = tags.iterator();
        while (iterator.hasNext()) {
            Tag tag = (Tag)iterator.next();
            if (!(tag instanceof CompoundTag)) {
                throw new InvalidFormatException("CompoundTag expected in TileEntities");
            }
            CompoundTag t = (CompoundTag)tag;
            HashMap values = new HashMap(t.getValue());
            int x = ((IntTag)values.get("x")).getValue();
            int y = ((IntTag)values.get("y")).getValue();
            int z = ((IntTag)values.get("z")).getValue();
            BlockVector3 vec = BlockVector3.at(x, y, z);
            this.tileEntities.put(vec, values);
        }
    }

    @Nullable
    private CompoundTag getBlockTileEntity(BlockVector3 position) throws DataException {
        Map<String, Tag> values;
        if (this.tileEntities == null) {
            this.populateTileEntities();
        }
        if ((values = this.tileEntities.get(position)) == null) {
            return null;
        }
        return new CompoundTag(values);
    }

    @Override
    public BaseBlock getBlock(BlockVector3 position) throws DataException {
        int x = position.getX() - this.rootX * 16;
        int y = position.getY();
        int z = position.getZ() - this.rootZ * 16;
        int section = y >> 4;
        int yIndex = y & 0xF;
        if (section < 0 || section >= this.blocks.length) {
            throw new DataException("Chunk does not contain position " + position);
        }
        BlockState[] sectionBlocks = this.blocks[section];
        BlockState state = sectionBlocks != null ? sectionBlocks[yIndex << 8 | z << 4 | x] : BlockTypes.AIR.getDefaultState();
        CompoundTag tileEntity = this.getBlockTileEntity(position);
        if (tileEntity != null) {
            return state.toBaseBlock(tileEntity);
        }
        return state.toBaseBlock();
    }
}

