/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.command.argument;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.command.argument.DirectionVectorConverter;
import com.sk89q.worldedit.command.argument.VectorConverter;
import com.sk89q.worldedit.internal.annotation.Offset;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import java.util.List;
import org.enginehub.piston.CommandManager;
import org.enginehub.piston.converter.ArgumentConverter;
import org.enginehub.piston.converter.ConversionResult;
import org.enginehub.piston.inject.InjectedValueAccess;
import org.enginehub.piston.inject.Key;

public class OffsetConverter
implements ArgumentConverter<BlockVector3> {
    private final DirectionVectorConverter directionVectorConverter;
    private final VectorConverter<Integer, BlockVector3> vectorConverter = VectorConverter.BLOCK_VECTOR_3_CONVERTER;

    public static void register(WorldEdit worldEdit, CommandManager commandManager) {
        commandManager.registerConverter(Key.of(BlockVector3.class, Offset.class), new OffsetConverter(worldEdit));
    }

    private OffsetConverter(WorldEdit worldEdit) {
        this.directionVectorConverter = new DirectionVectorConverter(worldEdit, true);
    }

    @Override
    public Component describeAcceptableArguments() {
        return ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)TextComponent.builder().append(this.directionVectorConverter.describeAcceptableArguments())).append(", or ")).append(this.vectorConverter.describeAcceptableArguments())).build();
    }

    @Override
    public List<String> getSuggestions(String input, InjectedValueAccess context) {
        return ImmutableList.copyOf((Iterable)Iterables.concat(this.directionVectorConverter.getSuggestions(input, context), this.vectorConverter.getSuggestions(input, context)));
    }

    @Override
    public ConversionResult<BlockVector3> convert(String input, InjectedValueAccess context) {
        return this.directionVectorConverter.convert(input, context).orElse(this.vectorConverter.convert(input, context));
    }
}

