/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.forge;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.jnbt.Tag;
import com.sk89q.worldedit.blocks.BaseItemStack;
import com.sk89q.worldedit.forge.ForgePlayer;
import com.sk89q.worldedit.forge.ForgeWorld;
import com.sk89q.worldedit.forge.IPropertyAdapter;
import com.sk89q.worldedit.forge.internal.NBTConverter;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.math.Vector3;
import com.sk89q.worldedit.registry.state.DirectionalProperty;
import com.sk89q.worldedit.registry.state.EnumProperty;
import com.sk89q.worldedit.registry.state.Property;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.biome.BiomeTypes;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockType;
import com.sk89q.worldedit.world.block.BlockTypes;
import com.sk89q.worldedit.world.item.ItemType;
import com.sk89q.worldedit.world.item.ItemTypes;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public final class ForgeAdapter {
    private ForgeAdapter() {
    }

    public static com.sk89q.worldedit.world.World adapt(World world) {
        return new ForgeWorld(world);
    }

    public static Biome adapt(BiomeType biomeType) {
        return (Biome)ForgeRegistries.BIOMES.getValue(new ResourceLocation(biomeType.getId()));
    }

    public static BiomeType adapt(Biome biome) {
        return BiomeTypes.get(biome.getRegistryName().toString());
    }

    public static Vector3 adapt(Vector3d vector) {
        return Vector3.at(vector.field_72450_a, vector.field_72448_b, vector.field_72449_c);
    }

    public static BlockVector3 adapt(BlockPos pos) {
        return BlockVector3.at(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public static Vector3d toVec3(BlockVector3 vector) {
        return new Vector3d((double)vector.getBlockX(), (double)vector.getBlockY(), (double)vector.getBlockZ());
    }

    public static Direction adapt(com.sk89q.worldedit.util.Direction face) {
        switch (face) {
            case NORTH: {
                return Direction.NORTH;
            }
            case SOUTH: {
                return Direction.SOUTH;
            }
            case WEST: {
                return Direction.WEST;
            }
            case EAST: {
                return Direction.EAST;
            }
            case DOWN: {
                return Direction.DOWN;
            }
        }
        return Direction.UP;
    }

    public static com.sk89q.worldedit.util.Direction adaptEnumFacing(@Nullable Direction face) {
        if (face == null) {
            return null;
        }
        switch (face) {
            case NORTH: {
                return com.sk89q.worldedit.util.Direction.NORTH;
            }
            case SOUTH: {
                return com.sk89q.worldedit.util.Direction.SOUTH;
            }
            case WEST: {
                return com.sk89q.worldedit.util.Direction.WEST;
            }
            case EAST: {
                return com.sk89q.worldedit.util.Direction.EAST;
            }
            case DOWN: {
                return com.sk89q.worldedit.util.Direction.DOWN;
            }
        }
        return com.sk89q.worldedit.util.Direction.UP;
    }

    public static BlockPos toBlockPos(BlockVector3 vector) {
        return new BlockPos(vector.getBlockX(), vector.getBlockY(), vector.getBlockZ());
    }

    public static Property<?> adaptProperty(net.minecraft.state.Property<?> property) {
        if (property instanceof BooleanProperty) {
            return new com.sk89q.worldedit.registry.state.BooleanProperty(property.func_177701_a(), (List<Boolean>)ImmutableList.copyOf((Collection)((BooleanProperty)property).func_177700_c()));
        }
        if (property instanceof IntegerProperty) {
            return new com.sk89q.worldedit.registry.state.IntegerProperty(property.func_177701_a(), (List<Integer>)ImmutableList.copyOf((Collection)((IntegerProperty)property).func_177700_c()));
        }
        if (property instanceof DirectionProperty) {
            return new DirectionalProperty(property.func_177701_a(), ((DirectionProperty)property).func_177700_c().stream().map(ForgeAdapter::adaptEnumFacing).collect(Collectors.toList()));
        }
        if (property instanceof net.minecraft.state.EnumProperty) {
            return new EnumProperty(property.func_177701_a(), ((net.minecraft.state.EnumProperty)property).func_177700_c().stream().map(x -> ((IStringSerializable)x).func_176610_l()).collect(Collectors.toList()));
        }
        return new IPropertyAdapter(property);
    }

    public static Map<Property<?>, Object> adaptProperties(BlockType block, Map<net.minecraft.state.Property<?>, Comparable<?>> mcProps) {
        TreeMap props = new TreeMap(Comparator.comparing(Property::getName));
        for (Map.Entry<net.minecraft.state.Property<?>, Comparable<?>> prop : mcProps.entrySet()) {
            Object value = prop.getValue();
            if (prop.getKey() instanceof DirectionProperty) {
                value = ForgeAdapter.adaptEnumFacing((Direction)value);
            } else if (prop.getKey() instanceof net.minecraft.state.EnumProperty) {
                value = ((IStringSerializable)value).func_176610_l();
            }
            props.put(block.getProperty(prop.getKey().func_177701_a()), value);
        }
        return props;
    }

    private static net.minecraft.block.BlockState applyProperties(StateContainer<Block, net.minecraft.block.BlockState> stateContainer, net.minecraft.block.BlockState newState, Map<Property<?>, Object> states) {
        for (Map.Entry<Property<?>, Object> state : states.entrySet()) {
            net.minecraft.state.Property property = stateContainer.func_185920_a(state.getKey().getName());
            Comparable value = (Comparable)state.getValue();
            if (property instanceof DirectionProperty) {
                com.sk89q.worldedit.util.Direction dir = (com.sk89q.worldedit.util.Direction)((Object)value);
                value = ForgeAdapter.adapt(dir);
            } else if (property instanceof net.minecraft.state.EnumProperty) {
                String enumName = (String)((Object)value);
                value = (Comparable)((Object)((net.minecraft.state.EnumProperty)property).func_185929_b((String)((Object)value)).orElseGet(() -> {
                    throw new IllegalStateException("Enum property " + property.func_177701_a() + " does not contain " + enumName);
                }));
            }
            newState = (net.minecraft.block.BlockState)newState.func_206870_a(property, value);
        }
        return newState;
    }

    public static net.minecraft.block.BlockState adapt(BlockState blockState) {
        Block mcBlock = ForgeAdapter.adapt(blockState.getBlockType());
        net.minecraft.block.BlockState newState = mcBlock.func_176223_P();
        Map<Property<?>, Object> states = blockState.getStates();
        return ForgeAdapter.applyProperties((StateContainer<Block, net.minecraft.block.BlockState>)mcBlock.func_176194_O(), newState, states);
    }

    public static BlockState adapt(net.minecraft.block.BlockState blockState) {
        BlockType blockType = ForgeAdapter.adapt(blockState.func_177230_c());
        return blockType.getState(ForgeAdapter.adaptProperties(blockType, blockState.func_206871_b()));
    }

    public static Block adapt(BlockType blockType) {
        return (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blockType.getId()));
    }

    public static BlockType adapt(Block block) {
        return BlockTypes.get(ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)block).toString());
    }

    public static Item adapt(ItemType itemType) {
        return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemType.getId()));
    }

    public static ItemType adapt(Item item) {
        return ItemTypes.get(ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)item).toString());
    }

    public static ItemStack adapt(BaseItemStack baseItemStack) {
        CompoundNBT forgeCompound = null;
        if (baseItemStack.getNbtData() != null) {
            forgeCompound = NBTConverter.toNative(baseItemStack.getNbtData());
        }
        ItemStack itemStack = new ItemStack((IItemProvider)ForgeAdapter.adapt(baseItemStack.getType()), baseItemStack.getAmount());
        itemStack.func_77982_d(forgeCompound);
        return itemStack;
    }

    public static BaseItemStack adapt(ItemStack itemStack) {
        Tag tagTag;
        CompoundTag tag = NBTConverter.fromNative(itemStack.serializeNBT());
        tag = tag.getValue().isEmpty() ? null : ((tagTag = (Tag)tag.getValue().get("tag")) instanceof CompoundTag ? (CompoundTag)tagTag : null);
        return new BaseItemStack(ForgeAdapter.adapt(itemStack.func_77973_b()), tag, itemStack.func_190916_E());
    }

    public static ForgePlayer adaptPlayer(ServerPlayerEntity player) {
        Preconditions.checkNotNull((Object)player);
        return new ForgePlayer(player);
    }
}

