/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.forge;

import com.google.common.base.Preconditions;
import com.sk89q.worldedit.entity.metadata.EntityProperties;
import net.minecraft.entity.Entity;
import net.minecraft.entity.INPC;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.boss.dragon.EnderDragonPartEntity;
import net.minecraft.entity.item.ArmorStandEntity;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.item.FallingBlockEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.entity.item.PaintingEntity;
import net.minecraft.entity.item.TNTEntity;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.entity.merchant.IMerchant;
import net.minecraft.entity.passive.AmbientEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.GolemEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.ProjectileEntity;

public class ForgeEntityProperties
implements EntityProperties {
    private final Entity entity;

    public ForgeEntityProperties(Entity entity) {
        Preconditions.checkNotNull((Object)entity);
        this.entity = entity;
    }

    @Override
    public boolean isPlayerDerived() {
        return this.entity instanceof PlayerEntity;
    }

    @Override
    public boolean isProjectile() {
        return this.entity instanceof ProjectileEntity;
    }

    @Override
    public boolean isItem() {
        return this.entity instanceof ItemEntity;
    }

    @Override
    public boolean isFallingBlock() {
        return this.entity instanceof FallingBlockEntity;
    }

    @Override
    public boolean isPainting() {
        return this.entity instanceof PaintingEntity;
    }

    @Override
    public boolean isItemFrame() {
        return this.entity instanceof ItemFrameEntity;
    }

    @Override
    public boolean isBoat() {
        return this.entity instanceof BoatEntity;
    }

    @Override
    public boolean isMinecart() {
        return this.entity instanceof AbstractMinecartEntity;
    }

    @Override
    public boolean isTNT() {
        return this.entity instanceof TNTEntity;
    }

    @Override
    public boolean isExperienceOrb() {
        return this.entity instanceof ExperienceOrbEntity;
    }

    @Override
    public boolean isLiving() {
        return this.entity instanceof MobEntity;
    }

    @Override
    public boolean isAnimal() {
        return this.entity instanceof AnimalEntity;
    }

    @Override
    public boolean isAmbient() {
        return this.entity instanceof AmbientEntity;
    }

    @Override
    public boolean isNPC() {
        return this.entity instanceof INPC || this.entity instanceof IMerchant;
    }

    @Override
    public boolean isGolem() {
        return this.entity instanceof GolemEntity;
    }

    @Override
    public boolean isTamed() {
        return this.entity instanceof TameableEntity && ((TameableEntity)this.entity).func_70909_n();
    }

    @Override
    public boolean isTagged() {
        return this.entity.func_145818_k_();
    }

    @Override
    public boolean isArmorStand() {
        return this.entity instanceof ArmorStandEntity;
    }

    @Override
    public boolean isPasteable() {
        return !(this.entity instanceof ServerPlayerEntity) && !(this.entity instanceof EnderDragonPartEntity);
    }
}

