/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.forge;

import com.sk89q.jnbt.CompoundTag;
import com.sk89q.util.StringUtil;
import com.sk89q.worldedit.blocks.BaseItemStack;
import com.sk89q.worldedit.entity.BaseEntity;
import com.sk89q.worldedit.extension.platform.AbstractPlayerActor;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.extent.inventory.BlockBag;
import com.sk89q.worldedit.forge.ForgeAdapter;
import com.sk89q.worldedit.forge.ForgeWorld;
import com.sk89q.worldedit.forge.ForgeWorldEdit;
import com.sk89q.worldedit.forge.ThreadSafeCache;
import com.sk89q.worldedit.forge.internal.NBTConverter;
import com.sk89q.worldedit.forge.net.handler.WECUIPacketHandler;
import com.sk89q.worldedit.internal.cui.CUIEvent;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.math.Vector3;
import com.sk89q.worldedit.session.SessionKey;
import com.sk89q.worldedit.util.HandSide;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.util.formatting.WorldEditText;
import com.sk89q.worldedit.util.formatting.component.TextUtils;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.serializer.gson.GsonComponentSerializer;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockTypes;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.Locale;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SChangeBlockPacket;
import net.minecraft.network.play.server.SCustomPayloadPlayPacket;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ChatType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;

public class ForgePlayer
extends AbstractPlayerActor {
    private static final int STRUCTURE_BLOCK_PACKET_ID = 7;
    private final ServerPlayerEntity player;

    protected ForgePlayer(ServerPlayerEntity player) {
        this.player = player;
        ThreadSafeCache.getInstance().getOnlineIds().add(this.getUniqueId());
    }

    @Override
    public UUID getUniqueId() {
        return this.player.func_110124_au();
    }

    @Override
    public BaseItemStack getItemInHand(HandSide handSide) {
        ItemStack is = this.player.func_184586_b(handSide == HandSide.MAIN_HAND ? Hand.MAIN_HAND : Hand.OFF_HAND);
        return ForgeAdapter.adapt(is);
    }

    @Override
    public String getName() {
        return this.player.func_200200_C_().func_150261_e();
    }

    @Override
    public BaseEntity getState() {
        throw new UnsupportedOperationException("Cannot create a state from this object");
    }

    @Override
    public Location getLocation() {
        Vector3 position = Vector3.at(this.player.func_226277_ct_(), this.player.func_226278_cu_(), this.player.func_226281_cx_());
        return new Location((Extent)ForgeWorldEdit.inst.getWorld(this.player.field_70170_p), position, this.player.field_70177_z, this.player.field_70125_A);
    }

    @Override
    public boolean setLocation(Location location) {
        return false;
    }

    @Override
    public World getWorld() {
        return ForgeWorldEdit.inst.getWorld(this.player.field_70170_p);
    }

    @Override
    public void giveItem(BaseItemStack itemStack) {
        this.player.field_71071_by.func_70441_a(ForgeAdapter.adapt(itemStack));
    }

    @Override
    public void dispatchCUIEvent(CUIEvent event) {
        String[] params = event.getParameters();
        String send = event.getTypeId();
        if (params.length > 0) {
            send = send + "|" + StringUtil.joinString(params, "|");
        }
        PacketBuffer buffer = new PacketBuffer(Unpooled.copiedBuffer((byte[])send.getBytes(WECUIPacketHandler.UTF_8_CHARSET)));
        SCustomPayloadPlayPacket packet = new SCustomPayloadPlayPacket(new ResourceLocation("worldedit", "cui"), buffer);
        this.player.field_71135_a.func_147359_a((IPacket)packet);
    }

    private void sendMessage(ITextComponent textComponent) {
        this.player.func_241151_a_(textComponent, ChatType.CHAT, Util.field_240973_b_);
    }

    @Override
    @Deprecated
    public void printRaw(String msg) {
        for (String part : msg.split("\n")) {
            this.sendMessage((ITextComponent)new StringTextComponent(part));
        }
    }

    @Override
    @Deprecated
    public void printDebug(String msg) {
        this.sendColorized(msg, TextFormatting.GRAY);
    }

    @Override
    @Deprecated
    public void print(String msg) {
        this.sendColorized(msg, TextFormatting.LIGHT_PURPLE);
    }

    @Override
    @Deprecated
    public void printError(String msg) {
        this.sendColorized(msg, TextFormatting.RED);
    }

    @Override
    public void print(Component component) {
        this.sendMessage((ITextComponent)ITextComponent.Serializer.func_240643_a_((String)GsonComponentSerializer.INSTANCE.serialize(WorldEditText.format(component, this.getLocale()))));
    }

    private void sendColorized(String msg, TextFormatting formatting) {
        for (String part : msg.split("\n")) {
            StringTextComponent component = new StringTextComponent(part);
            component.func_240699_a_(formatting);
            this.sendMessage((ITextComponent)component);
        }
    }

    @Override
    public boolean trySetPosition(Vector3 pos, float pitch, float yaw) {
        this.player.field_71135_a.func_147364_a(pos.getX(), pos.getY(), pos.getZ(), yaw, pitch);
        return true;
    }

    @Override
    public String[] getGroups() {
        return new String[0];
    }

    @Override
    public BlockBag getInventoryBlockBag() {
        return null;
    }

    @Override
    public boolean hasPermission(String perm) {
        return ForgeWorldEdit.inst.getPermissionsProvider().hasPermission(this.player, perm);
    }

    @Override
    @Nullable
    public <T> T getFacet(Class<? extends T> cls) {
        return null;
    }

    @Override
    public boolean isAllowedToFly() {
        return this.player.field_71075_bZ.field_75101_c;
    }

    @Override
    public void setFlying(boolean flying) {
        if (this.player.field_71075_bZ.field_75100_b != flying) {
            this.player.field_71075_bZ.field_75100_b = flying;
            this.player.func_71016_p();
        }
    }

    @Override
    public Locale getLocale() {
        return TextUtils.getLocaleByMinecraftTag(this.player.getLanguage());
    }

    @Override
    public <B extends BlockStateHolder<B>> void sendFakeBlock(BlockVector3 pos, B block) {
        World world = this.getWorld();
        if (!(world instanceof ForgeWorld)) {
            return;
        }
        BlockPos loc = ForgeAdapter.toBlockPos(pos);
        if (block == null) {
            SChangeBlockPacket packetOut = new SChangeBlockPacket((IBlockReader)((ForgeWorld)world).getWorld(), loc);
            this.player.field_71135_a.func_147359_a((IPacket)packetOut);
        } else {
            BaseBlock baseBlock;
            CompoundTag nbtData;
            SChangeBlockPacket packetOut = new SChangeBlockPacket();
            PacketBuffer buf = new PacketBuffer(Unpooled.buffer());
            buf.func_179255_a(loc);
            buf.func_150787_b(Block.func_196246_j((BlockState)ForgeAdapter.adapt(block.toImmutableState())));
            try {
                packetOut.func_148837_a(buf);
            }
            catch (IOException e) {
                return;
            }
            this.player.field_71135_a.func_147359_a((IPacket)packetOut);
            if (block instanceof BaseBlock && block.getBlockType().equals(BlockTypes.STRUCTURE_BLOCK) && (nbtData = (baseBlock = (BaseBlock)block).getNbtData()) != null) {
                this.player.field_71135_a.func_147359_a((IPacket)new SUpdateTileEntityPacket(new BlockPos(pos.getBlockX(), pos.getBlockY(), pos.getBlockZ()), 7, NBTConverter.toNative(nbtData)));
            }
        }
    }

    @Override
    public SessionKey getSessionKey() {
        return new SessionKeyImpl(this.player.func_110124_au(), this.player.func_200200_C_().getString());
    }

    private static class SessionKeyImpl
    implements SessionKey {
        private final UUID uuid;
        private final String name;

        private SessionKeyImpl(UUID uuid, String name) {
            this.uuid = uuid;
            this.name = name;
        }

        @Override
        public UUID getUniqueId() {
            return this.uuid;
        }

        @Override
        @Nullable
        public String getName() {
            return this.name;
        }

        @Override
        public boolean isActive() {
            return ThreadSafeCache.getInstance().getOnlineIds().contains(this.uuid);
        }

        @Override
        public boolean isPersistent() {
            return true;
        }
    }
}

