/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.forge;

import com.google.common.base.Preconditions;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.event.platform.CommandEvent;
import com.sk89q.worldedit.event.platform.PlatformReadyEvent;
import com.sk89q.worldedit.extension.platform.Platform;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.forge.CommandWrapper;
import com.sk89q.worldedit.forge.ForgeAdapter;
import com.sk89q.worldedit.forge.ForgeConfiguration;
import com.sk89q.worldedit.forge.ForgePermissionsProvider;
import com.sk89q.worldedit.forge.ForgePlatform;
import com.sk89q.worldedit.forge.ForgePlayer;
import com.sk89q.worldedit.forge.ForgeWorld;
import com.sk89q.worldedit.forge.ThreadSafeCache;
import com.sk89q.worldedit.forge.net.handler.InternalPacketHandler;
import com.sk89q.worldedit.forge.net.handler.WECUIPacketHandler;
import com.sk89q.worldedit.forge.net.packet.LeftClickAirEventMessage;
import com.sk89q.worldedit.internal.anvil.ChunkDeleter;
import com.sk89q.worldedit.util.Direction;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.block.BlockCategory;
import com.sk89q.worldedit.world.block.BlockType;
import com.sk89q.worldedit.world.entity.EntityType;
import com.sk89q.worldedit.world.item.ItemCategory;
import com.sk89q.worldedit.world.item.ItemType;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ExtensionPoint;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.event.server.FMLServerStartedEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="worldedit")
public class ForgeWorldEdit {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String MOD_ID = "worldedit";
    public static final String CUI_PLUGIN_CHANNEL = "cui";
    private ForgePermissionsProvider provider;
    public static ForgeWorldEdit inst;
    private ForgePlatform platform;
    private ForgeConfiguration config;
    private Path workingDir;
    private ModContainer container;

    public ForgeWorldEdit() {
        inst = this;
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        modBus.addListener(this::init);
        MinecraftForge.EVENT_BUS.register((Object)ThreadSafeCache.getInstance());
        MinecraftForge.EVENT_BUS.register((Object)this);
        ModLoadingContext.get().registerExtensionPoint(ExtensionPoint.DISPLAYTEST, () -> Pair.of(() -> "OHNOES\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31", (a, b) -> true));
    }

    private void init(FMLCommonSetupEvent event) {
        this.container = ModLoadingContext.get().getActiveContainer();
        this.workingDir = FMLPaths.CONFIGDIR.get().resolve(MOD_ID);
        if (!Files.exists(this.workingDir, new LinkOption[0])) {
            try {
                Files.createDirectory(this.workingDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        WECUIPacketHandler.init();
        InternalPacketHandler.init();
        LOGGER.info("WorldEdit for Forge (version " + this.getInternalVersion() + ") is loaded");
    }

    private void setupPlatform() {
        this.platform = new ForgePlatform(this);
        WorldEdit.getInstance().getPlatformManager().register(this.platform);
        this.provider = new ForgePermissionsProvider.VanillaPermissionsProvider(this.platform);
    }

    private void setupRegistries() {
        for (ResourceLocation name : ForgeRegistries.BLOCKS.getKeys()) {
            if (BlockType.REGISTRY.get(name.toString()) != null) continue;
            BlockType.REGISTRY.register(name.toString(), new BlockType(name.toString(), input -> ForgeAdapter.adapt(ForgeAdapter.adapt(input.getBlockType()).func_176223_P())));
        }
        for (ResourceLocation name : ForgeRegistries.ITEMS.getKeys()) {
            if (ItemType.REGISTRY.get(name.toString()) != null) continue;
            ItemType.REGISTRY.register(name.toString(), new ItemType(name.toString()));
        }
        for (ResourceLocation name : ForgeRegistries.ENTITIES.getKeys()) {
            if (EntityType.REGISTRY.get(name.toString()) != null) continue;
            EntityType.REGISTRY.register(name.toString(), new EntityType(name.toString()));
        }
        for (ResourceLocation name : ForgeRegistries.BIOMES.getKeys()) {
            if (BiomeType.REGISTRY.get(name.toString()) != null) continue;
            BiomeType.REGISTRY.register(name.toString(), new BiomeType(name.toString()));
        }
        for (ResourceLocation name : BlockTags.func_199896_a().func_199908_a()) {
            if (BlockCategory.REGISTRY.get(name.toString()) != null) continue;
            BlockCategory.REGISTRY.register(name.toString(), new BlockCategory(name.toString()));
        }
        for (ResourceLocation name : ItemTags.func_199903_a().func_199908_a()) {
            if (ItemCategory.REGISTRY.get(name.toString()) != null) continue;
            ItemCategory.REGISTRY.register(name.toString(), new ItemCategory(name.toString()));
        }
    }

    @SubscribeEvent
    public void serverAboutToStart(FMLServerAboutToStartEvent event) {
        Path delChunks = this.workingDir.resolve("delete_chunks.json");
        if (Files.exists(delChunks, new LinkOption[0])) {
            ChunkDeleter.runFromFile(delChunks, true);
        }
    }

    @SubscribeEvent
    public void serverStopping(FMLServerStoppingEvent event) {
        WorldEdit worldEdit = WorldEdit.getInstance();
        worldEdit.getSessionManager().unload();
        worldEdit.getPlatformManager().unregister(this.platform);
    }

    @SubscribeEvent
    public void serverStarted(FMLServerStartedEvent event) {
        this.setupPlatform();
        this.setupRegistries();
        this.config = new ForgeConfiguration(this);
        this.config.load();
        WorldEdit.getInstance().getEventBus().post(new PlatformReadyEvent());
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent event) {
        boolean isRightDeny;
        if (this.platform == null) {
            return;
        }
        if (!this.platform.isHookingEvents()) {
            return;
        }
        if (event.getWorld().field_72995_K && event instanceof PlayerInteractEvent.LeftClickEmpty) {
            InternalPacketHandler.getHandler().sendToServer((Object)LeftClickAirEventMessage.INSTANCE);
            return;
        }
        boolean isLeftDeny = event instanceof PlayerInteractEvent.LeftClickBlock && ((PlayerInteractEvent.LeftClickBlock)event).getUseItem() == Event.Result.DENY;
        boolean bl = isRightDeny = event instanceof PlayerInteractEvent.RightClickBlock && ((PlayerInteractEvent.RightClickBlock)event).getUseItem() == Event.Result.DENY;
        if (isLeftDeny || isRightDeny || event.getEntity().field_70170_p.field_72995_K || event.getHand() == Hand.OFF_HAND) {
            return;
        }
        WorldEdit we = WorldEdit.getInstance();
        ForgePlayer player = ForgeAdapter.adaptPlayer((ServerPlayerEntity)event.getPlayer());
        ForgeWorld world = this.getWorld(event.getPlayer().field_70170_p);
        Direction direction = ForgeAdapter.adaptEnumFacing(event.getFace());
        if (event instanceof PlayerInteractEvent.LeftClickEmpty) {
            we.handleArmSwing(player);
        } else if (event instanceof PlayerInteractEvent.LeftClickBlock) {
            Location pos = new Location((Extent)world, event.getPos().func_177958_n(), (double)event.getPos().func_177956_o(), (double)event.getPos().func_177952_p());
            if (we.handleBlockLeftClick(player, pos, direction)) {
                event.setCanceled(true);
            }
            if (we.handleArmSwing(player)) {
                event.setCanceled(true);
            }
        } else if (event instanceof PlayerInteractEvent.RightClickBlock) {
            Location pos = new Location((Extent)world, event.getPos().func_177958_n(), (double)event.getPos().func_177956_o(), (double)event.getPos().func_177952_p());
            if (we.handleBlockRightClick(player, pos, direction)) {
                event.setCanceled(true);
            }
            if (we.handleRightClick(player)) {
                event.setCanceled(true);
            }
        } else if (event instanceof PlayerInteractEvent.RightClickItem && we.handleRightClick(player)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onCommandEvent(net.minecraftforge.event.CommandEvent event) throws CommandSyntaxException {
        ParseResults parseResults = event.getParseResults();
        if (!(((CommandSource)parseResults.getContext().getSource()).func_197022_f() instanceof ServerPlayerEntity)) {
            return;
        }
        ServerPlayerEntity player = ((CommandSource)parseResults.getContext().getSource()).func_197035_h();
        if (player.field_70170_p.func_201670_d()) {
            return;
        }
        if (parseResults.getContext().getCommand() != CommandWrapper.FAKE_COMMAND) {
            return;
        }
        event.setCanceled(true);
        WorldEdit.getInstance().getEventBus().post(new CommandEvent(ForgeAdapter.adaptPlayer(((CommandSource)parseResults.getContext().getSource()).func_197035_h()), parseResults.getReader().getString()));
    }

    ForgeConfiguration getConfig() {
        return this.config;
    }

    public LocalSession getSession(ServerPlayerEntity player) {
        Preconditions.checkNotNull((Object)player);
        return WorldEdit.getInstance().getSessionManager().get(ForgeAdapter.adaptPlayer(player));
    }

    public ForgeWorld getWorld(World world) {
        Preconditions.checkNotNull((Object)world);
        return new ForgeWorld(world);
    }

    public Platform getPlatform() {
        return this.platform;
    }

    public File getWorkingDir() {
        return this.workingDir.toFile();
    }

    String getInternalVersion() {
        return this.container.getModInfo().getVersion().toString();
    }

    public void setPermissionsProvider(ForgePermissionsProvider provider) {
        this.provider = provider;
    }

    public ForgePermissionsProvider getPermissionsProvider() {
        return this.provider;
    }
}

