/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.util.io.file;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public class SafeFiles {
    public static Stream<Path> noLeakFileList(Path dir) throws IOException {
        try (Stream<Path> stream = Files.list(dir);){
            Stream<Path> stream2 = stream.collect(Collectors.toList()).stream();
            return stream2;
        }
    }

    public static String canonicalFileName(Path path) {
        return SafeFiles.dropSlash(path.getFileName().toString());
    }

    private static String dropSlash(String name) {
        if (name.isEmpty() || name.codePointBefore(name.length()) != 47) {
            return name;
        }
        return name.substring(0, name.length() - 1);
    }

    public static void tryHardToDeleteDir(Path directory) throws IOException {
        if (!Files.isDirectory(directory, new LinkOption[0])) {
            if (!Files.exists(directory, new LinkOption[0])) {
                return;
            }
            throw new IOException(directory + " is not a directory");
        }
        try (Stream<Path> files = Files.list(directory);){
            Iterator iter = files.iterator();
            while (iter.hasNext()) {
                Path next = (Path)iter.next();
                if (Files.isDirectory(next, new LinkOption[0])) {
                    SafeFiles.tryHardToDeleteDir(next);
                    continue;
                }
                SafeFiles.tryHardToDelete(next);
            }
        }
        SafeFiles.tryHardToDelete(directory);
    }

    public static void tryHardToDelete(Path path) throws IOException {
        IOException suppressed = SafeFiles.tryDelete(path);
        if (suppressed == null) {
            return;
        }
        System.gc();
        try {
            Thread.sleep(10L);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        IOException suppressed2 = SafeFiles.tryDelete(path);
        if (suppressed2 == null) {
            return;
        }
        IOException ex = new IOException("Failed to delete " + path, suppressed2);
        ex.addSuppressed(suppressed);
        throw ex;
    }

    @Nullable
    private static IOException tryDelete(Path path) {
        try {
            Files.deleteIfExists(path);
            if (Files.exists(path, new LinkOption[0])) {
                return new IOException(path + " still exists after deleting");
            }
            return null;
        }
        catch (IOException e) {
            return e;
        }
    }

    private SafeFiles() {
    }
}

