/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.util.io.file;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import com.sk89q.worldedit.util.io.file.ArchiveDir;
import com.sk89q.worldedit.util.io.file.ArchiveNioSupport;
import com.sk89q.worldedit.util.io.file.ArchiveNioSupports;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Optional;
import java.util.Set;
import net.java.truevfs.access.TArchiveDetector;
import net.java.truevfs.access.TFileSystem;
import net.java.truevfs.access.TPath;

public final class TrueVfsArchiveNioSupport
implements ArchiveNioSupport {
    private static final TrueVfsArchiveNioSupport INSTANCE = new TrueVfsArchiveNioSupport();
    private static final Set<String> ALLOWED_EXTENSIONS = ImmutableSet.copyOf((Iterable)Splitter.on((char)'|').split((CharSequence)TArchiveDetector.ALL.getExtensions()));

    public static TrueVfsArchiveNioSupport getInstance() {
        return INSTANCE;
    }

    private TrueVfsArchiveNioSupport() {
    }

    @Override
    public Optional<ArchiveDir> tryOpenAsDir(Path archive) throws IOException {
        String fileName = archive.getFileName().toString();
        int dot = fileName.indexOf(46);
        if (dot < 0 || dot >= fileName.length() || !ALLOWED_EXTENSIONS.contains(fileName.substring(dot + 1))) {
            return Optional.empty();
        }
        final TFileSystem fileSystem = new TPath(archive).getFileSystem();
        TPath root = fileSystem.getPath("/", new String[0]);
        final Path realRoot = ArchiveNioSupports.skipRootSameName((Path)root, fileName.substring(0, dot));
        return Optional.of(new ArchiveDir(){

            @Override
            public Path getPath() {
                return realRoot;
            }

            @Override
            public void close() throws IOException {
                fileSystem.close();
            }
        });
    }
}

