/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.RegistrationHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SCEventHandler;
import net.geforcemods.securitycraft.SetupHandler;
import net.geforcemods.securitycraft.TileEntityIDDataFixer;
import net.geforcemods.securitycraft.api.IExtractionBlock;
import net.geforcemods.securitycraft.blocks.reinforced.BlockReinforcedHopper;
import net.geforcemods.securitycraft.blocks.reinforced.IReinforcedBlock;
import net.geforcemods.securitycraft.commands.CommandSC;
import net.geforcemods.securitycraft.compat.cyclic.CyclicCompat;
import net.geforcemods.securitycraft.compat.icbmclassic.ICBMClassicEMPCompat;
import net.geforcemods.securitycraft.compat.versionchecker.VersionUpdateChecker;
import net.geforcemods.securitycraft.gui.GuiHandler;
import net.geforcemods.securitycraft.misc.EnumModuleType;
import net.geforcemods.securitycraft.misc.SCManualPage;
import net.geforcemods.securitycraft.network.IProxy;
import net.geforcemods.securitycraft.tabs.CreativeTabSCDecoration;
import net.geforcemods.securitycraft.tabs.CreativeTabSCExplosives;
import net.geforcemods.securitycraft.tabs.CreativeTabSCTechnical;
import net.geforcemods.securitycraft.util.Reinforced;
import net.minecraft.block.Block;
import net.minecraft.command.ICommand;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IFixType;
import net.minecraft.util.datafix.IFixableData;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.common.registry.GameRegistry;

@Mod(modid="securitycraft", name="SecurityCraft", version="v1.8.20", dependencies="required-after:forge@[14.23.5.2826,)", updateJSON="https://www.github.com/Geforce132/SecurityCraft/raw/master/Updates/Forge.json", acceptedMinecraftVersions="[1.12.2]")
public class SecurityCraft {
    public static final String MODID = "securitycraft";
    private static final String MOTU = "Finally! Cameras!";
    public static final String VERSION = "v1.8.20";
    protected static final String DEPENDENCIES = "required-after:forge@[14.23.5.2826,)";
    protected static final String UPDATEJSONURL = "https://www.github.com/Geforce132/SecurityCraft/raw/master/Updates/Forge.json";
    @SidedProxy(clientSide="net.geforcemods.securitycraft.network.ClientProxy", serverSide="net.geforcemods.securitycraft.network.ServerProxy")
    public static IProxy proxy;
    @Mod.Instance(value="securitycraft")
    public static SecurityCraft instance;
    public static SimpleNetworkWrapper network;
    public static SCEventHandler eventHandler;
    private GuiHandler guiHandler = new GuiHandler();
    public ArrayList<SCManualPage> manualPages = new ArrayList();
    public static CreativeTabs tabSCTechnical;
    public static CreativeTabs tabSCMine;
    public static CreativeTabs tabSCDecoration;
    private static List<IExtractionBlock> registeredExtractionBlocks;
    public static final String IMC_EXTRACTION_BLOCK_MSG = "registerExtractionBlock";

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandSC());
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        network = NetworkRegistry.INSTANCE.newSimpleChannel(MODID);
        RegistrationHandler.registerPackets(network);
        SetupHandler.setupBlocks();
        SetupHandler.setupMines();
        SetupHandler.setupItems();
        ModMetadata modMeta = event.getModMetadata();
        modMeta.authorList = Arrays.asList("Geforce", "bl4ckscor3");
        modMeta.autogenerated = false;
        modMeta.credits = "Thanks to all of you guys for your support!";
        modMeta.description = "Adds a load of things to keep your house safe with.\nIf you like this mod, hit the green arrow\nin the corner of the forum thread!\nPlease visit the URL above for help. \n \nMessage of the update: \nFinally! Cameras!";
        modMeta.url = "http://geforcemods.net";
        modMeta.logoFile = "/scLogo.png";
        proxy.registerEntityRenderingHandlers();
        if (Loader.isModLoaded((String)"icbmclassic")) {
            MinecraftForge.EVENT_BUS.register((Object)new ICBMClassicEMPCompat());
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        NBTTagCompound vcUpdateTag;
        FMLInterModComms.sendMessage((String)"waila", (String)"register", (String)"net.geforcemods.securitycraft.compat.waila.WailaDataProvider.callbackRegister");
        FMLInterModComms.sendFunctionMessage((String)"theoneprobe", (String)"getTheOneProbe", (String)"net.geforcemods.securitycraft.compat.top.TOPDataProvider");
        FMLInterModComms.sendFunctionMessage((String)MODID, (String)IMC_EXTRACTION_BLOCK_MSG, (String)BlockReinforcedHopper.ExtractionBlock.class.getName());
        if (ConfigHandler.checkForUpdates && (vcUpdateTag = VersionUpdateChecker.getNBTTagCompound()) != null) {
            FMLInterModComms.sendRuntimeMessage((Object)MODID, (String)"VersionChecker", (String)"addUpdate", (NBTTagCompound)vcUpdateTag);
        }
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)this.guiHandler);
        EnumModuleType.refresh();
        proxy.registerRenderThings();
        FMLCommonHandler.instance().getDataFixer().init(MODID, 1).registerFix((IFixType)FixTypes.BLOCK_ENTITY, (IFixableData)new TileEntityIDDataFixer());
        GameRegistry.addSmelting((ItemStack)new ItemStack(SCContent.reinforcedCobblestone), (ItemStack)new ItemStack(SCContent.reinforcedStone, 1, 0), (float)0.1f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(SCContent.reinforcedSand, 1, 0), (ItemStack)new ItemStack(SCContent.reinforcedGlass, 1, 0), (float)0.1f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(SCContent.reinforcedSand, 1, 1), (ItemStack)new ItemStack(SCContent.reinforcedGlass, 1, 0), (float)0.1f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(SCContent.reinforcedStoneBrick, 1, 0), (ItemStack)new ItemStack(SCContent.reinforcedStoneBrick, 1, 2), (float)0.1f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(SCContent.reinforcedClay, 1, 0), (ItemStack)new ItemStack(SCContent.reinforcedHardenedClay, 1, 0), (float)0.35f);
    }

    @Mod.EventHandler
    public void onIMC(FMLInterModComms.IMCEvent event) {
        for (FMLInterModComms.IMCMessage msg : event.getMessages()) {
            if (!msg.key.equals(IMC_EXTRACTION_BLOCK_MSG)) continue;
            Optional value = msg.getFunctionValue(Object.class, IExtractionBlock.class);
            if (value.isPresent()) {
                registeredExtractionBlocks.add((IExtractionBlock)((Function)value.get()).apply(null));
                continue;
            }
            System.out.println(String.format("[ERROR] Mod %s did not supply sufficient extraction block information.", msg.getSender()));
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)eventHandler);
        if (Loader.isModLoaded((String)"cyclicmagic")) {
            MinecraftForge.EVENT_BUS.register((Object)new CyclicCompat());
        }
        for (Field field : SCContent.class.getFields()) {
            try {
                if (!field.isAnnotationPresent(Reinforced.class)) continue;
                IReinforcedBlock.BLOCKS.add((Block)field.get(null));
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
    }

    public static List<IExtractionBlock> getRegisteredExtractionBlocks() {
        return registeredExtractionBlocks;
    }

    static {
        instance = new SecurityCraft();
        eventHandler = new SCEventHandler();
        tabSCTechnical = new CreativeTabSCTechnical();
        tabSCMine = new CreativeTabSCExplosives();
        tabSCDecoration = new CreativeTabSCDecoration();
        registeredExtractionBlocks = new ArrayList<IExtractionBlock>();
    }
}

