/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.gui;

import java.util.ArrayList;
import java.util.List;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.containers.ContainerGeneric;
import net.geforcemods.securitycraft.entity.EntitySentry;
import net.geforcemods.securitycraft.gui.components.GuiPictureButton;
import net.geforcemods.securitycraft.gui.components.StringHoverChecker;
import net.geforcemods.securitycraft.network.packets.PacketSUpdateNBTTag;
import net.geforcemods.securitycraft.network.packets.PacketSetSentryMode;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiSRAT
extends GuiContainer {
    private static final ResourceLocation TEXTURE = new ResourceLocation("securitycraft", "textures/gui/container/srat.png");
    private static final ResourceLocation SENTRY_ICONS = new ResourceLocation("securitycraft", "textures/gui/container/sentry_icons.png");
    private ItemStack srat;
    private GuiButton[][] buttons = new GuiButton[12][4];
    private String[] names = new String[12];
    private GuiButton[][] buttonsGlobal = new GuiButton[1][3];
    private static final int AGGRESSIVE = 0;
    private static final int CAMOUFLAGE = 1;
    private static final int IDLE = 2;
    private static final int UNBIND = 3;
    private List<StringHoverChecker> hoverCheckers = new ArrayList<StringHoverChecker>();
    private static final int SENTRY_TRACKING_RANGE = 256;
    private int viewDistance;

    public GuiSRAT(InventoryPlayer inventory, ItemStack item, int viewDistance) {
        super((Container)new ContainerGeneric(inventory, null));
        this.srat = item;
        this.field_146999_f = 440;
        this.field_147000_g = 215;
        this.viewDistance = viewDistance;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int paddingX = 22;
        int paddingY = 25;
        int[] coords = null;
        int id = 0;
        boolean foundSentry = false;
        this.hoverCheckers.clear();
        for (int i = 0; i < 12; ++i) {
            int x = i / 6 * this.field_146999_f / 2;
            int y = (i % 6 + 1) * 30 + paddingY;
            coords = this.getSentryCoordinates(i);
            for (int j = 0; j < 4; ++j) {
                int btnX = this.field_147003_i + j * paddingX + 127 + x;
                int btnY = this.field_147009_r + y - 48;
                switch (j) {
                    case 0: {
                        this.buttons[i][j] = new GuiPictureButton(id++, btnX, btnY, 20, 20, SENTRY_ICONS, -2, -1, 18, 18);
                        this.buttons[i][j].field_146124_l = false;
                        break;
                    }
                    case 1: {
                        this.buttons[i][j] = new GuiPictureButton(id++, btnX, btnY, 20, 20, SENTRY_ICONS, 40, -1, 18, 18);
                        this.buttons[i][j].field_146124_l = false;
                        break;
                    }
                    case 2: {
                        this.buttons[i][j] = new GuiPictureButton(id++, btnX, btnY, 20, 20, SENTRY_ICONS, 19, -1, 18, 17);
                        this.buttons[i][j].field_146124_l = false;
                        break;
                    }
                    case 3: {
                        this.buttons[i][j] = new GuiButton(id++, btnX, btnY, 20, 20, "X");
                        this.buttons[i][j].field_146124_l = false;
                    }
                }
                this.field_146292_n.add(this.buttons[i][j]);
            }
            BlockPos sentryPos = new BlockPos(coords[0], coords[1], coords[2]);
            if (coords[0] == 0 && coords[1] == 0 && coords[2] == 0) continue;
            this.buttons[i][3].field_146124_l = true;
            if (Minecraft.func_71410_x().field_71439_g.field_70170_p.func_175668_a(sentryPos, false) && this.isSentryVisibleToPlayer(sentryPos)) {
                List sentries = Minecraft.func_71410_x().field_71439_g.field_70170_p.func_72872_a(EntitySentry.class, new AxisAlignedBB(sentryPos));
                if (!sentries.isEmpty()) {
                    boolean idleMode;
                    EntitySentry sentry = (EntitySentry)((Object)sentries.get(0));
                    boolean aggressiveMode = sentry.getMode() == EntitySentry.EnumSentryMode.AGGRESSIVE;
                    boolean camouflageMode = sentry.getMode() == EntitySentry.EnumSentryMode.CAMOUFLAGE;
                    boolean bl = idleMode = sentry.getMode() == EntitySentry.EnumSentryMode.IDLE;
                    if (sentry.func_145818_k_()) {
                        this.names[i] = sentry.func_95999_t();
                    }
                    this.buttons[i][0].field_146124_l = !aggressiveMode;
                    this.buttons[i][1].field_146124_l = !camouflageMode;
                    this.buttons[i][2].field_146124_l = !idleMode;
                    this.hoverCheckers.add(new StringHoverChecker(this.buttons[i][0], 20, ClientUtils.localize("gui.securitycraft:srat.mode1", new Object[0])));
                    this.hoverCheckers.add(new StringHoverChecker(this.buttons[i][1], 20, ClientUtils.localize("gui.securitycraft:srat.mode2", new Object[0])));
                    this.hoverCheckers.add(new StringHoverChecker(this.buttons[i][2], 20, ClientUtils.localize("gui.securitycraft:srat.mode3", new Object[0])));
                    this.hoverCheckers.add(new StringHoverChecker(this.buttons[i][3], 20, ClientUtils.localize("gui.securitycraft:srat.unbind", new Object[0])));
                    foundSentry = true;
                    continue;
                }
                this.removeTagFromToolAndUpdate(this.srat, coords[0], coords[1], coords[2]);
                for (int j = 0; j < 4; ++j) {
                    this.buttons[i][j].field_146124_l = false;
                }
                continue;
            }
            for (int j = 0; j < 3; ++j) {
                this.hoverCheckers.add(new StringHoverChecker(this.buttons[i][j], 20, ClientUtils.localize("gui.securitycraft:srat.outOfRange", new Object[0])));
            }
            this.hoverCheckers.add(new StringHoverChecker(this.buttons[i][3], 20, ClientUtils.localize("gui.securitycraft:srat.unbind", new Object[0])));
        }
        this.buttonsGlobal[0][0] = new GuiPictureButton(1000, this.field_147003_i + 260, this.field_147009_r + 188, 20, 20, SENTRY_ICONS, -2, -1, 18, 18);
        this.buttonsGlobal[0][1] = new GuiPictureButton(1001, this.field_147003_i + 22 + 260, this.field_147009_r + 188, 20, 20, SENTRY_ICONS, 40, -1, 18, 18);
        this.buttonsGlobal[0][2] = new GuiPictureButton(1002, this.field_147003_i + 44 + 260, this.field_147009_r + 188, 20, 20, SENTRY_ICONS, 19, -1, 18, 17);
        for (int j = 0; j < 3; ++j) {
            this.buttonsGlobal[0][j].field_146124_l = foundSentry;
            this.field_146292_n.add(this.buttonsGlobal[0][j]);
            this.hoverCheckers.add(new StringHoverChecker(this.buttonsGlobal[0][0], 20, ClientUtils.localize("gui.securitycraft:srat.mode1", new Object[0])));
            this.hoverCheckers.add(new StringHoverChecker(this.buttonsGlobal[0][1], 20, ClientUtils.localize("gui.securitycraft:srat.mode2", new Object[0])));
            this.hoverCheckers.add(new StringHoverChecker(this.buttonsGlobal[0][2], 20, ClientUtils.localize("gui.securitycraft:srat.mode3", new Object[0])));
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        String modifyAll = ClientUtils.localize("gui.securitycraft:srat.modifyAll", new Object[0]);
        this.field_146289_q.func_78276_b(ClientUtils.localize("item.securitycraft:remoteAccessSentry.name", new Object[0]), 5, -12, 0xFF0000);
        for (int i = 0; i < 12; ++i) {
            int[] coords = this.getSentryCoordinates(i);
            String line = coords[0] == 0 && coords[1] == 0 && coords[2] == 0 ? ClientUtils.localize("gui.securitycraft:srat.notBound", new Object[0]) : (this.names[i] != null ? this.names[i] : Utils.getFormattedCoordinates(new BlockPos(coords[0], coords[1], coords[2])));
            this.field_146289_q.func_78276_b(line, this.field_146999_f / 4 - this.field_146289_q.func_78256_a(line) + 15 + i / 6 * this.field_146999_f / 2, i % 6 * 30 + 13, 0x404040);
            this.field_146289_q.func_78276_b(modifyAll, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(modifyAll) + 25, 194, 0x404040);
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.func_146276_q_();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(TEXTURE);
        int startX = (this.field_146294_l - this.field_146999_f) / 2;
        int startY = (this.field_146295_m - this.field_147000_g) / 2;
        GuiSRAT.func_146110_a((int)startX, (int)startY, (float)0.0f, (float)0.0f, (int)this.field_146999_f, (int)this.field_147000_g, (float)512.0f, (float)256.0f);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        for (StringHoverChecker chc : this.hoverCheckers) {
            if (chc == null || !chc.checkHover(mouseX, mouseY) || chc.getName() == null) continue;
            this.drawHoveringText(chc.getLines(), mouseX, mouseY, this.field_146289_q);
        }
    }

    protected void performSingleAction(int sentry, int mode, boolean sendMessage) {
        int[] coords = this.getSentryCoordinates(sentry);
        List sentries = Minecraft.func_71410_x().field_71439_g.field_70170_p.func_72872_a(EntitySentry.class, new AxisAlignedBB(new BlockPos(coords[0], coords[1], coords[2])));
        if (!sentries.isEmpty()) {
            switch (mode) {
                case 0: {
                    ((EntitySentry)((Object)sentries.get(0))).toggleMode((EntityPlayer)Minecraft.func_71410_x().field_71439_g, 0, sendMessage);
                    SecurityCraft.network.sendToServer((IMessage)new PacketSetSentryMode(((EntitySentry)((Object)sentries.get(0))).func_180425_c(), mode, sendMessage));
                    this.buttons[sentry][0].field_146124_l = false;
                    this.buttons[sentry][1].field_146124_l = true;
                    this.buttons[sentry][2].field_146124_l = true;
                    break;
                }
                case 1: {
                    ((EntitySentry)((Object)sentries.get(0))).toggleMode((EntityPlayer)Minecraft.func_71410_x().field_71439_g, 1, sendMessage);
                    SecurityCraft.network.sendToServer((IMessage)new PacketSetSentryMode(((EntitySentry)((Object)sentries.get(0))).func_180425_c(), mode, sendMessage));
                    this.buttons[sentry][0].field_146124_l = true;
                    this.buttons[sentry][1].field_146124_l = false;
                    this.buttons[sentry][2].field_146124_l = true;
                    break;
                }
                case 2: {
                    ((EntitySentry)((Object)sentries.get(0))).toggleMode((EntityPlayer)Minecraft.func_71410_x().field_71439_g, 2, sendMessage);
                    SecurityCraft.network.sendToServer((IMessage)new PacketSetSentryMode(((EntitySentry)((Object)sentries.get(0))).func_180425_c(), mode, sendMessage));
                    this.buttons[sentry][0].field_146124_l = true;
                    this.buttons[sentry][1].field_146124_l = true;
                    this.buttons[sentry][2].field_146124_l = false;
                }
            }
        }
        if (mode == 3) {
            int i;
            this.removeTagFromToolAndUpdate(this.srat, coords[0], coords[1], coords[2]);
            for (i = 0; i < 4; ++i) {
                this.buttons[sentry][i].field_146124_l = false;
            }
            for (i = 0; i < this.buttons.length; ++i) {
                if (!this.buttons[i][3].field_146124_l) continue;
                return;
            }
            for (i = 0; i < 3; ++i) {
                this.buttonsGlobal[0][i].field_146124_l = false;
            }
        }
    }

    protected void forceMode(GuiButton button, int mode, boolean sendMessage) {
        int sentry = button.field_146127_k / 4;
        this.performSingleAction(sentry, mode, sendMessage);
    }

    protected void func_146284_a(GuiButton button) {
        int sentry = button.field_146127_k / 4;
        int mode = button.field_146127_k % 4;
        boolean messageSent = false;
        if (sentry > 100) {
            for (int i = 0; i < this.field_146292_n.size() / 4; ++i) {
                if (this.getSentryCoordinates(i)[1] == 0) continue;
                this.forceMode((GuiButton)this.field_146292_n.get(i * 4), mode, !messageSent);
                messageSent = true;
            }
            return;
        }
        this.performSingleAction(sentry, mode, true);
    }

    private int[] getSentryCoordinates(int sentry) {
        if (this.srat.func_77973_b() != null && this.srat.func_77973_b() == SCContent.remoteAccessSentry && this.srat.func_77978_p() != null && this.srat.func_77978_p().func_74759_k("sentry" + ++sentry) != null && this.srat.func_77978_p().func_74759_k("sentry" + sentry).length > 0) {
            return this.srat.func_77978_p().func_74759_k("sentry" + sentry);
        }
        return new int[]{0, 0, 0};
    }

    private void removeTagFromToolAndUpdate(ItemStack stack, int x, int y, int z) {
        if (stack.func_77978_p() == null) {
            return;
        }
        for (int i = 1; i <= 12; ++i) {
            int[] coords;
            if (stack.func_77978_p().func_74759_k("sentry" + i).length <= 0 || (coords = stack.func_77978_p().func_74759_k("sentry" + i))[0] != x || coords[1] != y || coords[2] != z) continue;
            stack.func_77978_p().func_74783_a("sentry" + i, new int[]{0, 0, 0});
            SecurityCraft.network.sendToServer((IMessage)new PacketSUpdateNBTTag(stack));
            return;
        }
    }

    private boolean isSentryVisibleToPlayer(BlockPos sentryPos) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        double d0 = player.field_70165_t - (double)sentryPos.func_177958_n();
        double d1 = player.field_70161_v - (double)sentryPos.func_177952_p();
        int i = Math.min(256, this.viewDistance) - 1;
        return d0 >= (double)(-i) && d0 <= (double)i && d1 >= (double)(-i) && d1 <= (double)i;
    }
}

