/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.gui.components;

import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraftforge.fml.client.config.GuiButtonExt;

public class GuiSlider
extends GuiButtonExt {
    public double sliderValue;
    public String dispString = "";
    public boolean dragging = false;
    public boolean showDecimal = true;
    public double minValue = 0.0;
    public double maxValue = 5.0;
    public int precision = 1;
    @Nullable
    public ISlider parent = null;
    public boolean drawString = true;
    private String blockName;
    public String prefix;

    public GuiSlider(int id, int xPos, int yPos, int width, int height, String prefix, double minVal, double maxVal, double currentVal, boolean showDec, boolean drawStr) {
        this("whyareyoudoingthis", "seriouslywhy", id, xPos, yPos, width, height, prefix, minVal, maxVal, currentVal, showDec, drawStr, null);
    }

    public GuiSlider(String initialString, String bN, int id, int xPos, int yPos, int width, int height, String prefix, int minVal, int maxVal, int currentVal, boolean showDec, boolean drawStr, @Nullable ISlider par) {
        this(initialString, bN, id, xPos, yPos, width, height, prefix, (double)minVal, (double)maxVal, (double)currentVal, showDec, drawStr, par);
    }

    public GuiSlider(String initialString, String bN, int id, int xPos, int yPos, int width, int height, String prefix, double minVal, double maxVal, double currentVal, boolean showDec, boolean drawStr, @Nullable ISlider par) {
        super(id, xPos, yPos, width, height, prefix);
        this.minValue = minVal;
        this.maxValue = maxVal;
        this.dispString = prefix;
        this.parent = par;
        this.showDecimal = showDec;
        this.blockName = bN;
        this.sliderValue = (currentVal - minVal) / (maxVal - minVal);
        this.prefix = prefix;
        if (this.showDecimal) {
            String val = Double.toString(this.getValue());
            this.precision = Math.min(val.substring(val.indexOf(46) + 1).length(), 4);
        } else {
            String val = Integer.toString(this.getValueInt());
            this.precision = 0;
        }
        this.field_146126_j = initialString;
        this.drawString = drawStr;
        if (!this.drawString) {
            this.field_146126_j = "";
        }
    }

    public GuiSlider(int id, int xPos, int yPos, String displayStr, double minVal, double maxVal, double currentVal, ISlider par) {
        this("whyareyoudoingthis", "seriouslywhy", id, xPos, yPos, 150, 20, displayStr, minVal, maxVal, currentVal, true, true, par);
    }

    public int func_146114_a(boolean par1) {
        return 0;
    }

    protected void func_146119_b(Minecraft mc, int mouseX, int mouseY) {
        if (this.field_146125_m) {
            if (this.dragging) {
                this.sliderValue = (double)(mouseX - (this.field_146128_h + 4)) / (double)(this.field_146120_f - 8);
                this.updateSlider();
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.func_73729_b(this.field_146128_h + (int)(this.sliderValue * (double)(this.field_146120_f - 8)), this.field_146129_i, 0, 66, 4, 20);
            this.func_73729_b(this.field_146128_h + (int)(this.sliderValue * (double)(this.field_146120_f - 8)) + 4, this.field_146129_i, 196, 66, 4, 20);
        }
    }

    public boolean func_146116_c(Minecraft mc, int mouseX, int mouseY) {
        if (super.func_146116_c(mc, mouseX, mouseY)) {
            this.sliderValue = (double)(mouseX - (this.field_146128_h + 4)) / (double)(this.field_146120_f - 8);
            this.updateSlider();
            this.dragging = true;
            return true;
        }
        return false;
    }

    public void updateSlider() {
        if (this.sliderValue < 0.0) {
            this.sliderValue = 0.0;
        }
        if (this.sliderValue > 1.0) {
            this.sliderValue = 1.0;
        }
        if (this.showDecimal) {
            String val = Double.toString(this.getValue());
            if (val.substring(val.indexOf(46) + 1).length() > this.precision) {
                if ((val = val.substring(0, val.indexOf(46) + this.precision + 1)).endsWith(".")) {
                    val = val.substring(0, val.indexOf(46) + this.precision);
                }
            } else {
                while (val.substring(val.indexOf(46) + 1).length() < this.precision) {
                    val = val + "0";
                }
            }
        } else {
            String val = Integer.toString(this.getValueInt());
        }
        if (this.parent != null) {
            this.parent.onChangeSliderValue(this, this.blockName, this.field_146127_k);
        }
    }

    public void func_146118_a(int mouseX, int mouseY) {
        this.dragging = false;
        this.parent.onMouseRelease(this.field_146127_k);
    }

    public int getValueInt() {
        return (int)Math.round(this.getValue());
    }

    public double getValue() {
        return this.sliderValue * (this.maxValue - this.minValue) + this.minValue;
    }

    public static interface ISlider {
        public void onChangeSliderValue(GuiSlider var1, String var2, int var3);

        public void onMouseRelease(int var1);
    }
}

