/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.items;

import java.util.ArrayList;
import java.util.List;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.misc.CameraView;
import net.geforcemods.securitycraft.misc.EnumModuleType;
import net.geforcemods.securitycraft.network.packets.PacketCUpdateNBTTag;
import net.geforcemods.securitycraft.tileentity.TileEntitySecurityCamera;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemCameraMonitor
extends Item {
    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            if (BlockUtils.getBlock((IBlockAccess)world, pos) == SCContent.securityCamera && !PlayerUtils.isPlayerMountedOnCamera((EntityLivingBase)player)) {
                if (!((IOwnable)world.func_175625_s(pos)).getOwner().isOwner(player) && !((TileEntitySecurityCamera)world.func_175625_s(pos)).hasModule(EnumModuleType.SMART)) {
                    PlayerUtils.sendMessageToPlayer(player, ClientUtils.localize("item.securitycraft:cameraMonitor.name", new Object[0]), ClientUtils.localize("messages.securitycraft:cameraMonitor.cannotView", new Object[0]), TextFormatting.RED);
                    return EnumActionResult.SUCCESS;
                }
                if (stack.func_77978_p() == null) {
                    stack.func_77982_d(new NBTTagCompound());
                }
                CameraView view = new CameraView(pos, player.field_71093_bK);
                if (this.isCameraAdded(stack.func_77978_p(), view)) {
                    stack.func_77978_p().func_82580_o(ItemCameraMonitor.getTagNameFromPosition(stack.func_77978_p(), view));
                    PlayerUtils.sendMessageToPlayer(player, ClientUtils.localize("item.securitycraft:cameraMonitor.name", new Object[0]), ClientUtils.localize("messages.securitycraft:cameraMonitor.unbound", new Object[0]).replace("#", Utils.getFormattedCoordinates(pos)), TextFormatting.RED);
                    return EnumActionResult.SUCCESS;
                }
                for (int i = 1; i <= 30; ++i) {
                    if (stack.func_77978_p().func_74764_b("Camera" + i)) continue;
                    stack.func_77978_p().func_74778_a("Camera" + i, view.toNBTString());
                    PlayerUtils.sendMessageToPlayer(player, ClientUtils.localize("item.securitycraft:cameraMonitor.name", new Object[0]), ClientUtils.localize("messages.securitycraft:cameraMonitor.bound", new Object[0]).replace("#", Utils.getFormattedCoordinates(pos)), TextFormatting.GREEN);
                    break;
                }
                SecurityCraft.network.sendTo((IMessage)new PacketCUpdateNBTTag(stack), (EntityPlayerMP)player);
                return EnumActionResult.SUCCESS;
            }
        } else if (world.field_72995_K && (BlockUtils.getBlock((IBlockAccess)world, pos) != SCContent.securityCamera || PlayerUtils.isPlayerMountedOnCamera((EntityLivingBase)player))) {
            if (stack.func_77978_p() == null || stack.func_77978_p().func_82582_d()) {
                PlayerUtils.sendMessageToPlayer(player, ClientUtils.localize("item.securitycraft:cameraMonitor.name", new Object[0]), ClientUtils.localize("messages.securitycraft:cameraMonitor.rightclickToView", new Object[0]), TextFormatting.RED);
                return EnumActionResult.SUCCESS;
            }
            player.openGui((Object)SecurityCraft.instance, 12, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.SUCCESS;
    }

    @SideOnly(value=Side.CLIENT)
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (world.field_72995_K) {
            if (!stack.func_77942_o() || !this.hasCameraAdded(stack.func_77978_p())) {
                PlayerUtils.sendMessageToPlayer(player, ClientUtils.localize("item.securitycraft:cameraMonitor.name", new Object[0]), ClientUtils.localize("messages.securitycraft:cameraMonitor.rightclickToView", new Object[0]), TextFormatting.RED);
                return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)stack);
            }
            player.openGui((Object)SecurityCraft.instance, 12, world, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        if (stack.func_77978_p() == null) {
            return;
        }
        tooltip.add(ClientUtils.localize("tooltip.securitycraft:cameraMonitor", new Object[0]) + " " + this.getNumberOfCamerasBound(stack.func_77978_p()) + "/30");
    }

    public static String getTagNameFromPosition(NBTTagCompound tag, CameraView view) {
        for (int i = 1; i <= 30; ++i) {
            String[] coords;
            if (!tag.func_74764_b("Camera" + i) || !view.checkCoordinates(coords = tag.func_74779_i("Camera" + i).split(" "))) continue;
            return "Camera" + i;
        }
        return "";
    }

    public boolean hasCameraAdded(NBTTagCompound tag) {
        if (tag == null) {
            return false;
        }
        for (int i = 1; i <= 30; ++i) {
            if (!tag.func_74764_b("Camera" + i)) continue;
            return true;
        }
        return false;
    }

    public boolean isCameraAdded(NBTTagCompound tag, CameraView view) {
        for (int i = 1; i <= 30; ++i) {
            String[] coords;
            if (!tag.func_74764_b("Camera" + i) || !view.checkCoordinates(coords = tag.func_74779_i("Camera" + i).split(" "))) continue;
            return true;
        }
        return false;
    }

    public ArrayList<CameraView> getCameraPositions(NBTTagCompound tag) {
        ArrayList<CameraView> list = new ArrayList<CameraView>();
        for (int i = 1; i <= 30; ++i) {
            if (tag != null && tag.func_74764_b("Camera" + i)) {
                String[] coords = tag.func_74779_i("Camera" + i).split(" ");
                list.add(new CameraView(Integer.parseInt(coords[0]), Integer.parseInt(coords[1]), Integer.parseInt(coords[2]), coords.length == 4 ? Integer.parseInt(coords[3]) : 0));
                continue;
            }
            list.add(null);
        }
        return list;
    }

    public int getNumberOfCamerasBound(NBTTagCompound tag) {
        if (tag == null) {
            return 0;
        }
        int amount = 0;
        for (int i = 1; i <= 31; ++i) {
            if (!tag.func_74764_b("Camera" + i)) continue;
            ++amount;
        }
        return amount;
    }
}

