/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.items;

import com.google.common.base.Predicate;
import java.util.Optional;
import javax.annotation.Nullable;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.misc.CustomDamageSources;
import net.geforcemods.securitycraft.misc.SCSounds;
import net.geforcemods.securitycraft.network.packets.PacketCPlaySoundAtPos;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ItemTaser
extends Item {
    public boolean powered;

    public ItemTaser(boolean isPowered) {
        this.powered = isPowered;
        this.func_77656_e(151);
        this.func_77637_a(SecurityCraft.tabSCTechnical);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (!(tab != SecurityCraft.tabSCTechnical && tab != CreativeTabs.field_78027_g || this.powered)) {
            items.add((Object)new ItemStack((Item)this));
        }
    }

    public boolean func_77662_d() {
        return true;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged || oldStack.func_77973_b() == SCContent.taser && newStack.func_77973_b() == SCContent.taserPowered || oldStack.func_77973_b() == SCContent.taserPowered && newStack.func_77973_b() == SCContent.taser;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K && !stack.func_77951_h()) {
            EntityLivingBase entity;
            if (player.func_70093_af() && (player.func_184812_l_() || !this.powered)) {
                ItemStack oneRedstone = new ItemStack(Items.field_151137_ax, 1);
                if (player.func_184812_l_()) {
                    if (player.func_184586_b(hand).func_77973_b() == SCContent.taser) {
                        this.setSlotBasedOnHand(player, hand, new ItemStack(SCContent.taserPowered, 1));
                    } else {
                        this.setSlotBasedOnHand(player, hand, new ItemStack(SCContent.taser, 1));
                    }
                } else if (player.field_71071_by.func_70431_c(oneRedstone)) {
                    int redstoneSlot = player.field_71071_by.func_194014_c(oneRedstone);
                    ItemStack redstoneStack = player.field_71071_by.func_70301_a(redstoneSlot);
                    redstoneStack.func_190920_e(redstoneStack.func_190916_E() - 1);
                    player.field_71071_by.func_70299_a(redstoneSlot, redstoneStack);
                    this.setSlotBasedOnHand(player, hand, new ItemStack(SCContent.taserPowered, 1));
                }
                return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)stack);
            }
            int range = 11;
            Vec3d startVec = new Vec3d(player.field_70165_t, player.field_70163_u + (double)player.eyeHeight, player.field_70161_v);
            Vec3d lookVec = player.func_70676_i(1.0f).func_186678_a((double)range);
            Vec3d endVec = startVec.func_178787_e(lookVec);
            AxisAlignedBB boundingBox = player.func_174813_aQ().func_72321_a(lookVec.field_72450_a, lookVec.field_72448_b, lookVec.field_72449_c).func_72314_b(1.0, 1.0, 1.0);
            RayTraceResult entityRayTraceResult = ItemTaser.rayTraceEntities((Entity)player, startVec, endVec, boundingBox, (Predicate<? super Entity>)((Predicate)s -> s instanceof EntityLivingBase), range * range);
            SecurityCraft.network.sendToAll((IMessage)new PacketCPlaySoundAtPos(player.field_70165_t, player.field_70163_u, player.field_70161_v, SCSounds.TASERFIRED.path, 1.0, "player"));
            if (entityRayTraceResult != null && !(entity = (EntityLivingBase)entityRayTraceResult.field_72308_g).func_184585_cz() && entity.func_70097_a(CustomDamageSources.TASER, this.powered ? 2.0f : 1.0f)) {
                int strength = this.powered ? 4 : 1;
                int length = this.powered ? 400 : 200;
                entity.func_70690_d(new PotionEffect(Potion.func_180142_b((String)"weakness"), length, strength));
                entity.func_70690_d(new PotionEffect(Potion.func_180142_b((String)"nausea"), length, strength));
                entity.func_70690_d(new PotionEffect(Potion.func_180142_b((String)"slowness"), length, strength));
            }
            if (!player.func_184812_l_()) {
                if (this.powered) {
                    ItemStack taser = new ItemStack(SCContent.taser, 1);
                    taser.func_77972_a(150, (EntityLivingBase)player);
                    this.setSlotBasedOnHand(player, hand, taser);
                } else {
                    stack.func_77972_a(150, (EntityLivingBase)player);
                }
            }
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)stack);
    }

    private static RayTraceResult rayTraceEntities(Entity shooter, Vec3d startVec, Vec3d endVec, AxisAlignedBB boundingBox, Predicate<? super Entity> filter, double dist) {
        World world = shooter.field_70170_p;
        double distance = dist;
        Entity rayTracedEntity = null;
        Vec3d hitVec = null;
        for (Entity entity : world.func_175674_a(shooter, boundingBox, filter)) {
            Vec3d vector;
            double sqDist;
            AxisAlignedBB boxToCheck = entity.func_174813_aQ().func_186662_g((double)entity.func_70111_Y());
            Optional<Vec3d> optional = ItemTaser.rayTrace(boxToCheck, startVec, endVec);
            if (boxToCheck.func_72318_a(startVec)) {
                if (!(distance >= 0.0)) continue;
                rayTracedEntity = entity;
                hitVec = optional.orElse(startVec);
                distance = 0.0;
                continue;
            }
            if (!optional.isPresent() || !((sqDist = startVec.func_72436_e(vector = optional.get())) < distance) && distance != 0.0) continue;
            if (entity.func_184208_bv() == shooter.func_184208_bv() && !entity.canRiderInteract()) {
                if (distance != 0.0) continue;
                rayTracedEntity = entity;
                hitVec = vector;
                continue;
            }
            rayTracedEntity = entity;
            hitVec = vector;
            distance = sqDist;
        }
        return rayTracedEntity == null ? null : new RayTraceResult(rayTracedEntity, hitVec);
    }

    private static Optional<Vec3d> rayTrace(AxisAlignedBB aabb, Vec3d startVec, Vec3d endVec) {
        double[] adouble = new double[]{1.0};
        double d0 = endVec.field_72450_a - startVec.field_72450_a;
        double d1 = endVec.field_72448_b - startVec.field_72448_b;
        double d2 = endVec.field_72449_c - startVec.field_72449_c;
        EnumFacing EnumFacing2 = ItemTaser.func_197741_a(aabb, startVec, adouble, null, d0, d1, d2);
        if (EnumFacing2 == null) {
            return Optional.empty();
        }
        double d3 = adouble[0];
        return Optional.of(startVec.func_72441_c(d3 * d0, d3 * d1, d3 * d2));
    }

    private static EnumFacing func_197741_a(AxisAlignedBB aabb, Vec3d p_197741_1_, double[] p_197741_2_, @Nullable EnumFacing facing, double p_197741_4_, double p_197741_6_, double p_197741_8_) {
        if (p_197741_4_ > 1.0E-7) {
            facing = ItemTaser.func_197740_a(p_197741_2_, facing, p_197741_4_, p_197741_6_, p_197741_8_, aabb.field_72340_a, aabb.field_72338_b, aabb.field_72337_e, aabb.field_72339_c, aabb.field_72334_f, EnumFacing.WEST, p_197741_1_.field_72450_a, p_197741_1_.field_72448_b, p_197741_1_.field_72449_c);
        } else if (p_197741_4_ < -1.0E-7) {
            facing = ItemTaser.func_197740_a(p_197741_2_, facing, p_197741_4_, p_197741_6_, p_197741_8_, aabb.field_72336_d, aabb.field_72338_b, aabb.field_72337_e, aabb.field_72339_c, aabb.field_72334_f, EnumFacing.EAST, p_197741_1_.field_72450_a, p_197741_1_.field_72448_b, p_197741_1_.field_72449_c);
        }
        if (p_197741_6_ > 1.0E-7) {
            facing = ItemTaser.func_197740_a(p_197741_2_, facing, p_197741_6_, p_197741_8_, p_197741_4_, aabb.field_72338_b, aabb.field_72339_c, aabb.field_72334_f, aabb.field_72340_a, aabb.field_72336_d, EnumFacing.DOWN, p_197741_1_.field_72448_b, p_197741_1_.field_72449_c, p_197741_1_.field_72450_a);
        } else if (p_197741_6_ < -1.0E-7) {
            facing = ItemTaser.func_197740_a(p_197741_2_, facing, p_197741_6_, p_197741_8_, p_197741_4_, aabb.field_72337_e, aabb.field_72339_c, aabb.field_72334_f, aabb.field_72340_a, aabb.field_72336_d, EnumFacing.UP, p_197741_1_.field_72448_b, p_197741_1_.field_72449_c, p_197741_1_.field_72450_a);
        }
        if (p_197741_8_ > 1.0E-7) {
            facing = ItemTaser.func_197740_a(p_197741_2_, facing, p_197741_8_, p_197741_4_, p_197741_6_, aabb.field_72339_c, aabb.field_72340_a, aabb.field_72336_d, aabb.field_72338_b, aabb.field_72337_e, EnumFacing.NORTH, p_197741_1_.field_72449_c, p_197741_1_.field_72450_a, p_197741_1_.field_72448_b);
        } else if (p_197741_8_ < -1.0E-7) {
            facing = ItemTaser.func_197740_a(p_197741_2_, facing, p_197741_8_, p_197741_4_, p_197741_6_, aabb.field_72334_f, aabb.field_72340_a, aabb.field_72336_d, aabb.field_72338_b, aabb.field_72337_e, EnumFacing.SOUTH, p_197741_1_.field_72449_c, p_197741_1_.field_72450_a, p_197741_1_.field_72448_b);
        }
        return facing;
    }

    private static EnumFacing func_197740_a(double[] p_197740_0_, @Nullable EnumFacing p_197740_1_, double p_197740_2_, double p_197740_4_, double p_197740_6_, double p_197740_8_, double p_197740_10_, double p_197740_12_, double p_197740_14_, double p_197740_16_, EnumFacing p_197740_18_, double p_197740_19_, double p_197740_21_, double p_197740_23_) {
        double d0 = (p_197740_8_ - p_197740_19_) / p_197740_2_;
        double d1 = p_197740_21_ + d0 * p_197740_4_;
        double d2 = p_197740_23_ + d0 * p_197740_6_;
        if (0.0 < d0 && d0 < p_197740_0_[0] && p_197740_10_ - 1.0E-7 < d1 && d1 < p_197740_12_ + 1.0E-7 && p_197740_14_ - 1.0E-7 < d2 && d2 < p_197740_16_ + 1.0E-7) {
            p_197740_0_[0] = d0;
            return p_197740_18_;
        }
        return p_197740_1_;
    }

    private void setSlotBasedOnHand(EntityPlayer player, EnumHand hand, ItemStack taser) {
        if (hand == EnumHand.MAIN_HAND) {
            player.func_184201_a(EntityEquipmentSlot.MAINHAND, taser);
        } else {
            player.func_184201_a(EntityEquipmentSlot.OFFHAND, taser);
        }
    }

    public void func_77663_a(ItemStack par1ItemStack, World world, Entity entity, int slotIndex, boolean isSelected) {
        if (!world.field_72995_K && par1ItemStack.func_77952_i() >= 1) {
            par1ItemStack.func_77964_b(par1ItemStack.func_77952_i() - 1);
        }
    }

    public boolean func_77616_k(ItemStack stack) {
        return false;
    }
}

