/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.packets;

import io.netty.buffer.ByteBuf;
import net.geforcemods.securitycraft.api.IExplosive;
import net.geforcemods.securitycraft.network.packets.PacketHelper;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.WorldUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketSetExplosiveState
implements IMessage {
    private int x;
    private int y;
    private int z;
    private String state;

    public PacketSetExplosiveState() {
    }

    public PacketSetExplosiveState(int x, int y, int z, String state) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.state = state;
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.state = ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.state);
    }

    public static class Handler
    extends PacketHelper
    implements IMessageHandler<PacketSetExplosiveState, IMessage> {
        public IMessage onMessage(PacketSetExplosiveState message, MessageContext context) {
            WorldUtils.addScheduledTask(this.getWorld((EntityPlayer)context.getServerHandler().field_147369_b), () -> {
                EntityPlayerMP player = context.getServerHandler().field_147369_b;
                if (BlockUtils.getBlock(this.getWorld((EntityPlayer)player), message.x, message.y, message.z) instanceof IExplosive) {
                    if (message.state.equalsIgnoreCase("activate")) {
                        ((IExplosive)BlockUtils.getBlock(this.getWorld((EntityPlayer)player), message.x, message.y, message.z)).activateMine(this.getWorld((EntityPlayer)player), BlockUtils.toPos(message.x, message.y, message.z));
                    } else if (message.state.equalsIgnoreCase("defuse")) {
                        ((IExplosive)BlockUtils.getBlock(this.getWorld((EntityPlayer)player), message.x, message.y, message.z)).defuseMine(this.getWorld((EntityPlayer)player), BlockUtils.toPos(message.x, message.y, message.z));
                    } else if (message.state.equalsIgnoreCase("detonate")) {
                        ((IExplosive)BlockUtils.getBlock(this.getWorld((EntityPlayer)player), message.x, message.y, message.z)).explode(this.getWorld((EntityPlayer)player), BlockUtils.toPos(message.x, message.y, message.z));
                    }
                }
            });
            return null;
        }
    }
}

