/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.renderers;

import net.geforcemods.securitycraft.blocks.BlockProjector;
import net.geforcemods.securitycraft.tileentity.TileEntityProjector;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class TileEntityProjectorRenderer
extends TileEntitySpecialRenderer<TileEntityProjector> {
    public void render(TileEntityProjector te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        if (!te.isActive()) {
            return;
        }
        if (!te.func_191420_l()) {
            EnumFacing facing = (EnumFacing)te.func_145831_w().func_180495_p(te.func_174877_v()).func_177229_b((IProperty)BlockProjector.FACING);
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)x, (double)y, (double)(z + 1.0));
            Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
            for (int i = 0; i < te.getProjectionWidth(); ++i) {
                for (int j = 0; j < te.getProjectionWidth(); ++j) {
                    GlStateManager.func_179094_E();
                    BlockPos pos = this.translateProjection(te, facing, i, j, te.getProjectionRange(), te.getProjectionOffset());
                    if (pos != null && !te.func_145831_w().func_175623_d(pos)) {
                        GlStateManager.func_179121_F();
                        continue;
                    }
                    BlockRendererDispatcher blockRendererDispatcher = Minecraft.func_71410_x().func_175602_ab();
                    IBlockState state = te.getProjectedBlock().func_176223_P();
                    GlStateManager.func_179129_p();
                    GlStateManager.func_179139_a((double)0.9999, (double)0.9999, (double)0.9999);
                    blockRendererDispatcher.func_175016_a(state, te.func_145831_w().func_175724_o(pos));
                    GlStateManager.func_179089_o();
                    GlStateManager.func_179121_F();
                }
            }
            GlStateManager.func_179121_F();
        }
    }

    private BlockPos translateProjection(TileEntityProjector te, EnumFacing direction, int x, int y, double distance, double offset) {
        BlockPos pos;
        if (direction == EnumFacing.NORTH) {
            pos = new BlockPos((double)(te.func_174877_v().func_177958_n() + x) + offset, (double)(te.func_174877_v().func_177956_o() + y), (double)te.func_174877_v().func_177952_p() + distance);
            GlStateManager.func_179137_b((double)(0.0 + (double)x + offset), (double)(0.0 + (double)y), (double)distance);
        } else if (direction == EnumFacing.SOUTH) {
            pos = new BlockPos((double)(te.func_174877_v().func_177958_n() + x) + offset, (double)(te.func_174877_v().func_177956_o() + y), (double)te.func_174877_v().func_177952_p() + -distance);
            GlStateManager.func_179137_b((double)(0.0 + (double)x + offset), (double)(0.0 + (double)y), (double)(-distance));
        } else if (direction == EnumFacing.WEST) {
            pos = new BlockPos((double)te.func_174877_v().func_177958_n() + distance, (double)(te.func_174877_v().func_177956_o() + y), (double)(te.func_174877_v().func_177952_p() + x) + offset);
            GlStateManager.func_179137_b((double)distance, (double)(0.0 + (double)y), (double)(0.0 + (double)x + offset));
        } else if (direction == EnumFacing.EAST) {
            pos = new BlockPos((double)te.func_174877_v().func_177958_n() + -distance, (double)(te.func_174877_v().func_177956_o() + y), (double)(te.func_174877_v().func_177952_p() + x) + offset);
            GlStateManager.func_179137_b((double)(-distance), (double)(0.0 + (double)y), (double)(0.0 + (double)x + offset));
        } else {
            return te.func_174877_v();
        }
        return pos;
    }

    public boolean isGlobalRenderer(TileEntityProjector te) {
        return true;
    }
}

